/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.RecordError;
import software.amazon.awssdk.services.servicecatalog.model.RecordErrorsCopier;
import software.amazon.awssdk.services.servicecatalog.model.RecordStatus;
import software.amazon.awssdk.services.servicecatalog.model.RecordTag;
import software.amazon.awssdk.services.servicecatalog.model.RecordTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordDetail> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(RecordDetail.getter(RecordDetail::recordId)).setter(RecordDetail.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductName").getter(RecordDetail.getter(RecordDetail::provisionedProductName)).setter(RecordDetail.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RecordDetail.getter(RecordDetail::statusAsString)).setter(RecordDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(RecordDetail.getter(RecordDetail::createdTime)).setter(RecordDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(RecordDetail.getter(RecordDetail::updatedTime)).setter(RecordDetail.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductType").getter(RecordDetail.getter(RecordDetail::provisionedProductType)).setter(RecordDetail.setter(Builder::provisionedProductType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductType").build()}).build();
    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordType").getter(RecordDetail.getter(RecordDetail::recordType)).setter(RecordDetail.setter(Builder::recordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordType").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductId").getter(RecordDetail.getter(RecordDetail::provisionedProductId)).setter(RecordDetail.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(RecordDetail.getter(RecordDetail::productId)).setter(RecordDetail.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(RecordDetail.getter(RecordDetail::provisioningArtifactId)).setter(RecordDetail.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathId").getter(RecordDetail.getter(RecordDetail::pathId)).setter(RecordDetail.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<List<RecordError>> RECORD_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordErrors").getter(RecordDetail.getter(RecordDetail::recordErrors)).setter(RecordDetail.setter(Builder::recordErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecordTag>> RECORD_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordTags").getter(RecordDetail.getter(RecordDetail::recordTags)).setter(RecordDetail.setter(Builder::recordTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchRoleArn").getter(RecordDetail.getter(RecordDetail::launchRoleArn)).setter(RecordDetail.setter(Builder::launchRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD, PROVISIONED_PRODUCT_TYPE_FIELD, RECORD_TYPE_FIELD, PROVISIONED_PRODUCT_ID_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD, RECORD_ERRORS_FIELD, RECORD_TAGS_FIELD, LAUNCH_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recordId;
    private final String provisionedProductName;
    private final String status;
    private final Instant createdTime;
    private final Instant updatedTime;
    private final String provisionedProductType;
    private final String recordType;
    private final String provisionedProductId;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final List<RecordError> recordErrors;
    private final List<RecordTag> recordTags;
    private final String launchRoleArn;

    private RecordDetail(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.provisionedProductName = builder.provisionedProductName;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.provisionedProductType = builder.provisionedProductType;
        this.recordType = builder.recordType;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.recordErrors = builder.recordErrors;
        this.recordTags = builder.recordTags;
        this.launchRoleArn = builder.launchRoleArn;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final String provisionedProductName() {
        return this.provisionedProductName;
    }

    public final RecordStatus status() {
        return RecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant updatedTime() {
        return this.updatedTime;
    }

    public final String provisionedProductType() {
        return this.provisionedProductType;
    }

    public final String recordType() {
        return this.recordType;
    }

    public final String provisionedProductId() {
        return this.provisionedProductId;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String pathId() {
        return this.pathId;
    }

    public final boolean hasRecordErrors() {
        return this.recordErrors != null && !(this.recordErrors instanceof SdkAutoConstructList);
    }

    public final List<RecordError> recordErrors() {
        return this.recordErrors;
    }

    public final boolean hasRecordTags() {
        return this.recordTags != null && !(this.recordTags instanceof SdkAutoConstructList);
    }

    public final List<RecordTag> recordTags() {
        return this.recordTags;
    }

    public final String launchRoleArn() {
        return this.launchRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductType());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordType());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordErrors() ? this.recordErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordTags() ? this.recordTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordDetail)) {
            return false;
        }
        RecordDetail other = (RecordDetail)obj;
        return Objects.equals(this.recordId(), other.recordId()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.updatedTime(), other.updatedTime()) && Objects.equals(this.provisionedProductType(), other.provisionedProductType()) && Objects.equals(this.recordType(), other.recordType()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pathId(), other.pathId()) && this.hasRecordErrors() == other.hasRecordErrors() && Objects.equals(this.recordErrors(), other.recordErrors()) && this.hasRecordTags() == other.hasRecordTags() && Objects.equals(this.recordTags(), other.recordTags()) && Objects.equals(this.launchRoleArn(), other.launchRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"RecordDetail").add("RecordId", (Object)this.recordId()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("UpdatedTime", (Object)this.updatedTime()).add("ProvisionedProductType", (Object)this.provisionedProductType()).add("RecordType", (Object)this.recordType()).add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("PathId", (Object)this.pathId()).add("RecordErrors", this.hasRecordErrors() ? this.recordErrors() : null).add("RecordTags", this.hasRecordTags() ? this.recordTags() : null).add("LaunchRoleArn", (Object)this.launchRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "ProvisionedProductType": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductType()));
            }
            case "RecordType": {
                return Optional.ofNullable(clazz.cast(this.recordType()));
            }
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "RecordErrors": {
                return Optional.ofNullable(clazz.cast(this.recordErrors()));
            }
            case "RecordTags": {
                return Optional.ofNullable(clazz.cast(this.recordTags()));
            }
            case "LaunchRoleArn": {
                return Optional.ofNullable(clazz.cast(this.launchRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordDetail, T> g) {
        return obj -> g.apply((RecordDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordId;
        private String provisionedProductName;
        private String status;
        private Instant createdTime;
        private Instant updatedTime;
        private String provisionedProductType;
        private String recordType;
        private String provisionedProductId;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private List<RecordError> recordErrors = DefaultSdkAutoConstructList.getInstance();
        private List<RecordTag> recordTags = DefaultSdkAutoConstructList.getInstance();
        private String launchRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordDetail model) {
            this.recordId(model.recordId);
            this.provisionedProductName(model.provisionedProductName);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
            this.provisionedProductType(model.provisionedProductType);
            this.recordType(model.recordType);
            this.provisionedProductId(model.provisionedProductId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
            this.recordErrors(model.recordErrors);
            this.recordTags(model.recordTags);
            this.launchRoleArn(model.launchRoleArn);
        }

        public final String getRecordId() {
            return this.recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        public final String getProvisionedProductType() {
            return this.provisionedProductType;
        }

        @Override
        public final Builder provisionedProductType(String provisionedProductType) {
            this.provisionedProductType = provisionedProductType;
            return this;
        }

        public final void setProvisionedProductType(String provisionedProductType) {
            this.provisionedProductType = provisionedProductType;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final Collection<RecordError.Builder> getRecordErrors() {
            if (this.recordErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordErrors != null ? (Collection)this.recordErrors.stream().map(RecordError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordErrors(Collection<RecordError> recordErrors) {
            this.recordErrors = RecordErrorsCopier.copy(recordErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordErrors(RecordError ... recordErrors) {
            this.recordErrors(Arrays.asList(recordErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordErrors(Consumer<RecordError.Builder> ... recordErrors) {
            this.recordErrors(Stream.of(recordErrors).map(c -> (RecordError)((RecordError.Builder)RecordError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordErrors(Collection<RecordError.BuilderImpl> recordErrors) {
            this.recordErrors = RecordErrorsCopier.copyFromBuilder(recordErrors);
        }

        public final Collection<RecordTag.Builder> getRecordTags() {
            if (this.recordTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordTags != null ? (Collection)this.recordTags.stream().map(RecordTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordTags(Collection<RecordTag> recordTags) {
            this.recordTags = RecordTagsCopier.copy(recordTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordTags(RecordTag ... recordTags) {
            this.recordTags(Arrays.asList(recordTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordTags(Consumer<RecordTag.Builder> ... recordTags) {
            this.recordTags(Stream.of(recordTags).map(c -> (RecordTag)((RecordTag.Builder)RecordTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecordTags(Collection<RecordTag.BuilderImpl> recordTags) {
            this.recordTags = RecordTagsCopier.copyFromBuilder(recordTags);
        }

        public final String getLaunchRoleArn() {
            return this.launchRoleArn;
        }

        @Override
        public final Builder launchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
            return this;
        }

        public final void setLaunchRoleArn(String launchRoleArn) {
            this.launchRoleArn = launchRoleArn;
        }

        public RecordDetail build() {
            return new RecordDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordDetail> {
        public Builder recordId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder status(String var1);

        public Builder status(RecordStatus var1);

        public Builder createdTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder provisionedProductType(String var1);

        public Builder recordType(String var1);

        public Builder provisionedProductId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder recordErrors(Collection<RecordError> var1);

        public Builder recordErrors(RecordError ... var1);

        public Builder recordErrors(Consumer<RecordError.Builder> ... var1);

        public Builder recordTags(Collection<RecordTag> var1);

        public Builder recordTags(RecordTag ... var1);

        public Builder recordTags(Consumer<RecordTag.Builder> ... var1);

        public Builder launchRoleArn(String var1);
    }
}

