/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisionedProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateProvisionedProductRequest.Builder, UpdateProvisionedProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(UpdateProvisionedProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductName").getter(getter(UpdateProvisionedProductRequest::provisionedProductName))
            .setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId").getter(getter(UpdateProvisionedProductRequest::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(UpdateProvisionedProductRequest::productId))
            .setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductName").getter(getter(UpdateProvisionedProductRequest::productName))
            .setter(setter(Builder::productName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactId").getter(getter(UpdateProvisionedProductRequest::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningArtifactName").getter(getter(UpdateProvisionedProductRequest::provisioningArtifactName))
            .setter(setter(Builder::provisioningArtifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactName").build())
            .build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PathId")
            .getter(getter(UpdateProvisionedProductRequest::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<String> PATH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PathName").getter(getter(UpdateProvisionedProductRequest::pathName)).setter(setter(Builder::pathName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathName").build()).build();

    private static final SdkField<List<UpdateProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<UpdateProvisioningParameter>> builder(MarshallingType.LIST)
            .memberName("ProvisioningParameters")
            .getter(getter(UpdateProvisionedProductRequest::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UpdateProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField
            .<UpdateProvisioningPreferences> builder(MarshallingType.SDK_POJO).memberName("ProvisioningPreferences")
            .getter(getter(UpdateProvisionedProductRequest::provisioningPreferences))
            .setter(setter(Builder::provisioningPreferences)).constructor(UpdateProvisioningPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UpdateProvisionedProductRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken")
            .getter(getter(UpdateProvisionedProductRequest::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONED_PRODUCT_ID_FIELD, PRODUCT_ID_FIELD, PRODUCT_NAME_FIELD,
            PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_ARTIFACT_NAME_FIELD, PATH_ID_FIELD, PATH_NAME_FIELD,
            PROVISIONING_PARAMETERS_FIELD, PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, UPDATE_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String provisionedProductName;

    private final String provisionedProductId;

    private final String productId;

    private final String productName;

    private final String provisioningArtifactId;

    private final String provisioningArtifactName;

    private final String pathId;

    private final String pathName;

    private final List<UpdateProvisioningParameter> provisioningParameters;

    private final UpdateProvisioningPreferences provisioningPreferences;

    private final List<Tag> tags;

    private final String updateToken;

    private UpdateProvisionedProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.productId = builder.productId;
        this.productName = builder.productName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningArtifactName = builder.provisioningArtifactName;
        this.pathId = builder.pathId;
        this.pathName = builder.pathName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.updateToken = builder.updateToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
     * <code>ProvisionedProductId</code>.
     * </p>
     * 
     * @return The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
     *         <code>ProvisionedProductId</code>.
     */
    public final String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * <p>
     * The identifier of the provisioned product. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The identifier of the provisioned product. You must provide the name or ID, but not both.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * The identifier of the product. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The identifier of the product. You must provide the name or ID, but not both.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * The name of the product. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the product. You must provide the name or ID, but not both.
     */
    public final String productName() {
        return productName;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public final String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The name of the provisioning artifact. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the provisioning artifact. You must provide the name or ID, but not both.
     */
    public final String provisioningArtifactName() {
        return provisioningArtifactName;
    }

    /**
     * <p>
     * The path identifier. This value is optional if the product has a default path, and required if the product has
     * more than one path. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The path identifier. This value is optional if the product has a default path, and required if the
     *         product has more than one path. You must provide the name or ID, but not both.
     */
    public final String pathId() {
        return pathId;
    }

    /**
     * <p>
     * The name of the path. You must provide the name or ID, but not both.
     * </p>
     * 
     * @return The name of the path. You must provide the name or ID, but not both.
     */
    public final String pathName() {
        return pathName;
    }

    /**
     * Returns true if the ProvisioningParameters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new parameters.
     */
    public final List<UpdateProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    /**
     * <p>
     * An object that contains information about the provisioning preferences for a stack set.
     * </p>
     * 
     * @return An object that contains information about the provisioning preferences for a stack set.
     */
    public final UpdateProvisioningPreferences provisioningPreferences() {
        return provisioningPreferences;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
     * <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
     *         <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The idempotency token that uniquely identifies the provisioning update request.
     * </p>
     * 
     * @return The idempotency token that uniquely identifies the provisioning update request.
     */
    public final String updateToken() {
        return updateToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productName());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactName());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(pathName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningParameters() ? provisioningParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductRequest)) {
            return false;
        }
        UpdateProvisionedProductRequest other = (UpdateProvisionedProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(provisionedProductName(), other.provisionedProductName())
                && Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(productId(), other.productId()) && Objects.equals(productName(), other.productName())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(provisioningArtifactName(), other.provisioningArtifactName())
                && Objects.equals(pathId(), other.pathId()) && Objects.equals(pathName(), other.pathName())
                && hasProvisioningParameters() == other.hasProvisioningParameters()
                && Objects.equals(provisioningParameters(), other.provisioningParameters())
                && Objects.equals(provisioningPreferences(), other.provisioningPreferences()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(updateToken(), other.updateToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProvisionedProductRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProvisionedProductName", provisionedProductName()).add("ProvisionedProductId", provisionedProductId())
                .add("ProductId", productId()).add("ProductName", productName())
                .add("ProvisioningArtifactId", provisioningArtifactId())
                .add("ProvisioningArtifactName", provisioningArtifactName()).add("PathId", pathId()).add("PathName", pathName())
                .add("ProvisioningParameters", hasProvisioningParameters() ? provisioningParameters() : null)
                .add("ProvisioningPreferences", provisioningPreferences()).add("Tags", hasTags() ? tags() : null)
                .add("UpdateToken", updateToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProductName":
            return Optional.ofNullable(clazz.cast(productName()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "ProvisioningArtifactName":
            return Optional.ofNullable(clazz.cast(provisioningArtifactName()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "PathName":
            return Optional.ofNullable(clazz.cast(pathName()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        case "ProvisioningPreferences":
            return Optional.ofNullable(clazz.cast(provisioningPreferences()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProvisionedProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
         * <code>ProvisionedProductId</code>.
         * </p>
         * 
         * @param provisionedProductName
         *        The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
         *        <code>ProvisionedProductId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * The identifier of the provisioned product. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisionedProductId
         *        The identifier of the provisioned product. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * The identifier of the product. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param productId
         *        The identifier of the product. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The name of the product. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param productName
         *        The name of the product. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productName(String productName);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The name of the provisioning artifact. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param provisioningArtifactName
         *        The name of the provisioning artifact. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactName(String provisioningArtifactName);

        /**
         * <p>
         * The path identifier. This value is optional if the product has a default path, and required if the product
         * has more than one path. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param pathId
         *        The path identifier. This value is optional if the product has a default path, and required if the
         *        product has more than one path. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * The name of the path. You must provide the name or ID, but not both.
         * </p>
         * 
         * @param pathName
         *        The name of the path. You must provide the name or ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathName(String pathName);

        /**
         * <p>
         * The new parameters.
         * </p>
         * 
         * @param provisioningParameters
         *        The new parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * The new parameters.
         * </p>
         * 
         * @param provisioningParameters
         *        The new parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(UpdateProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * The new parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateProvisioningParameter>.Builder}
         * avoiding the need to create one manually via {@link List<UpdateProvisioningParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateProvisioningParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningParameters(List<UpdateProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on {@link List<UpdateProvisioningParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(List<UpdateProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder>... provisioningParameters);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * 
         * @param provisioningPreferences
         *        An object that contains information about the provisioning preferences for a stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningPreferences(UpdateProvisioningPreferences provisioningPreferences);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateProvisioningPreferences.Builder} avoiding
         * the need to create one manually via {@link UpdateProvisioningPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateProvisioningPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningPreferences(UpdateProvisioningPreferences)}.
         * 
         * @param provisioningPreferences
         *        a consumer that will call methods on {@link UpdateProvisioningPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningPreferences(UpdateProvisioningPreferences)
         */
        default Builder provisioningPreferences(Consumer<UpdateProvisioningPreferences.Builder> provisioningPreferences) {
            return provisioningPreferences(UpdateProvisioningPreferences.builder().applyMutation(provisioningPreferences).build());
        }

        /**
         * <p>
         * One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
         * <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
         * </p>
         * 
         * @param tags
         *        One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
         *        <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
         * <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
         * </p>
         * 
         * @param tags
         *        One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
         *        <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags. Requires the product to have <code>RESOURCE_UPDATE</code> constraint with
         * <code>TagUpdatesOnProvisionedProduct</code> set to <code>ALLOWED</code> to allow tag updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The idempotency token that uniquely identifies the provisioning update request.
         * </p>
         * 
         * @param updateToken
         *        The idempotency token that uniquely identifies the provisioning update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String provisionedProductName;

        private String provisionedProductId;

        private String productId;

        private String productName;

        private String provisioningArtifactId;

        private String provisioningArtifactName;

        private String pathId;

        private String pathName;

        private List<UpdateProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private UpdateProvisioningPreferences provisioningPreferences;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String updateToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            provisionedProductName(model.provisionedProductName);
            provisionedProductId(model.provisionedProductId);
            productId(model.productId);
            productName(model.productName);
            provisioningArtifactId(model.provisioningArtifactId);
            provisioningArtifactName(model.provisioningArtifactName);
            pathId(model.pathId);
            pathName(model.pathName);
            provisioningParameters(model.provisioningParameters);
            provisioningPreferences(model.provisioningPreferences);
            tags(model.tags);
            updateToken(model.updateToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProductName() {
            return productName;
        }

        @Override
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getProvisioningArtifactName() {
            return provisioningArtifactName;
        }

        @Override
        public final Builder provisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
            return this;
        }

        public final void setProvisioningArtifactName(String provisioningArtifactName) {
            this.provisioningArtifactName = provisioningArtifactName;
        }

        public final String getPathId() {
            return pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getPathName() {
            return pathName;
        }

        @Override
        public final Builder pathName(String pathName) {
            this.pathName = pathName;
            return this;
        }

        public final void setPathName(String pathName) {
            this.pathName = pathName;
        }

        public final Collection<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            if (provisioningParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return provisioningParameters != null ? provisioningParameters.stream().map(UpdateProvisioningParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> UpdateProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final UpdateProvisioningPreferences.Builder getProvisioningPreferences() {
            return provisioningPreferences != null ? provisioningPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningPreferences(UpdateProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final void setProvisioningPreferences(UpdateProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedProductRequest build() {
            return new UpdateProvisionedProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
