/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateProvisionedProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<TerminateProvisionedProductRequest.Builder, TerminateProvisionedProductRequest> {
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductName").getter(getter(TerminateProvisionedProductRequest::provisionedProductName))
            .setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId").getter(getter(TerminateProvisionedProductRequest::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<String> TERMINATE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TerminateToken")
            .getter(getter(TerminateProvisionedProductRequest::terminateToken))
            .setter(setter(Builder::terminateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> IGNORE_ERRORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IgnoreErrors").getter(getter(TerminateProvisionedProductRequest::ignoreErrors))
            .setter(setter(Builder::ignoreErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreErrors").build()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(TerminateProvisionedProductRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<Boolean> RETAIN_PHYSICAL_RESOURCES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainPhysicalResources").getter(getter(TerminateProvisionedProductRequest::retainPhysicalResources))
            .setter(setter(Builder::retainPhysicalResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainPhysicalResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONED_PRODUCT_ID_FIELD, TERMINATE_TOKEN_FIELD, IGNORE_ERRORS_FIELD,
            ACCEPT_LANGUAGE_FIELD, RETAIN_PHYSICAL_RESOURCES_FIELD));

    private final String provisionedProductName;

    private final String provisionedProductId;

    private final String terminateToken;

    private final Boolean ignoreErrors;

    private final String acceptLanguage;

    private final Boolean retainPhysicalResources;

    private TerminateProvisionedProductRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedProductName = builder.provisionedProductName;
        this.provisionedProductId = builder.provisionedProductId;
        this.terminateToken = builder.terminateToken;
        this.ignoreErrors = builder.ignoreErrors;
        this.acceptLanguage = builder.acceptLanguage;
        this.retainPhysicalResources = builder.retainPhysicalResources;
    }

    /**
     * <p>
     * The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
     * <code>ProvisionedProductId</code>.
     * </p>
     * 
     * @return The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
     *         <code>ProvisionedProductId</code>.
     */
    public final String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * <p>
     * The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
     * <code>ProvisionedProductId</code>.
     * </p>
     * 
     * @return The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code>
     *         and <code>ProvisionedProductId</code>.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * An idempotency token that uniquely identifies the termination request. This token is only valid during the
     * termination process. After the provisioned product is terminated, subsequent requests to terminate the same
     * provisioned product always return <b>ResourceNotFound</b>.
     * </p>
     * 
     * @return An idempotency token that uniquely identifies the termination request. This token is only valid during
     *         the termination process. After the provisioned product is terminated, subsequent requests to terminate
     *         the same provisioned product always return <b>ResourceNotFound</b>.
     */
    public final String terminateToken() {
        return terminateToken;
    }

    /**
     * <p>
     * If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the
     * underlying resources.
     * </p>
     * 
     * @return If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot
     *         delete the underlying resources.
     */
    public final Boolean ignoreErrors() {
        return ignoreErrors;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the Service
     * Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying
     * resources of the deleted provisioned product. The default value is false.
     * </p>
     * 
     * @return When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the
     *         Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or
     *         the underlying resources of the deleted provisioned product. The default value is false.
     */
    public final Boolean retainPhysicalResources() {
        return retainPhysicalResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(terminateToken());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreErrors());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(retainPhysicalResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateProvisionedProductRequest)) {
            return false;
        }
        TerminateProvisionedProductRequest other = (TerminateProvisionedProductRequest) obj;
        return Objects.equals(provisionedProductName(), other.provisionedProductName())
                && Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(terminateToken(), other.terminateToken())
                && Objects.equals(ignoreErrors(), other.ignoreErrors())
                && Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(retainPhysicalResources(), other.retainPhysicalResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminateProvisionedProductRequest").add("ProvisionedProductName", provisionedProductName())
                .add("ProvisionedProductId", provisionedProductId()).add("TerminateToken", terminateToken())
                .add("IgnoreErrors", ignoreErrors()).add("AcceptLanguage", acceptLanguage())
                .add("RetainPhysicalResources", retainPhysicalResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "TerminateToken":
            return Optional.ofNullable(clazz.cast(terminateToken()));
        case "IgnoreErrors":
            return Optional.ofNullable(clazz.cast(ignoreErrors()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "RetainPhysicalResources":
            return Optional.ofNullable(clazz.cast(retainPhysicalResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateProvisionedProductRequest, T> g) {
        return obj -> g.apply((TerminateProvisionedProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TerminateProvisionedProductRequest> {
        /**
         * <p>
         * The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
         * <code>ProvisionedProductId</code>.
         * </p>
         * 
         * @param provisionedProductName
         *        The name of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
         *        <code>ProvisionedProductId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code> and
         * <code>ProvisionedProductId</code>.
         * </p>
         * 
         * @param provisionedProductId
         *        The identifier of the provisioned product. You cannot specify both <code>ProvisionedProductName</code>
         *        and <code>ProvisionedProductId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * An idempotency token that uniquely identifies the termination request. This token is only valid during the
         * termination process. After the provisioned product is terminated, subsequent requests to terminate the same
         * provisioned product always return <b>ResourceNotFound</b>.
         * </p>
         * 
         * @param terminateToken
         *        An idempotency token that uniquely identifies the termination request. This token is only valid during
         *        the termination process. After the provisioned product is terminated, subsequent requests to terminate
         *        the same provisioned product always return <b>ResourceNotFound</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateToken(String terminateToken);

        /**
         * <p>
         * If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete
         * the underlying resources.
         * </p>
         * 
         * @param ignoreErrors
         *        If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot
         *        delete the underlying resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreErrors(Boolean ignoreErrors);

        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes the
         * Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the
         * underlying resources of the deleted provisioned product. The default value is false.
         * </p>
         * 
         * @param retainPhysicalResources
         *        When this boolean parameter is set to true, the <code>TerminateProvisionedProduct</code> API deletes
         *        the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack
         *        set, or the underlying resources of the deleted provisioned product. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainPhysicalResources(Boolean retainPhysicalResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String provisionedProductName;

        private String provisionedProductId;

        private String terminateToken;

        private Boolean ignoreErrors;

        private String acceptLanguage;

        private Boolean retainPhysicalResources;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateProvisionedProductRequest model) {
            super(model);
            provisionedProductName(model.provisionedProductName);
            provisionedProductId(model.provisionedProductId);
            terminateToken(model.terminateToken);
            ignoreErrors(model.ignoreErrors);
            acceptLanguage(model.acceptLanguage);
            retainPhysicalResources(model.retainPhysicalResources);
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getTerminateToken() {
            return terminateToken;
        }

        @Override
        public final Builder terminateToken(String terminateToken) {
            this.terminateToken = terminateToken;
            return this;
        }

        public final void setTerminateToken(String terminateToken) {
            this.terminateToken = terminateToken;
        }

        public final Boolean getIgnoreErrors() {
            return ignoreErrors;
        }

        @Override
        public final Builder ignoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        public final void setIgnoreErrors(Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final Boolean getRetainPhysicalResources() {
            return retainPhysicalResources;
        }

        @Override
        public final Builder retainPhysicalResources(Boolean retainPhysicalResources) {
            this.retainPhysicalResources = retainPhysicalResources;
            return this;
        }

        public final void setRetainPhysicalResources(Boolean retainPhysicalResources) {
            this.retainPhysicalResources = retainPhysicalResources;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateProvisionedProductRequest build() {
            return new TerminateProvisionedProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
