/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchProductsResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<SearchProductsResponse.Builder, SearchProductsResponse> {
    private static final SdkField<List<ProductViewSummary>> PRODUCT_VIEW_SUMMARIES_FIELD = SdkField
            .<List<ProductViewSummary>> builder(MarshallingType.LIST)
            .memberName("ProductViewSummaries")
            .getter(getter(SearchProductsResponse::productViewSummaries))
            .setter(setter(Builder::productViewSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductViewSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductViewSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ProductViewAggregationValue>>> PRODUCT_VIEW_AGGREGATIONS_FIELD = SdkField
            .<Map<String, List<ProductViewAggregationValue>>> builder(MarshallingType.MAP)
            .memberName("ProductViewAggregations")
            .getter(getter(SearchProductsResponse::productViewAggregations))
            .setter(setter(Builder::productViewAggregations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewAggregations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ProductViewAggregationValue>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ProductViewAggregationValue> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(ProductViewAggregationValue::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(SearchProductsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARIES_FIELD,
            PRODUCT_VIEW_AGGREGATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<ProductViewSummary> productViewSummaries;

    private final Map<String, List<ProductViewAggregationValue>> productViewAggregations;

    private final String nextPageToken;

    private SearchProductsResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummaries = builder.productViewSummaries;
        this.productViewAggregations = builder.productViewAggregations;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ProductViewSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProductViewSummaries() {
        return productViewSummaries != null && !(productViewSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the product views.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductViewSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the product views.
     */
    public final List<ProductViewSummary> productViewSummaries() {
        return productViewSummaries;
    }

    /**
     * Returns true if the ProductViewAggregations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProductViewAggregations() {
        return productViewAggregations != null && !(productViewAggregations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The product view aggregations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductViewAggregations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The product view aggregations.
     */
    public final Map<String, List<ProductViewAggregationValue>> productViewAggregations() {
        return productViewAggregations;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProductViewSummaries() ? productViewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProductViewAggregations() ? productViewAggregations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsResponse)) {
            return false;
        }
        SearchProductsResponse other = (SearchProductsResponse) obj;
        return hasProductViewSummaries() == other.hasProductViewSummaries()
                && Objects.equals(productViewSummaries(), other.productViewSummaries())
                && hasProductViewAggregations() == other.hasProductViewAggregations()
                && Objects.equals(productViewAggregations(), other.productViewAggregations())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchProductsResponse")
                .add("ProductViewSummaries", hasProductViewSummaries() ? productViewSummaries() : null)
                .add("ProductViewAggregations", hasProductViewAggregations() ? productViewAggregations() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewSummaries":
            return Optional.ofNullable(clazz.cast(productViewSummaries()));
        case "ProductViewAggregations":
            return Optional.ofNullable(clazz.cast(productViewAggregations()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsResponse, T> g) {
        return obj -> g.apply((SearchProductsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchProductsResponse> {
        /**
         * <p>
         * Information about the product views.
         * </p>
         * 
         * @param productViewSummaries
         *        Information about the product views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummaries(Collection<ProductViewSummary> productViewSummaries);

        /**
         * <p>
         * Information about the product views.
         * </p>
         * 
         * @param productViewSummaries
         *        Information about the product views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummaries(ProductViewSummary... productViewSummaries);

        /**
         * <p>
         * Information about the product views.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductViewSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ProductViewSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductViewSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #productViewSummaries(List<ProductViewSummary>)}.
         * 
         * @param productViewSummaries
         *        a consumer that will call methods on {@link List<ProductViewSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewSummaries(List<ProductViewSummary>)
         */
        Builder productViewSummaries(Consumer<ProductViewSummary.Builder>... productViewSummaries);

        /**
         * <p>
         * The product view aggregations.
         * </p>
         * 
         * @param productViewAggregations
         *        The product view aggregations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProductViewSummary> productViewSummaries = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<ProductViewAggregationValue>> productViewAggregations = DefaultSdkAutoConstructMap.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsResponse model) {
            super(model);
            productViewSummaries(model.productViewSummaries);
            productViewAggregations(model.productViewAggregations);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewSummary.Builder> getProductViewSummaries() {
            if (productViewSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return productViewSummaries != null ? productViewSummaries.stream().map(ProductViewSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copy(productViewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(ProductViewSummary... productViewSummaries) {
            productViewSummaries(Arrays.asList(productViewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(Consumer<ProductViewSummary.Builder>... productViewSummaries) {
            productViewSummaries(Stream.of(productViewSummaries).map(c -> ProductViewSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductViewSummaries(Collection<ProductViewSummary.BuilderImpl> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copyFromBuilder(productViewSummaries);
        }

        public final Map<String, ? extends Collection<ProductViewAggregationValue>> getProductViewAggregations() {
            if (productViewAggregations instanceof SdkAutoConstructMap) {
                return null;
            }
            return productViewAggregations;
        }

        @Override
        public final Builder productViewAggregations(
                Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
            return this;
        }

        public final void setProductViewAggregations(
                Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsResponse build() {
            return new SearchProductsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
