/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagOptionsResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListTagOptionsResponse.Builder, ListTagOptionsResponse> {
    private static final SdkField<List<TagOptionDetail>> TAG_OPTION_DETAILS_FIELD = SdkField
            .<List<TagOptionDetail>> builder(MarshallingType.LIST)
            .memberName("TagOptionDetails")
            .getter(getter(ListTagOptionsResponse::tagOptionDetails))
            .setter(setter(Builder::tagOptionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagOptionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagOptionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListTagOptionsResponse::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_OPTION_DETAILS_FIELD,
            PAGE_TOKEN_FIELD));

    private final List<TagOptionDetail> tagOptionDetails;

    private final String pageToken;

    private ListTagOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.tagOptionDetails = builder.tagOptionDetails;
        this.pageToken = builder.pageToken;
    }

    /**
     * Returns true if the TagOptionDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTagOptionDetails() {
        return tagOptionDetails != null && !(tagOptionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the TagOptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagOptionDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the TagOptions.
     */
    public final List<TagOptionDetail> tagOptionDetails() {
        return tagOptionDetails;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTagOptionDetails() ? tagOptionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagOptionsResponse)) {
            return false;
        }
        ListTagOptionsResponse other = (ListTagOptionsResponse) obj;
        return hasTagOptionDetails() == other.hasTagOptionDetails()
                && Objects.equals(tagOptionDetails(), other.tagOptionDetails()) && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagOptionsResponse")
                .add("TagOptionDetails", hasTagOptionDetails() ? tagOptionDetails() : null).add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagOptionDetails":
            return Optional.ofNullable(clazz.cast(tagOptionDetails()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagOptionsResponse, T> g) {
        return obj -> g.apply((ListTagOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagOptionsResponse> {
        /**
         * <p>
         * Information about the TagOptions.
         * </p>
         * 
         * @param tagOptionDetails
         *        Information about the TagOptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptionDetails(Collection<TagOptionDetail> tagOptionDetails);

        /**
         * <p>
         * Information about the TagOptions.
         * </p>
         * 
         * @param tagOptionDetails
         *        Information about the TagOptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptionDetails(TagOptionDetail... tagOptionDetails);

        /**
         * <p>
         * Information about the TagOptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagOptionDetail>.Builder} avoiding the need
         * to create one manually via {@link List<TagOptionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagOptionDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagOptionDetails(List<TagOptionDetail>)}.
         * 
         * @param tagOptionDetails
         *        a consumer that will call methods on {@link List<TagOptionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptionDetails(List<TagOptionDetail>)
         */
        Builder tagOptionDetails(Consumer<TagOptionDetail.Builder>... tagOptionDetails);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<TagOptionDetail> tagOptionDetails = DefaultSdkAutoConstructList.getInstance();

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagOptionsResponse model) {
            super(model);
            tagOptionDetails(model.tagOptionDetails);
            pageToken(model.pageToken);
        }

        public final Collection<TagOptionDetail.Builder> getTagOptionDetails() {
            if (tagOptionDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return tagOptionDetails != null ? tagOptionDetails.stream().map(TagOptionDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptionDetails(Collection<TagOptionDetail> tagOptionDetails) {
            this.tagOptionDetails = TagOptionDetailsCopier.copy(tagOptionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptionDetails(TagOptionDetail... tagOptionDetails) {
            tagOptionDetails(Arrays.asList(tagOptionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptionDetails(Consumer<TagOptionDetail.Builder>... tagOptionDetails) {
            tagOptionDetails(Stream.of(tagOptionDetails).map(c -> TagOptionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptionDetails(Collection<TagOptionDetail.BuilderImpl> tagOptionDetails) {
            this.tagOptionDetails = TagOptionDetailsCopier.copyFromBuilder(tagOptionDetails);
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public ListTagOptionsResponse build() {
            return new ListTagOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
