/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a product path for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchPathSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchPathSummary.Builder, LaunchPathSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(LaunchPathSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<ConstraintSummary>> CONSTRAINT_SUMMARIES_FIELD = SdkField
            .<List<ConstraintSummary>> builder(MarshallingType.LIST)
            .memberName("ConstraintSummaries")
            .getter(getter(LaunchPathSummary::constraintSummaries))
            .setter(setter(Builder::constraintSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConstraintSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConstraintSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(LaunchPathSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(LaunchPathSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CONSTRAINT_SUMMARIES_FIELD, TAGS_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<ConstraintSummary> constraintSummaries;

    private final List<Tag> tags;

    private final String name;

    private LaunchPathSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.constraintSummaries = builder.constraintSummaries;
        this.tags = builder.tags;
        this.name = builder.name;
    }

    /**
     * <p>
     * The identifier of the product path.
     * </p>
     * 
     * @return The identifier of the product path.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns true if the ConstraintSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasConstraintSummaries() {
        return constraintSummaries != null && !(constraintSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The constraints on the portfolio-product relationship.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConstraintSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The constraints on the portfolio-product relationship.
     */
    public final List<ConstraintSummary> constraintSummaries() {
        return constraintSummaries;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with this product path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with this product path.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the portfolio to which the user was assigned.
     * </p>
     * 
     * @return The name of the portfolio to which the user was assigned.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasConstraintSummaries() ? constraintSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPathSummary)) {
            return false;
        }
        LaunchPathSummary other = (LaunchPathSummary) obj;
        return Objects.equals(id(), other.id()) && hasConstraintSummaries() == other.hasConstraintSummaries()
                && Objects.equals(constraintSummaries(), other.constraintSummaries()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchPathSummary").add("Id", id())
                .add("ConstraintSummaries", hasConstraintSummaries() ? constraintSummaries() : null)
                .add("Tags", hasTags() ? tags() : null).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ConstraintSummaries":
            return Optional.ofNullable(clazz.cast(constraintSummaries()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchPathSummary, T> g) {
        return obj -> g.apply((LaunchPathSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchPathSummary> {
        /**
         * <p>
         * The identifier of the product path.
         * </p>
         * 
         * @param id
         *        The identifier of the product path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The constraints on the portfolio-product relationship.
         * </p>
         * 
         * @param constraintSummaries
         *        The constraints on the portfolio-product relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries);

        /**
         * <p>
         * The constraints on the portfolio-product relationship.
         * </p>
         * 
         * @param constraintSummaries
         *        The constraints on the portfolio-product relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintSummaries(ConstraintSummary... constraintSummaries);

        /**
         * <p>
         * The constraints on the portfolio-product relationship.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConstraintSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ConstraintSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConstraintSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #constraintSummaries(List<ConstraintSummary>)}.
         * 
         * @param constraintSummaries
         *        a consumer that will call methods on {@link List<ConstraintSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintSummaries(List<ConstraintSummary>)
         */
        Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries);

        /**
         * <p>
         * The tags associated with this product path.
         * </p>
         * 
         * @param tags
         *        The tags associated with this product path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with this product path.
         * </p>
         * 
         * @param tags
         *        The tags associated with this product path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with this product path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of the portfolio to which the user was assigned.
         * </p>
         * 
         * @param name
         *        The name of the portfolio to which the user was assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<ConstraintSummary> constraintSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPathSummary model) {
            id(model.id);
            constraintSummaries(model.constraintSummaries);
            tags(model.tags);
            name(model.name);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<ConstraintSummary.Builder> getConstraintSummaries() {
            if (constraintSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return constraintSummaries != null ? constraintSummaries.stream().map(ConstraintSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder constraintSummaries(Collection<ConstraintSummary> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copy(constraintSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(ConstraintSummary... constraintSummaries) {
            constraintSummaries(Arrays.asList(constraintSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintSummaries(Consumer<ConstraintSummary.Builder>... constraintSummaries) {
            constraintSummaries(Stream.of(constraintSummaries).map(c -> ConstraintSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConstraintSummaries(Collection<ConstraintSummary.BuilderImpl> constraintSummaries) {
            this.constraintSummaries = ConstraintSummariesCopier.copyFromBuilder(constraintSummaries);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public LaunchPathSummary build() {
            return new LaunchPathSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
