/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProvisionedProductOutputsRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<GetProvisionedProductOutputsRequest.Builder, GetProvisionedProductOutputsRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(GetProvisionedProductOutputsRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId").getter(getter(GetProvisionedProductOutputsRequest::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductName").getter(getter(GetProvisionedProductOutputsRequest::provisionedProductName))
            .setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutputKeys")
            .getter(getter(GetProvisionedProductOutputsRequest::outputKeys))
            .setter(setter(Builder::outputKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(GetProvisionedProductOutputsRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(GetProvisionedProductOutputsRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PROVISIONED_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, OUTPUT_KEYS_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String provisionedProductId;

    private final String provisionedProductName;

    private final List<String> outputKeys;

    private final Integer pageSize;

    private final String pageToken;

    private GetProvisionedProductOutputsRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductName = builder.provisionedProductName;
        this.outputKeys = builder.outputKeys;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The identifier of the provisioned product that you want the outputs from.
     * </p>
     * 
     * @return The identifier of the provisioned product that you want the outputs from.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * The name of the provisioned product that you want the outputs from.
     * </p>
     * 
     * @return The name of the provisioned product that you want the outputs from.
     */
    public final String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * Returns true if the OutputKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputKeys() {
        return outputKeys != null && !(outputKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of keys that the API should return with their values. If none are provided, the API will return all
     * outputs of the provisioned product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of keys that the API should return with their values. If none are provided, the API will return
     *         all outputs of the provisioned product.
     */
    public final List<String> outputKeys() {
        return outputKeys;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputKeys() ? outputKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProvisionedProductOutputsRequest)) {
            return false;
        }
        GetProvisionedProductOutputsRequest other = (GetProvisionedProductOutputsRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(provisionedProductName(), other.provisionedProductName())
                && hasOutputKeys() == other.hasOutputKeys() && Objects.equals(outputKeys(), other.outputKeys())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProvisionedProductOutputsRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProvisionedProductId", provisionedProductId()).add("ProvisionedProductName", provisionedProductName())
                .add("OutputKeys", hasOutputKeys() ? outputKeys() : null).add("PageSize", pageSize())
                .add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "OutputKeys":
            return Optional.ofNullable(clazz.cast(outputKeys()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProvisionedProductOutputsRequest, T> g) {
        return obj -> g.apply((GetProvisionedProductOutputsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProvisionedProductOutputsRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The identifier of the provisioned product that you want the outputs from.
         * </p>
         * 
         * @param provisionedProductId
         *        The identifier of the provisioned product that you want the outputs from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * The name of the provisioned product that you want the outputs from.
         * </p>
         * 
         * @param provisionedProductName
         *        The name of the provisioned product that you want the outputs from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * The list of keys that the API should return with their values. If none are provided, the API will return all
         * outputs of the provisioned product.
         * </p>
         * 
         * @param outputKeys
         *        The list of keys that the API should return with their values. If none are provided, the API will
         *        return all outputs of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeys(Collection<String> outputKeys);

        /**
         * <p>
         * The list of keys that the API should return with their values. If none are provided, the API will return all
         * outputs of the provisioned product.
         * </p>
         * 
         * @param outputKeys
         *        The list of keys that the API should return with their values. If none are provided, the API will
         *        return all outputs of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKeys(String... outputKeys);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String provisionedProductId;

        private String provisionedProductName;

        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();

        private Integer pageSize;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProvisionedProductOutputsRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            provisionedProductId(model.provisionedProductId);
            provisionedProductName(model.provisionedProductName);
            outputKeys(model.outputKeys);
            pageSize(model.pageSize);
            pageToken(model.pageToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final Collection<String> getOutputKeys() {
            if (outputKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return outputKeys;
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String... outputKeys) {
            outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProvisionedProductOutputsRequest build() {
            return new GetProvisionedProductOutputsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
