/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteProvisionedProductServiceActionRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ExecuteProvisionedProductServiceActionRequest.Builder, ExecuteProvisionedProductServiceActionRequest> {
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisionedProductId")
            .getter(getter(ExecuteProvisionedProductServiceActionRequest::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceActionId").getter(getter(ExecuteProvisionedProductServiceActionRequest::serviceActionId))
            .setter(setter(Builder::serviceActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()).build();

    private static final SdkField<String> EXECUTE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExecuteToken")
            .getter(getter(ExecuteProvisionedProductServiceActionRequest::executeToken))
            .setter(setter(Builder::executeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(ExecuteProvisionedProductServiceActionRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(ExecuteProvisionedProductServiceActionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_PRODUCT_ID_FIELD,
            SERVICE_ACTION_ID_FIELD, EXECUTE_TOKEN_FIELD, ACCEPT_LANGUAGE_FIELD, PARAMETERS_FIELD));

    private final String provisionedProductId;

    private final String serviceActionId;

    private final String executeToken;

    private final String acceptLanguage;

    private final Map<String, List<String>> parameters;

    private ExecuteProvisionedProductServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.provisionedProductId = builder.provisionedProductId;
        this.serviceActionId = builder.serviceActionId;
        this.executeToken = builder.executeToken;
        this.acceptLanguage = builder.acceptLanguage;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The identifier of the provisioned product.
     * </p>
     * 
     * @return The identifier of the provisioned product.
     */
    public final String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     * </p>
     * 
     * @return The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     */
    public final String serviceActionId() {
        return serviceActionId;
    }

    /**
     * <p>
     * An idempotency token that uniquely identifies the execute request.
     * </p>
     * 
     * @return An idempotency token that uniquely identifies the execute request.
     */
    public final String executeToken() {
        return executeToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of all self-service action parameters and their values. If a provided parameter is of a special type, such
     * as <code>TARGET</code>, the provided value will override the default value generated by AWS Service Catalog. If
     * the parameters field is not provided, no additional parameters are passed and default values will be used for any
     * special parameters such as <code>TARGET</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of all self-service action parameters and their values. If a provided parameter is of a special
     *         type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS
     *         Service Catalog. If the parameters field is not provided, no additional parameters are passed and default
     *         values will be used for any special parameters such as <code>TARGET</code>.
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(executeToken());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteProvisionedProductServiceActionRequest)) {
            return false;
        }
        ExecuteProvisionedProductServiceActionRequest other = (ExecuteProvisionedProductServiceActionRequest) obj;
        return Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(serviceActionId(), other.serviceActionId())
                && Objects.equals(executeToken(), other.executeToken())
                && Objects.equals(acceptLanguage(), other.acceptLanguage()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteProvisionedProductServiceActionRequest")
                .add("ProvisionedProductId", provisionedProductId()).add("ServiceActionId", serviceActionId())
                .add("ExecuteToken", executeToken()).add("AcceptLanguage", acceptLanguage())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ServiceActionId":
            return Optional.ofNullable(clazz.cast(serviceActionId()));
        case "ExecuteToken":
            return Optional.ofNullable(clazz.cast(executeToken()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteProvisionedProductServiceActionRequest, T> g) {
        return obj -> g.apply((ExecuteProvisionedProductServiceActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteProvisionedProductServiceActionRequest> {
        /**
         * <p>
         * The identifier of the provisioned product.
         * </p>
         * 
         * @param provisionedProductId
         *        The identifier of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * </p>
         * 
         * @param serviceActionId
         *        The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionId(String serviceActionId);

        /**
         * <p>
         * An idempotency token that uniquely identifies the execute request.
         * </p>
         * 
         * @param executeToken
         *        An idempotency token that uniquely identifies the execute request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executeToken(String executeToken);

        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * A map of all self-service action parameters and their values. If a provided parameter is of a special type,
         * such as <code>TARGET</code>, the provided value will override the default value generated by AWS Service
         * Catalog. If the parameters field is not provided, no additional parameters are passed and default values will
         * be used for any special parameters such as <code>TARGET</code>.
         * </p>
         * 
         * @param parameters
         *        A map of all self-service action parameters and their values. If a provided parameter is of a special
         *        type, such as <code>TARGET</code>, the provided value will override the default value generated by AWS
         *        Service Catalog. If the parameters field is not provided, no additional parameters are passed and
         *        default values will be used for any special parameters such as <code>TARGET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String provisionedProductId;

        private String serviceActionId;

        private String executeToken;

        private String acceptLanguage;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteProvisionedProductServiceActionRequest model) {
            super(model);
            provisionedProductId(model.provisionedProductId);
            serviceActionId(model.serviceActionId);
            executeToken(model.executeToken);
            acceptLanguage(model.acceptLanguage);
            parameters(model.parameters);
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final String getServiceActionId() {
            return serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        public final String getExecuteToken() {
            return executeToken;
        }

        @Override
        public final Builder executeToken(String executeToken) {
            this.executeToken = executeToken;
            return this;
        }

        public final void setExecuteToken(String executeToken) {
            this.executeToken = executeToken;
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ExecutionParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ExecutionParameterMapCopier.copy(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteProvisionedProductServiceActionRequest build() {
            return new ExecuteProvisionedProductServiceActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
