/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.AcceptPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateBudgetWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateProductWithPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.CreateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeletePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DeleteTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribeTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateBudgetFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.DisassociateTagOptionFromResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.DuplicateResourceException;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.InvalidParametersException;
import software.amazon.awssdk.services.servicecatalog.model.InvalidStateException;
import software.amazon.awssdk.services.servicecatalog.model.LimitExceededException;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;
import software.amazon.awssdk.services.servicecatalog.model.OperationNotSupportedException;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.RejectPortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.ResourceInUseException;
import software.amazon.awssdk.services.servicecatalog.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ScanProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogException;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionNotMigratedException;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdatePortfolioShareResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningArtifactResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateServiceActionResponse;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionRequest;
import software.amazon.awssdk.services.servicecatalog.model.UpdateTagOptionResponse;
import software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher;
import software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher;
import software.amazon.awssdk.services.servicecatalog.transform.AcceptPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateBudgetWithResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociatePrincipalWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateProductWithPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateServiceActionWithProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.AssociateTagOptionWithResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.BatchAssociateServiceActionWithProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.BatchDisassociateServiceActionFromProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CopyProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreatePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.CreateTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeletePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DeleteTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeCopyProductStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioShareStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribePortfolioSharesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProductViewRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeProvisioningParametersRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeRecordRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeServiceActionExecutionParametersRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DescribeTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisableAwsOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateBudgetFromResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociatePrincipalFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateProductFromPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateServiceActionFromProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.DisassociateTagOptionFromResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.EnableAwsOrganizationsAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ExecuteProvisionedProductPlanRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ExecuteProvisionedProductServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.GetAwsOrganizationsAccessStatusRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.GetProvisionedProductOutputsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ImportAsProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListAcceptedPortfolioSharesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListBudgetsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListConstraintsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListLaunchPathsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListOrganizationPortfolioAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfolioAccessRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosForProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPortfoliosRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListPrincipalsForPortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisionedProductPlansRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsForServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListProvisioningArtifactsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListRecordHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListResourcesForTagOptionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListServiceActionsForProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListServiceActionsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListStackInstancesForProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ListTagOptionsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisionProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.RejectPortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.ScanProvisionedProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsAsAdminRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.SearchProvisionedProductsRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.TerminateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateConstraintRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdatePortfolioShareRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductPropertiesRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisionedProductRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisioningArtifactRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateServiceActionRequestMarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateTagOptionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ServiceCatalogAsyncClient}.
 *
 * @see ServiceCatalogAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultServiceCatalogAsyncClient implements ServiceCatalogAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceCatalogAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceCatalogAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts an offer to share the specified portfolio.
     * </p>
     *
     * @param acceptPortfolioShareRequest
     * @return A Java Future containing the result of the AcceptPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AcceptPortfolioShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AcceptPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptPortfolioShareResponse> acceptPortfolioShare(
            AcceptPortfolioShareRequest acceptPortfolioShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptPortfolioShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptPortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptPortfolioShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptPortfolioShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptPortfolioShareRequest, AcceptPortfolioShareResponse>()
                            .withOperationName("AcceptPortfolioShare")
                            .withMarshaller(new AcceptPortfolioShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(acceptPortfolioShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = acceptPortfolioShareRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<AcceptPortfolioShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified budget with the specified resource.
     * </p>
     *
     * @param associateBudgetWithResourceRequest
     * @return A Java Future containing the result of the AssociateBudgetWithResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateBudgetWithResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateBudgetWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateBudgetWithResourceResponse> associateBudgetWithResource(
            AssociateBudgetWithResourceRequest associateBudgetWithResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBudgetWithResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBudgetWithResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateBudgetWithResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateBudgetWithResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateBudgetWithResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateBudgetWithResourceRequest, AssociateBudgetWithResourceResponse>()
                            .withOperationName("AssociateBudgetWithResource")
                            .withMarshaller(new AssociateBudgetWithResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateBudgetWithResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateBudgetWithResourceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<AssociateBudgetWithResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified principal ARN with the specified portfolio.
     * </p>
     *
     * @param associatePrincipalWithPortfolioRequest
     * @return A Java Future containing the result of the AssociatePrincipalWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociatePrincipalWithPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociatePrincipalWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociatePrincipalWithPortfolioResponse> associatePrincipalWithPortfolio(
            AssociatePrincipalWithPortfolioRequest associatePrincipalWithPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associatePrincipalWithPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePrincipalWithPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePrincipalWithPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociatePrincipalWithPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePrincipalWithPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePrincipalWithPortfolioRequest, AssociatePrincipalWithPortfolioResponse>()
                            .withOperationName("AssociatePrincipalWithPortfolio")
                            .withMarshaller(new AssociatePrincipalWithPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associatePrincipalWithPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associatePrincipalWithPortfolioRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociatePrincipalWithPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates the specified product with the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param associateProductWithPortfolioRequest
     * @return A Java Future containing the result of the AssociateProductWithPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateProductWithPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateProductWithPortfolioResponse> associateProductWithPortfolio(
            AssociateProductWithPortfolioRequest associateProductWithPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateProductWithPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateProductWithPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateProductWithPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateProductWithPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateProductWithPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateProductWithPortfolioRequest, AssociateProductWithPortfolioResponse>()
                            .withOperationName("AssociateProductWithPortfolio")
                            .withMarshaller(new AssociateProductWithPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateProductWithPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateProductWithPortfolioRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<AssociateProductWithPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a self-service action with a provisioning artifact.
     * </p>
     *
     * @param associateServiceActionWithProvisioningArtifactRequest
     * @return A Java Future containing the result of the AssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateServiceActionWithProvisioningArtifactResponse> associateServiceActionWithProvisioningArtifact(
            AssociateServiceActionWithProvisioningArtifactRequest associateServiceActionWithProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateServiceActionWithProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateServiceActionWithProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateServiceActionWithProvisioningArtifactResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateServiceActionWithProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateServiceActionWithProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateServiceActionWithProvisioningArtifactRequest, AssociateServiceActionWithProvisioningArtifactResponse>()
                            .withOperationName("AssociateServiceActionWithProvisioningArtifact")
                            .withMarshaller(new AssociateServiceActionWithProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(associateServiceActionWithProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateServiceActionWithProvisioningArtifactRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AssociateServiceActionWithProvisioningArtifactResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associate the specified TagOption with the specified portfolio or product.
     * </p>
     *
     * @param associateTagOptionWithResourceRequest
     * @return A Java Future containing the result of the AssociateTagOptionWithResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.AssociateTagOptionWithResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTagOptionWithResourceResponse> associateTagOptionWithResource(
            AssociateTagOptionWithResourceRequest associateTagOptionWithResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTagOptionWithResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTagOptionWithResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTagOptionWithResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateTagOptionWithResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateTagOptionWithResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTagOptionWithResourceRequest, AssociateTagOptionWithResourceResponse>()
                            .withOperationName("AssociateTagOptionWithResource")
                            .withMarshaller(new AssociateTagOptionWithResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateTagOptionWithResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateTagOptionWithResourceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<AssociateTagOptionWithResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates multiple self-service actions with provisioning artifacts.
     * </p>
     *
     * @param batchAssociateServiceActionWithProvisioningArtifactRequest
     * @return A Java Future containing the result of the BatchAssociateServiceActionWithProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchAssociateServiceActionWithProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchAssociateServiceActionWithProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchAssociateServiceActionWithProvisioningArtifactResponse> batchAssociateServiceActionWithProvisioningArtifact(
            BatchAssociateServiceActionWithProvisioningArtifactRequest batchAssociateServiceActionWithProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateServiceActionWithProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateServiceActionWithProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchAssociateServiceActionWithProvisioningArtifactResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            BatchAssociateServiceActionWithProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchAssociateServiceActionWithProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateServiceActionWithProvisioningArtifactRequest, BatchAssociateServiceActionWithProvisioningArtifactResponse>()
                            .withOperationName("BatchAssociateServiceActionWithProvisioningArtifact")
                            .withMarshaller(
                                    new BatchAssociateServiceActionWithProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(batchAssociateServiceActionWithProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchAssociateServiceActionWithProvisioningArtifactRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<BatchAssociateServiceActionWithProvisioningArtifactResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     * </p>
     *
     * @param batchDisassociateServiceActionFromProvisioningArtifactRequest
     * @return A Java Future containing the result of the BatchDisassociateServiceActionFromProvisioningArtifact
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.BatchDisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/BatchDisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDisassociateServiceActionFromProvisioningArtifactResponse> batchDisassociateServiceActionFromProvisioningArtifact(
            BatchDisassociateServiceActionFromProvisioningArtifactRequest batchDisassociateServiceActionFromProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateServiceActionFromProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "BatchDisassociateServiceActionFromProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDisassociateServiceActionFromProvisioningArtifactResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata,
                            BatchDisassociateServiceActionFromProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDisassociateServiceActionFromProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateServiceActionFromProvisioningArtifactRequest, BatchDisassociateServiceActionFromProvisioningArtifactResponse>()
                            .withOperationName("BatchDisassociateServiceActionFromProvisioningArtifact")
                            .withMarshaller(
                                    new BatchDisassociateServiceActionFromProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDisassociateServiceActionFromProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDisassociateServiceActionFromProvisioningArtifactRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<BatchDisassociateServiceActionFromProvisioningArtifactResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified source product to the specified target product or a new product.
     * </p>
     * <p>
     * You can copy a product to the same account or another account. You can copy a product to the same region or
     * another region.
     * </p>
     * <p>
     * This operation is performed asynchronously. To track the progress of the operation, use
     * <a>DescribeCopyProductStatus</a>.
     * </p>
     *
     * @param copyProductRequest
     * @return A Java Future containing the result of the CopyProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CopyProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CopyProduct" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopyProductResponse> copyProduct(CopyProductRequest copyProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CopyProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CopyProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CopyProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyProductRequest, CopyProductResponse>()
                            .withOperationName("CopyProduct").withMarshaller(new CopyProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copyProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copyProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CopyProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createConstraintRequest
     * @return A Java Future containing the result of the CreateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateConstraint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConstraintResponse> createConstraint(CreateConstraintRequest createConstraintRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConstraint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConstraintResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConstraintResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConstraintResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConstraintRequest, CreateConstraintResponse>()
                            .withOperationName("CreateConstraint")
                            .withMarshaller(new CreateConstraintRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createConstraintRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createConstraintRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateConstraintResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param createPortfolioRequest
     * @return A Java Future containing the result of the CreatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolio" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePortfolioResponse> createPortfolio(CreatePortfolioRequest createPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePortfolioRequest, CreatePortfolioResponse>()
                            .withOperationName("CreatePortfolio")
                            .withMarshaller(new CreatePortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPortfolioRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreatePortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node
     * can only be created by the management account of an organization or by a delegated administrator. You can share
     * portfolios to an organization, an organizational unit, or a specific account.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     * </p>
     * <p>
     * <code>AWSOrganizationsAccess</code> must be enabled in order to create a portfolio share to an organization node.
     * </p>
     * <p>
     * You can't share a shared resource, including portfolios that contain a shared product.
     * </p>
     * <p>
     * If the portfolio share with the specified account or organization node already exists, this action will have no
     * effect and will not return an error. To update an existing share, you must use the
     * <code> UpdatePortfolioShare</code> API instead.
     * </p>
     *
     * @param createPortfolioShareRequest
     * @return A Java Future containing the result of the CreatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreatePortfolioShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePortfolioShareResponse> createPortfolioShare(
            CreatePortfolioShareRequest createPortfolioShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortfolioShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePortfolioShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePortfolioShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePortfolioShareRequest, CreatePortfolioShareResponse>()
                            .withOperationName("CreatePortfolioShare")
                            .withMarshaller(new CreatePortfolioShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPortfolioShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPortfolioShareRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreatePortfolioShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a product.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProductRequest
     * @return A Java Future containing the result of the CreateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProductResponse> createProduct(CreateProductRequest createProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProductRequest, CreateProductResponse>()
                            .withOperationName("CreateProduct")
                            .withMarshaller(new CreateProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified
     * (when updating a provisioned product) when the plan is executed.
     * </p>
     * <p>
     * You can create one plan per provisioned product. To create a plan for an existing provisioned product, the
     * product status must be AVAILBLE or TAINTED.
     * </p>
     * <p>
     * To view the resource changes in the change set, use <a>DescribeProvisionedProductPlan</a>. To create or modify
     * the provisioned product, use <a>ExecuteProvisionedProductPlan</a>.
     * </p>
     *
     * @param createProvisionedProductPlanRequest
     * @return A Java Future containing the result of the CreateProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisionedProductPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProvisionedProductPlanResponse> createProvisionedProductPlan(
            CreateProvisionedProductPlanRequest createProvisionedProductPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisionedProductPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisionedProductPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProvisionedProductPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProvisionedProductPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProvisionedProductPlanRequest, CreateProvisionedProductPlanResponse>()
                            .withOperationName("CreateProvisionedProductPlan")
                            .withMarshaller(new CreateProvisionedProductPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProvisionedProductPlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createProvisionedProductPlanRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateProvisionedProductPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot create a provisioning artifact for a product that was shared with you.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> IAM policy
     * permission. This policy permission is required when using the <code>ImportFromPhysicalId</code> template source
     * in the information data section.
     * </p>
     *
     * @param createProvisioningArtifactRequest
     * @return A Java Future containing the result of the CreateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateProvisioningArtifact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProvisioningArtifactResponse> createProvisioningArtifact(
            CreateProvisioningArtifactRequest createProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningArtifactRequest, CreateProvisioningArtifactResponse>()
                            .withOperationName("CreateProvisioningArtifact")
                            .withMarshaller(new CreateProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createProvisioningArtifactRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateProvisioningArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a self-service action.
     * </p>
     *
     * @param createServiceActionRequest
     * @return A Java Future containing the result of the CreateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateServiceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateServiceActionResponse> createServiceAction(
            CreateServiceActionRequest createServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateServiceActionRequest, CreateServiceActionResponse>()
                            .withOperationName("CreateServiceAction")
                            .withMarshaller(new CreateServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createServiceActionRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateServiceActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a TagOption.
     * </p>
     *
     * @param createTagOptionRequest
     * @return A Java Future containing the result of the CreateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.CreateTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/CreateTagOption" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagOptionResponse> createTagOption(CreateTagOptionRequest createTagOptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTagOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTagOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTagOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTagOptionRequest, CreateTagOptionResponse>()
                            .withOperationName("CreateTagOption")
                            .withMarshaller(new CreateTagOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTagOptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTagOptionRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateTagOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified constraint.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteConstraintRequest
     * @return A Java Future containing the result of the DeleteConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteConstraint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConstraintResponse> deleteConstraint(DeleteConstraintRequest deleteConstraintRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConstraint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConstraintResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConstraintResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConstraintResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConstraintRequest, DeleteConstraintResponse>()
                            .withOperationName("DeleteConstraint")
                            .withMarshaller(new DeleteConstraintRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConstraintRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteConstraintRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteConstraintResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified portfolio.
     * </p>
     * <p>
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or
     * shared accounts.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deletePortfolioRequest
     * @return A Java Future containing the result of the DeletePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePortfolioResponse> deletePortfolio(DeletePortfolioRequest deletePortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePortfolioRequest, DeletePortfolioResponse>()
                            .withOperationName("DeletePortfolio")
                            .withMarshaller(new DeletePortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePortfolioRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeletePortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization
     * node can only be deleted by the management account of an organization or by a delegated administrator.
     * </p>
     * <p>
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     * </p>
     *
     * @param deletePortfolioShareRequest
     * @return A Java Future containing the result of the DeletePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeletePortfolioShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePortfolioShareResponse> deletePortfolioShare(
            DeletePortfolioShareRequest deletePortfolioShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortfolioShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePortfolioShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePortfolioShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePortfolioShareRequest, DeletePortfolioShareResponse>()
                            .withOperationName("DeletePortfolioShare")
                            .withMarshaller(new DeletePortfolioShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePortfolioShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePortfolioShareRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeletePortfolioShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified product.
     * </p>
     * <p>
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param deleteProductRequest
     * @return A Java Future containing the result of the DeleteProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProductResponse> deleteProduct(DeleteProductRequest deleteProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProductRequest, DeleteProductResponse>()
                            .withOperationName("DeleteProduct")
                            .withMarshaller(new DeleteProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified plan.
     * </p>
     *
     * @param deleteProvisionedProductPlanRequest
     * @return A Java Future containing the result of the DeleteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisionedProductPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProvisionedProductPlanResponse> deleteProvisionedProductPlan(
            DeleteProvisionedProductPlanRequest deleteProvisionedProductPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisionedProductPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisionedProductPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProvisionedProductPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProvisionedProductPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisionedProductPlanRequest, DeleteProvisionedProductPlanResponse>()
                            .withOperationName("DeleteProvisionedProductPlan")
                            .withMarshaller(new DeleteProvisionedProductPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteProvisionedProductPlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteProvisionedProductPlanRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteProvisionedProductPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete
     * the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     * </p>
     *
     * @param deleteProvisioningArtifactRequest
     * @return A Java Future containing the result of the DeleteProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteProvisioningArtifact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProvisioningArtifactResponse> deleteProvisioningArtifact(
            DeleteProvisioningArtifactRequest deleteProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningArtifactRequest, DeleteProvisioningArtifactResponse>()
                            .withOperationName("DeleteProvisioningArtifact")
                            .withMarshaller(new DeleteProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteProvisioningArtifactRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteProvisioningArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a self-service action.
     * </p>
     *
     * @param deleteServiceActionRequest
     * @return A Java Future containing the result of the DeleteServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteServiceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceActionResponse> deleteServiceAction(
            DeleteServiceActionRequest deleteServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceActionRequest, DeleteServiceActionResponse>()
                            .withOperationName("DeleteServiceAction")
                            .withMarshaller(new DeleteServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteServiceActionRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteServiceActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified TagOption.
     * </p>
     * <p>
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     * </p>
     *
     * @param deleteTagOptionRequest
     * @return A Java Future containing the result of the DeleteTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DeleteTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteTagOption" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagOptionResponse> deleteTagOption(DeleteTagOptionRequest deleteTagOptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTagOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTagOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTagOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagOptionRequest, DeleteTagOptionResponse>()
                            .withOperationName("DeleteTagOption")
                            .withMarshaller(new DeleteTagOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTagOptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTagOptionRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteTagOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified constraint.
     * </p>
     *
     * @param describeConstraintRequest
     * @return A Java Future containing the result of the DescribeConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeConstraint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConstraintResponse> describeConstraint(DescribeConstraintRequest describeConstraintRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConstraint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConstraintResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConstraintResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeConstraintResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConstraintRequest, DescribeConstraintResponse>()
                            .withOperationName("DescribeConstraint")
                            .withMarshaller(new DescribeConstraintRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeConstraintRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeConstraintRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeConstraintResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of the specified copy product operation.
     * </p>
     *
     * @param describeCopyProductStatusRequest
     * @return A Java Future containing the result of the DescribeCopyProductStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeCopyProductStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeCopyProductStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCopyProductStatusResponse> describeCopyProductStatus(
            DescribeCopyProductStatusRequest describeCopyProductStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCopyProductStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCopyProductStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCopyProductStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCopyProductStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCopyProductStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCopyProductStatusRequest, DescribeCopyProductStatusResponse>()
                            .withOperationName("DescribeCopyProductStatus")
                            .withMarshaller(new DescribeCopyProductStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeCopyProductStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeCopyProductStatusRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeCopyProductStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param describePortfolioRequest
     * @return A Java Future containing the result of the DescribePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePortfolioResponse> describePortfolio(DescribePortfolioRequest describePortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePortfolioRequest, DescribePortfolioResponse>()
                            .withOperationName("DescribePortfolio")
                            .withMarshaller(new DescribePortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePortfolioRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribePortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account
     * in the organization or by a delegated admin.
     * </p>
     *
     * @param describePortfolioShareStatusRequest
     * @return A Java Future containing the result of the DescribePortfolioShareStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShareStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShareStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePortfolioShareStatusResponse> describePortfolioShareStatus(
            DescribePortfolioShareStatusRequest describePortfolioShareStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioShareStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolioShareStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePortfolioShareStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePortfolioShareStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePortfolioShareStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePortfolioShareStatusRequest, DescribePortfolioShareStatusResponse>()
                            .withOperationName("DescribePortfolioShareStatus")
                            .withMarshaller(new DescribePortfolioShareStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePortfolioShareStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePortfolioShareStatusRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribePortfolioShareStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A Java Future containing the result of the DescribePortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePortfolioSharesResponse> describePortfolioShares(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePortfolioSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePortfolioShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePortfolioSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePortfolioSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePortfolioSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePortfolioSharesRequest, DescribePortfolioSharesResponse>()
                            .withOperationName("DescribePortfolioShares")
                            .withMarshaller(new DescribePortfolioSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePortfolioSharesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePortfolioSharesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribePortfolioSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     * </p>
     * <p>
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether
     * the recipient entity has imported the share, and whether TagOptions are included with the share.
     * </p>
     * <p>
     * The <code>PortfolioId</code> and <code>Type</code> parameters are both required.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.DescribePortfolioSharesPublisher publisher = client.describePortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePortfolioShares(software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePortfolioSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribePortfolioShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribePortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    public DescribePortfolioSharesPublisher describePortfolioSharesPaginator(
            DescribePortfolioSharesRequest describePortfolioSharesRequest) {
        return new DescribePortfolioSharesPublisher(this, applyPaginatorUserAgent(describePortfolioSharesRequest));
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     *
     * @param describeProductRequest
     * @return A Java Future containing the result of the DescribeProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProductResponse> describeProduct(DescribeProductRequest describeProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProductRequest, DescribeProductResponse>()
                            .withOperationName("DescribeProduct")
                            .withMarshaller(new DescribeProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified product. This operation is run with administrator access.
     * </p>
     *
     * @param describeProductAsAdminRequest
     * @return A Java Future containing the result of the DescribeProductAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductAsAdmin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProductAsAdminResponse> describeProductAsAdmin(
            DescribeProductAsAdminRequest describeProductAsAdminRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductAsAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProductAsAdmin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProductAsAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProductAsAdminResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProductAsAdminResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProductAsAdminRequest, DescribeProductAsAdminResponse>()
                            .withOperationName("DescribeProductAsAdmin")
                            .withMarshaller(new DescribeProductAsAdminRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProductAsAdminRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProductAsAdminRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeProductAsAdminResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified product.
     * </p>
     *
     * @param describeProductViewRequest
     * @return A Java Future containing the result of the DescribeProductView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProductView
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProductView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProductViewResponse> describeProductView(
            DescribeProductViewRequest describeProductViewRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProductViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProductView");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProductViewResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProductViewResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProductViewResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProductViewRequest, DescribeProductViewResponse>()
                            .withOperationName("DescribeProductView")
                            .withMarshaller(new DescribeProductViewRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProductViewRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProductViewRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeProductViewResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified provisioned product.
     * </p>
     *
     * @param describeProvisionedProductRequest
     *        DescribeProvisionedProductAPI input structure. AcceptLanguage - [Optional] The language code for
     *        localization. Id - [Optional] The provisioned product identifier. Name - [Optional] Another provisioned
     *        product identifier. Customers must provide either Id or Name.
     * @return A Java Future containing the result of the DescribeProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProvisionedProductResponse> describeProvisionedProduct(
            DescribeProvisionedProductRequest describeProvisionedProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisionedProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProvisionedProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisionedProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisionedProductRequest, DescribeProvisionedProductResponse>()
                            .withOperationName("DescribeProvisionedProduct")
                            .withMarshaller(new DescribeProvisionedProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProvisionedProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProvisionedProductRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeProvisionedProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the resource changes for the specified plan.
     * </p>
     *
     * @param describeProvisionedProductPlanRequest
     * @return A Java Future containing the result of the DescribeProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisionedProductPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProvisionedProductPlanResponse> describeProvisionedProductPlan(
            DescribeProvisionedProductPlanRequest describeProvisionedProductPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProvisionedProductPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisionedProductPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProvisionedProductPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisionedProductPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisionedProductPlanRequest, DescribeProvisionedProductPlanResponse>()
                            .withOperationName("DescribeProvisionedProductPlan")
                            .withMarshaller(new DescribeProvisionedProductPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProvisionedProductPlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProvisionedProductPlanRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeProvisionedProductPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     *
     * @param describeProvisioningArtifactRequest
     * @return A Java Future containing the result of the DescribeProvisioningArtifact operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningArtifact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProvisioningArtifactResponse> describeProvisioningArtifact(
            DescribeProvisioningArtifactRequest describeProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningArtifactRequest, DescribeProvisioningArtifactResponse>()
                            .withOperationName("DescribeProvisioningArtifact")
                            .withMarshaller(new DescribeProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProvisioningArtifactRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeProvisioningArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the configuration required to provision the specified product using the specified
     * provisioning artifact.
     * </p>
     * <p>
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key.
     * The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to
     * <a>ProvisionProduct</a>, do not include conflicted TagOption keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>". Tag the provisioned
     * product with the value <code>sc-tagoption-conflict-portfolioId-productId</code>.
     * </p>
     *
     * @param describeProvisioningParametersRequest
     * @return A Java Future containing the result of the DescribeProvisioningParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeProvisioningParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeProvisioningParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProvisioningParametersResponse> describeProvisioningParameters(
            DescribeProvisioningParametersRequest describeProvisioningParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProvisioningParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisioningParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProvisioningParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisioningParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResponse>()
                            .withOperationName("DescribeProvisioningParameters")
                            .withMarshaller(new DescribeProvisioningParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeProvisioningParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeProvisioningParametersRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeProvisioningParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified request operation.
     * </p>
     * <p>
     * Use this operation after calling a request operation (for example, <a>ProvisionProduct</a>,
     * <a>TerminateProvisionedProduct</a>, or <a>UpdateProvisionedProduct</a>).
     * </p>
     * <note>
     * <p>
     * If a provisioned product was transferred to a new owner using <a>UpdateProvisionedProductProperties</a>, the new
     * owner will be able to describe all past records for that product. The previous owner will no longer be able to
     * describe the records, but will be able to use <a>ListRecordHistory</a> to see the product's history from when he
     * was the owner.
     * </p>
     * </note>
     *
     * @param describeRecordRequest
     * @return A Java Future containing the result of the DescribeRecord operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeRecord
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeRecord" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecordResponse> describeRecord(DescribeRecordRequest describeRecordRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecord");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecordResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRecordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRecordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecordRequest, DescribeRecordResponse>()
                            .withOperationName("DescribeRecord")
                            .withMarshaller(new DescribeRecordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeRecordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeRecordRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeRecordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a self-service action.
     * </p>
     *
     * @param describeServiceActionRequest
     * @return A Java Future containing the result of the DescribeServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeServiceActionResponse> describeServiceAction(
            DescribeServiceActionRequest describeServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceActionRequest, DescribeServiceActionResponse>()
                            .withOperationName("DescribeServiceAction")
                            .withMarshaller(new DescribeServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeServiceActionRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeServiceActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a
     * map of the results to the user.
     * </p>
     *
     * @param describeServiceActionExecutionParametersRequest
     * @return A Java Future containing the result of the DescribeServiceActionExecutionParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeServiceActionExecutionParameters
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeServiceActionExecutionParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeServiceActionExecutionParametersResponse> describeServiceActionExecutionParameters(
            DescribeServiceActionExecutionParametersRequest describeServiceActionExecutionParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeServiceActionExecutionParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeServiceActionExecutionParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeServiceActionExecutionParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeServiceActionExecutionParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeServiceActionExecutionParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeServiceActionExecutionParametersRequest, DescribeServiceActionExecutionParametersResponse>()
                            .withOperationName("DescribeServiceActionExecutionParameters")
                            .withMarshaller(new DescribeServiceActionExecutionParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(describeServiceActionExecutionParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeServiceActionExecutionParametersRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeServiceActionExecutionParametersResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified TagOption.
     * </p>
     *
     * @param describeTagOptionRequest
     * @return A Java Future containing the result of the DescribeTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DescribeTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagOptionResponse> describeTagOption(DescribeTagOptionRequest describeTagOptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTagOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTagOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTagOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTagOptionRequest, DescribeTagOptionResponse>()
                            .withOperationName("DescribeTagOption")
                            .withMarshaller(new DescribeTagOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTagOptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTagOptionRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeTagOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but
     * it will prevent you from creating new shares throughout your organization. Current shares will not be in sync
     * with your organization structure if it changes after calling this API. This API can only be called by the
     * management account in the organization.
     * </p>
     * <p>
     * This API can't be invoked if there are active delegated administrators in the organization.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>DisableAWSOrganizationsAccess</code>.
     * </p>
     *
     * @param disableAwsOrganizationsAccessRequest
     * @return A Java Future containing the result of the DisableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisableAWSOrganizationsAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableAwsOrganizationsAccessResponse> disableAWSOrganizationsAccess(
            DisableAwsOrganizationsAccessRequest disableAwsOrganizationsAccessRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableAwsOrganizationsAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableAWSOrganizationsAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableAwsOrganizationsAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableAwsOrganizationsAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableAwsOrganizationsAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableAwsOrganizationsAccessRequest, DisableAwsOrganizationsAccessResponse>()
                            .withOperationName("DisableAWSOrganizationsAccess")
                            .withMarshaller(new DisableAwsOrganizationsAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableAwsOrganizationsAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableAwsOrganizationsAccessRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DisableAwsOrganizationsAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the specified budget from the specified resource.
     * </p>
     *
     * @param disassociateBudgetFromResourceRequest
     * @return A Java Future containing the result of the DisassociateBudgetFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateBudgetFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateBudgetFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateBudgetFromResourceResponse> disassociateBudgetFromResource(
            DisassociateBudgetFromResourceRequest disassociateBudgetFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateBudgetFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBudgetFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateBudgetFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateBudgetFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateBudgetFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateBudgetFromResourceRequest, DisassociateBudgetFromResourceResponse>()
                            .withOperationName("DisassociateBudgetFromResource")
                            .withMarshaller(new DisassociateBudgetFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateBudgetFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateBudgetFromResourceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DisassociateBudgetFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a previously associated principal ARN from a specified portfolio.
     * </p>
     *
     * @param disassociatePrincipalFromPortfolioRequest
     * @return A Java Future containing the result of the DisassociatePrincipalFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociatePrincipalFromPortfolio
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociatePrincipalFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociatePrincipalFromPortfolioResponse> disassociatePrincipalFromPortfolio(
            DisassociatePrincipalFromPortfolioRequest disassociatePrincipalFromPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociatePrincipalFromPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePrincipalFromPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociatePrincipalFromPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociatePrincipalFromPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociatePrincipalFromPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociatePrincipalFromPortfolioRequest, DisassociatePrincipalFromPortfolioResponse>()
                            .withOperationName("DisassociatePrincipalFromPortfolio")
                            .withMarshaller(new DisassociatePrincipalFromPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociatePrincipalFromPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociatePrincipalFromPortfolioRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociatePrincipalFromPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the specified product from the specified portfolio.
     * </p>
     * <p>
     * A delegated admin is authorized to invoke this command.
     * </p>
     *
     * @param disassociateProductFromPortfolioRequest
     * @return A Java Future containing the result of the DisassociateProductFromPortfolio operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ResourceInUseException A resource that is currently in use. Ensure that the resource is not in use
     *         and retry the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateProductFromPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateProductFromPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateProductFromPortfolioResponse> disassociateProductFromPortfolio(
            DisassociateProductFromPortfolioRequest disassociateProductFromPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateProductFromPortfolioRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateProductFromPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateProductFromPortfolioResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateProductFromPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateProductFromPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateProductFromPortfolioRequest, DisassociateProductFromPortfolioResponse>()
                            .withOperationName("DisassociateProductFromPortfolio")
                            .withMarshaller(new DisassociateProductFromPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateProductFromPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateProductFromPortfolioRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateProductFromPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     * </p>
     *
     * @param disassociateServiceActionFromProvisioningArtifactRequest
     * @return A Java Future containing the result of the DisassociateServiceActionFromProvisioningArtifact operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateServiceActionFromProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateServiceActionFromProvisioningArtifactResponse> disassociateServiceActionFromProvisioningArtifact(
            DisassociateServiceActionFromProvisioningArtifactRequest disassociateServiceActionFromProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateServiceActionFromProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateServiceActionFromProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateServiceActionFromProvisioningArtifactResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateServiceActionFromProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateServiceActionFromProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateServiceActionFromProvisioningArtifactRequest, DisassociateServiceActionFromProvisioningArtifactResponse>()
                            .withOperationName("DisassociateServiceActionFromProvisioningArtifact")
                            .withMarshaller(
                                    new DisassociateServiceActionFromProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateServiceActionFromProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateServiceActionFromProvisioningArtifactRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateServiceActionFromProvisioningArtifactResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates the specified TagOption from the specified resource.
     * </p>
     *
     * @param disassociateTagOptionFromResourceRequest
     * @return A Java Future containing the result of the DisassociateTagOptionFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.DisassociateTagOptionFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateTagOptionFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateTagOptionFromResourceResponse> disassociateTagOptionFromResource(
            DisassociateTagOptionFromResourceRequest disassociateTagOptionFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateTagOptionFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTagOptionFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateTagOptionFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateTagOptionFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateTagOptionFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateTagOptionFromResourceRequest, DisassociateTagOptionFromResourceResponse>()
                            .withOperationName("DisassociateTagOptionFromResource")
                            .withMarshaller(new DisassociateTagOptionFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateTagOptionFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateTagOptionFromResourceRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateTagOptionFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive
     * updates on your organization in order to sync your shares with the current structure. This API can only be called
     * by the management account in the organization.
     * </p>
     * <p>
     * By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so
     * that your shares can be in sync with any changes in your AWS Organizations structure.
     * </p>
     * <p>
     * Note that a delegated administrator is not authorized to invoke <code>EnableAWSOrganizationsAccess</code>.
     * </p>
     *
     * @param enableAwsOrganizationsAccessRequest
     * @return A Java Future containing the result of the EnableAWSOrganizationsAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.EnableAWSOrganizationsAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/EnableAWSOrganizationsAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableAwsOrganizationsAccessResponse> enableAWSOrganizationsAccess(
            EnableAwsOrganizationsAccessRequest enableAwsOrganizationsAccessRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableAwsOrganizationsAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableAWSOrganizationsAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableAwsOrganizationsAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableAwsOrganizationsAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableAwsOrganizationsAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableAwsOrganizationsAccessRequest, EnableAwsOrganizationsAccessResponse>()
                            .withOperationName("EnableAWSOrganizationsAccess")
                            .withMarshaller(new EnableAwsOrganizationsAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableAwsOrganizationsAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableAwsOrganizationsAccessRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<EnableAwsOrganizationsAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions or modifies a product based on the resource changes for the specified plan.
     * </p>
     *
     * @param executeProvisionedProductPlanRequest
     * @return A Java Future containing the result of the ExecuteProvisionedProductPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteProvisionedProductPlanResponse> executeProvisionedProductPlan(
            ExecuteProvisionedProductPlanRequest executeProvisionedProductPlanRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeProvisionedProductPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteProvisionedProductPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteProvisionedProductPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExecuteProvisionedProductPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteProvisionedProductPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteProvisionedProductPlanRequest, ExecuteProvisionedProductPlanResponse>()
                            .withOperationName("ExecuteProvisionedProductPlan")
                            .withMarshaller(new ExecuteProvisionedProductPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(executeProvisionedProductPlanRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = executeProvisionedProductPlanRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ExecuteProvisionedProductPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Executes a self-service action against a provisioned product.
     * </p>
     *
     * @param executeProvisionedProductServiceActionRequest
     * @return A Java Future containing the result of the ExecuteProvisionedProductServiceAction operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ExecuteProvisionedProductServiceAction
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ExecuteProvisionedProductServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExecuteProvisionedProductServiceActionResponse> executeProvisionedProductServiceAction(
            ExecuteProvisionedProductServiceActionRequest executeProvisionedProductServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                executeProvisionedProductServiceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteProvisionedProductServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExecuteProvisionedProductServiceActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ExecuteProvisionedProductServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExecuteProvisionedProductServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExecuteProvisionedProductServiceActionRequest, ExecuteProvisionedProductServiceActionResponse>()
                            .withOperationName("ExecuteProvisionedProductServiceAction")
                            .withMarshaller(new ExecuteProvisionedProductServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(executeProvisionedProductServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = executeProvisionedProductServiceActionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ExecuteProvisionedProductServiceActionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the Access Status for AWS Organization portfolio share feature. This API can only be called by the management
     * account in the organization or by a delegated admin.
     * </p>
     *
     * @param getAwsOrganizationsAccessStatusRequest
     * @return A Java Future containing the result of the GetAWSOrganizationsAccessStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetAWSOrganizationsAccessStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetAWSOrganizationsAccessStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAwsOrganizationsAccessStatusResponse> getAWSOrganizationsAccessStatus(
            GetAwsOrganizationsAccessStatusRequest getAwsOrganizationsAccessStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAwsOrganizationsAccessStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAWSOrganizationsAccessStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAwsOrganizationsAccessStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAwsOrganizationsAccessStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAwsOrganizationsAccessStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAwsOrganizationsAccessStatusRequest, GetAwsOrganizationsAccessStatusResponse>()
                            .withOperationName("GetAWSOrganizationsAccessStatus")
                            .withMarshaller(new GetAwsOrganizationsAccessStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAwsOrganizationsAccessStatusRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAwsOrganizationsAccessStatusRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetAwsOrganizationsAccessStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A Java Future containing the result of the GetProvisionedProductOutputs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProvisionedProductOutputsResponse> getProvisionedProductOutputs(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getProvisionedProductOutputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProvisionedProductOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProvisionedProductOutputsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetProvisionedProductOutputsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProvisionedProductOutputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProvisionedProductOutputsRequest, GetProvisionedProductOutputsResponse>()
                            .withOperationName("GetProvisionedProductOutputs")
                            .withMarshaller(new GetProvisionedProductOutputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getProvisionedProductOutputsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getProvisionedProductOutputsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetProvisionedProductOutputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API takes either a <code>ProvisonedProductId</code> or a <code>ProvisionedProductName</code>, along with a
     * list of one or more output keys, and responds with the key/value pairs of those outputs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.GetProvisionedProductOutputsPublisher publisher = client.getProvisionedProductOutputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getProvisionedProductOutputs(software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getProvisionedProductOutputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.GetProvisionedProductOutputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/GetProvisionedProductOutputs"
     *      target="_top">AWS API Documentation</a>
     */
    public GetProvisionedProductOutputsPublisher getProvisionedProductOutputsPaginator(
            GetProvisionedProductOutputsRequest getProvisionedProductOutputsRequest) {
        return new GetProvisionedProductOutputsPublisher(this, applyPaginatorUserAgent(getProvisionedProductOutputsRequest));
    }

    /**
     * <p>
     * Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service
     * Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are
     * supported on the provisioned product.
     * </p>
     * <p>
     * Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are
     * not supported.
     * </p>
     * <p>
     * The CloudFormation stack must have one of the following statuses to be imported: <code>CREATE_COMPLETE</code>,
     * <code>UPDATE_COMPLETE</code>, <code>UPDATE_ROLLBACK_COMPLETE</code>, <code>IMPORT_COMPLETE</code>,
     * <code>IMPORT_ROLLBACK_COMPLETE</code>.
     * </p>
     * <p>
     * Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog
     * product provisioning artifact.
     * </p>
     * <p>
     * The user or role that performs this operation must have the <code>cloudformation:GetTemplate</code> and
     * <code>cloudformation:DescribeStacks</code> IAM policy permissions.
     * </p>
     *
     * @param importAsProvisionedProductRequest
     * @return A Java Future containing the result of the ImportAsProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ImportAsProvisionedProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ImportAsProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ImportAsProvisionedProductResponse> importAsProvisionedProduct(
            ImportAsProvisionedProductRequest importAsProvisionedProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importAsProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportAsProvisionedProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportAsProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ImportAsProvisionedProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportAsProvisionedProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportAsProvisionedProductRequest, ImportAsProvisionedProductResponse>()
                            .withOperationName("ImportAsProvisionedProduct")
                            .withMarshaller(new ImportAsProvisionedProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importAsProvisionedProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importAsProvisionedProductRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ImportAsProvisionedProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all portfolios for which sharing was accepted by this account.
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A Java Future containing the result of the ListAcceptedPortfolioShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAcceptedPortfolioSharesResponse> listAcceptedPortfolioShares(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAcceptedPortfolioSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAcceptedPortfolioShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAcceptedPortfolioSharesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAcceptedPortfolioSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAcceptedPortfolioSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAcceptedPortfolioSharesRequest, ListAcceptedPortfolioSharesResponse>()
                            .withOperationName("ListAcceptedPortfolioShares")
                            .withMarshaller(new ListAcceptedPortfolioSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAcceptedPortfolioSharesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAcceptedPortfolioSharesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListAcceptedPortfolioSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all portfolios for which sharing was accepted by this account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListAcceptedPortfolioSharesPublisher publisher = client.listAcceptedPortfolioSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAcceptedPortfolioShares(software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAcceptedPortfolioSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListAcceptedPortfolioShares
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListAcceptedPortfolioShares"
     *      target="_top">AWS API Documentation</a>
     */
    public ListAcceptedPortfolioSharesPublisher listAcceptedPortfolioSharesPaginator(
            ListAcceptedPortfolioSharesRequest listAcceptedPortfolioSharesRequest) {
        return new ListAcceptedPortfolioSharesPublisher(this, applyPaginatorUserAgent(listAcceptedPortfolioSharesRequest));
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A Java Future containing the result of the ListBudgetsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBudgetsForResourceResponse> listBudgetsForResource(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBudgetsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBudgetsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBudgetsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBudgetsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBudgetsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBudgetsForResourceRequest, ListBudgetsForResourceResponse>()
                            .withOperationName("ListBudgetsForResource")
                            .withMarshaller(new ListBudgetsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBudgetsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listBudgetsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListBudgetsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the budgets associated to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListBudgetsForResourcePublisher publisher = client.listBudgetsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBudgetsForResource(software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBudgetsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListBudgetsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListBudgetsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    public ListBudgetsForResourcePublisher listBudgetsForResourcePaginator(
            ListBudgetsForResourceRequest listBudgetsForResourceRequest) {
        return new ListBudgetsForResourcePublisher(this, applyPaginatorUserAgent(listBudgetsForResourceRequest));
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A Java Future containing the result of the ListConstraintsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConstraintsForPortfolioResponse> listConstraintsForPortfolio(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConstraintsForPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConstraintsForPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConstraintsForPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConstraintsForPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConstraintsForPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConstraintsForPortfolioRequest, ListConstraintsForPortfolioResponse>()
                            .withOperationName("ListConstraintsForPortfolio")
                            .withMarshaller(new ListConstraintsForPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listConstraintsForPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listConstraintsForPortfolioRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListConstraintsForPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the constraints for the specified portfolio and product.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListConstraintsForPortfolioPublisher publisher = client.listConstraintsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConstraintsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConstraintsForPortfolioRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListConstraintsForPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListConstraintsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    public ListConstraintsForPortfolioPublisher listConstraintsForPortfolioPaginator(
            ListConstraintsForPortfolioRequest listConstraintsForPortfolioRequest) {
        return new ListConstraintsForPortfolioPublisher(this, applyPaginatorUserAgent(listConstraintsForPortfolioRequest));
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is
     * necessary when provisioning a product. A path also determines the constraints put on the product.
     * </p>
     *
     * @param listLaunchPathsRequest
     * @return A Java Future containing the result of the ListLaunchPaths operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLaunchPathsResponse> listLaunchPaths(ListLaunchPathsRequest listLaunchPathsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchPathsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchPaths");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLaunchPathsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLaunchPathsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLaunchPathsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLaunchPathsRequest, ListLaunchPathsResponse>()
                            .withOperationName("ListLaunchPaths")
                            .withMarshaller(new ListLaunchPathsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLaunchPathsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listLaunchPathsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListLaunchPathsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the paths to the specified product. A path is how the user has access to a specified product, and is
     * necessary when provisioning a product. A path also determines the constraints put on the product.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListLaunchPathsPublisher publisher = client.listLaunchPathsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchPaths(software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchPathsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListLaunchPaths
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListLaunchPaths" target="_top">AWS
     *      API Documentation</a>
     */
    public ListLaunchPathsPublisher listLaunchPathsPaginator(ListLaunchPathsRequest listLaunchPathsRequest) {
        return new ListLaunchPathsPublisher(this, applyPaginatorUserAgent(listLaunchPathsRequest));
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A Java Future containing the result of the ListOrganizationPortfolioAccess operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationPortfolioAccessResponse> listOrganizationPortfolioAccess(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOrganizationPortfolioAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizationPortfolioAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationPortfolioAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationPortfolioAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationPortfolioAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationPortfolioAccessRequest, ListOrganizationPortfolioAccessResponse>()
                            .withOperationName("ListOrganizationPortfolioAccess")
                            .withMarshaller(new ListOrganizationPortfolioAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOrganizationPortfolioAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listOrganizationPortfolioAccessRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListOrganizationPortfolioAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the
     * management account in the organization or by a delegated admin.
     * </p>
     * <p>
     * If a delegated admin is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListOrganizationPortfolioAccessPublisher publisher = client.listOrganizationPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationPortfolioAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListOrganizationPortfolioAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListOrganizationPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    public ListOrganizationPortfolioAccessPublisher listOrganizationPortfolioAccessPaginator(
            ListOrganizationPortfolioAccessRequest listOrganizationPortfolioAccessRequest) {
        return new ListOrganizationPortfolioAccessPublisher(this, applyPaginatorUserAgent(listOrganizationPortfolioAccessRequest));
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A Java Future containing the result of the ListPortfolioAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPortfolioAccessResponse> listPortfolioAccess(
            ListPortfolioAccessRequest listPortfolioAccessRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfolioAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfolioAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPortfolioAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPortfolioAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPortfolioAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPortfolioAccessRequest, ListPortfolioAccessResponse>()
                            .withOperationName("ListPortfolioAccess")
                            .withMarshaller(new ListPortfolioAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPortfolioAccessRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPortfolioAccessRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListPortfolioAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the account IDs that have access to the specified portfolio.
     * </p>
     * <p>
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin
     * is de-registered, they can no longer perform this operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfolioAccessPublisher publisher = client.listPortfolioAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolioAccess(software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfolioAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolioAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolioAccess"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPortfolioAccessPublisher listPortfolioAccessPaginator(ListPortfolioAccessRequest listPortfolioAccessRequest) {
        return new ListPortfolioAccessPublisher(this, applyPaginatorUserAgent(listPortfolioAccessRequest));
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A Java Future containing the result of the ListPortfolios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPortfoliosResponse> listPortfolios(ListPortfoliosRequest listPortfoliosRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfoliosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfolios");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPortfoliosResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPortfoliosResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPortfoliosResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPortfoliosRequest, ListPortfoliosResponse>()
                            .withOperationName("ListPortfolios")
                            .withMarshaller(new ListPortfoliosRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPortfoliosRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPortfoliosRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListPortfoliosResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A Java Future containing the result of the ListPortfoliosForProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPortfoliosForProductResponse> listPortfoliosForProduct(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortfoliosForProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortfoliosForProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPortfoliosForProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPortfoliosForProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPortfoliosForProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPortfoliosForProductRequest, ListPortfoliosForProductResponse>()
                            .withOperationName("ListPortfoliosForProduct")
                            .withMarshaller(new ListPortfoliosForProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPortfoliosForProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPortfoliosForProductRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListPortfoliosForProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all portfolios that the specified product is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosForProductPublisher publisher = client.listPortfoliosForProductPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfoliosForProduct(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosForProductRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfoliosForProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPortfoliosForProductPublisher listPortfoliosForProductPaginator(
            ListPortfoliosForProductRequest listPortfoliosForProductRequest) {
        return new ListPortfoliosForProductPublisher(this, applyPaginatorUserAgent(listPortfoliosForProductRequest));
    }

    /**
     * <p>
     * Lists all portfolios in the catalog.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPortfoliosPublisher publisher = client.listPortfoliosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortfolios(software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPortfoliosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPortfolios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfolios" target="_top">AWS
     *      API Documentation</a>
     */
    public ListPortfoliosPublisher listPortfoliosPaginator(ListPortfoliosRequest listPortfoliosRequest) {
        return new ListPortfoliosPublisher(this, applyPaginatorUserAgent(listPortfoliosRequest));
    }

    /**
     * <p>
     * Lists all principal ARNs associated with the specified portfolio.
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A Java Future containing the result of the ListPrincipalsForPortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPrincipalsForPortfolioResponse> listPrincipalsForPortfolio(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPrincipalsForPortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPrincipalsForPortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPrincipalsForPortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPrincipalsForPortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPrincipalsForPortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPrincipalsForPortfolioRequest, ListPrincipalsForPortfolioResponse>()
                            .withOperationName("ListPrincipalsForPortfolio")
                            .withMarshaller(new ListPrincipalsForPortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPrincipalsForPortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPrincipalsForPortfolioRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListPrincipalsForPortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all principal ARNs associated with the specified portfolio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListPrincipalsForPortfolioPublisher publisher = client.listPrincipalsForPortfolioPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrincipalsForPortfolio(software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrincipalsForPortfolioRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListPrincipalsForPortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPrincipalsForPortfolio"
     *      target="_top">AWS API Documentation</a>
     */
    public ListPrincipalsForPortfolioPublisher listPrincipalsForPortfolioPaginator(
            ListPrincipalsForPortfolioRequest listPrincipalsForPortfolioRequest) {
        return new ListPrincipalsForPortfolioPublisher(this, applyPaginatorUserAgent(listPrincipalsForPortfolioRequest));
    }

    /**
     * <p>
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     * </p>
     *
     * @param listProvisionedProductPlansRequest
     * @return A Java Future containing the result of the ListProvisionedProductPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisionedProductPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisionedProductPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProvisionedProductPlansResponse> listProvisionedProductPlans(
            ListProvisionedProductPlansRequest listProvisionedProductPlansRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisionedProductPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisionedProductPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProvisionedProductPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProvisionedProductPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProvisionedProductPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProvisionedProductPlansRequest, ListProvisionedProductPlansResponse>()
                            .withOperationName("ListProvisionedProductPlans")
                            .withMarshaller(new ListProvisionedProductPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listProvisionedProductPlansRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listProvisionedProductPlansRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListProvisionedProductPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     * </p>
     *
     * @param listProvisioningArtifactsRequest
     * @return A Java Future containing the result of the ListProvisioningArtifacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProvisioningArtifactsResponse> listProvisioningArtifacts(
            ListProvisioningArtifactsRequest listProvisioningArtifactsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisioningArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningArtifacts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProvisioningArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProvisioningArtifactsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProvisioningArtifactsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningArtifactsRequest, ListProvisioningArtifactsResponse>()
                            .withOperationName("ListProvisioningArtifacts")
                            .withMarshaller(new ListProvisioningArtifactsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listProvisioningArtifactsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listProvisioningArtifactsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListProvisioningArtifactsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A Java Future containing the result of the ListProvisioningArtifactsForServiceAction operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> listProvisioningArtifactsForServiceAction(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProvisioningArtifactsForServiceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningArtifactsForServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProvisioningArtifactsForServiceActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListProvisioningArtifactsForServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningArtifactsForServiceActionRequest, ListProvisioningArtifactsForServiceActionResponse>()
                            .withOperationName("ListProvisioningArtifactsForServiceAction")
                            .withMarshaller(new ListProvisioningArtifactsForServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listProvisioningArtifactsForServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listProvisioningArtifactsForServiceActionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListProvisioningArtifactsForServiceActionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListProvisioningArtifactsForServiceActionPublisher publisher = client.listProvisioningArtifactsForServiceActionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisioningArtifactsForServiceAction(software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisioningArtifactsForServiceActionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListProvisioningArtifactsForServiceAction
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    public ListProvisioningArtifactsForServiceActionPublisher listProvisioningArtifactsForServiceActionPaginator(
            ListProvisioningArtifactsForServiceActionRequest listProvisioningArtifactsForServiceActionRequest) {
        return new ListProvisioningArtifactsForServiceActionPublisher(this,
                applyPaginatorUserAgent(listProvisioningArtifactsForServiceActionRequest));
    }

    /**
     * <p>
     * Lists the specified requests or all performed requests.
     * </p>
     *
     * @param listRecordHistoryRequest
     * @return A Java Future containing the result of the ListRecordHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListRecordHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListRecordHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecordHistoryResponse> listRecordHistory(ListRecordHistoryRequest listRecordHistoryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecordHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecordHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecordHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecordHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecordHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecordHistoryRequest, ListRecordHistoryResponse>()
                            .withOperationName("ListRecordHistory")
                            .withMarshaller(new ListRecordHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listRecordHistoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRecordHistoryRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListRecordHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A Java Future containing the result of the ListResourcesForTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourcesForTagOptionResponse> listResourcesForTagOption(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourcesForTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourcesForTagOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourcesForTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourcesForTagOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourcesForTagOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourcesForTagOptionRequest, ListResourcesForTagOptionResponse>()
                            .withOperationName("ListResourcesForTagOption")
                            .withMarshaller(new ListResourcesForTagOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourcesForTagOptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listResourcesForTagOptionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListResourcesForTagOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the resources associated with the specified TagOption.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListResourcesForTagOptionPublisher publisher = client.listResourcesForTagOptionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesForTagOption(software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesForTagOptionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListResourcesForTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListResourcesForTagOption"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourcesForTagOptionPublisher listResourcesForTagOptionPaginator(
            ListResourcesForTagOptionRequest listResourcesForTagOptionRequest) {
        return new ListResourcesForTagOptionPublisher(this, applyPaginatorUserAgent(listResourcesForTagOptionRequest));
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A Java Future containing the result of the ListServiceActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServiceActionsResponse> listServiceActions(ListServiceActionsRequest listServiceActionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServiceActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceActions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListServiceActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListServiceActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListServiceActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServiceActionsRequest, ListServiceActionsResponse>()
                            .withOperationName("ListServiceActions")
                            .withMarshaller(new ListServiceActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listServiceActionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServiceActionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListServiceActionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A Java Future containing the result of the ListServiceActionsForProvisioningArtifact operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> listServiceActionsForProvisioningArtifact(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listServiceActionsForProvisioningArtifactRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceActionsForProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListServiceActionsForProvisioningArtifactResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListServiceActionsForProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListServiceActionsForProvisioningArtifactRequest, ListServiceActionsForProvisioningArtifactResponse>()
                            .withOperationName("ListServiceActionsForProvisioningArtifact")
                            .withMarshaller(new ListServiceActionsForProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listServiceActionsForProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listServiceActionsForProvisioningArtifactRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning
     * Artifact ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsForProvisioningArtifactPublisher publisher = client.listServiceActionsForProvisioningArtifactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActionsForProvisioningArtifact(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsForProvisioningArtifactRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActionsForProvisioningArtifact
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActionsForProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    public ListServiceActionsForProvisioningArtifactPublisher listServiceActionsForProvisioningArtifactPaginator(
            ListServiceActionsForProvisioningArtifactRequest listServiceActionsForProvisioningArtifactRequest) {
        return new ListServiceActionsForProvisioningArtifactPublisher(this,
                applyPaginatorUserAgent(listServiceActionsForProvisioningArtifactRequest));
    }

    /**
     * <p>
     * Lists all self-service actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListServiceActionsPublisher publisher = client.listServiceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceActions(software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListServiceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListServiceActions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListServiceActionsPublisher listServiceActionsPaginator(ListServiceActionsRequest listServiceActionsRequest) {
        return new ListServiceActionsPublisher(this, applyPaginatorUserAgent(listServiceActionsRequest));
    }

    /**
     * <p>
     * Returns summary information about stack instances that are associated with the specified
     * <code>CFN_STACKSET</code> type provisioned product. You can filter for stack instances that are associated with a
     * specific AWS account name or region.
     * </p>
     *
     * @param listStackInstancesForProvisionedProductRequest
     * @return A Java Future containing the result of the ListStackInstancesForProvisionedProduct operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListStackInstancesForProvisionedProduct
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStackInstancesForProvisionedProductResponse> listStackInstancesForProvisionedProduct(
            ListStackInstancesForProvisionedProductRequest listStackInstancesForProvisionedProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listStackInstancesForProvisionedProductRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStackInstancesForProvisionedProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStackInstancesForProvisionedProductResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListStackInstancesForProvisionedProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStackInstancesForProvisionedProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStackInstancesForProvisionedProductRequest, ListStackInstancesForProvisionedProductResponse>()
                            .withOperationName("ListStackInstancesForProvisionedProduct")
                            .withMarshaller(new ListStackInstancesForProvisionedProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(listStackInstancesForProvisionedProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStackInstancesForProvisionedProductRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListStackInstancesForProvisionedProductResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A Java Future containing the result of the ListTagOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagOptionsResponse> listTagOptions(ListTagOptionsRequest listTagOptionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagOptionsRequest, ListTagOptionsResponse>()
                            .withOperationName("ListTagOptions")
                            .withMarshaller(new ListTagOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagOptionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagOptionsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListTagOptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the specified TagOptions or all TagOptions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.ListTagOptionsPublisher publisher = client.listTagOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagOptions(software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ListTagOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListTagOptions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListTagOptionsPublisher listTagOptionsPaginator(ListTagOptionsRequest listTagOptionsRequest) {
        return new ListTagOptionsPublisher(this, applyPaginatorUserAgent(listTagOptionsRequest));
    }

    /**
     * <p>
     * Provisions the specified product.
     * </p>
     * <p>
     * A provisioned product is a resourced instance of a product. For example, provisioning a product based on a
     * CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of
     * this request using <a>DescribeRecord</a>.
     * </p>
     * <p>
     * If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not
     * include conflicted keys as tags, or this causes the error
     * "Parameter validation failed: Missing required parameter in Tags[<i>N</i>]:<i>Value</i>".
     * </p>
     *
     * @param provisionProductRequest
     * @return A Java Future containing the result of the ProvisionProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ProvisionProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ProvisionProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ProvisionProductResponse> provisionProduct(ProvisionProductRequest provisionProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ProvisionProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ProvisionProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ProvisionProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ProvisionProductRequest, ProvisionProductResponse>()
                            .withOperationName("ProvisionProduct")
                            .withMarshaller(new ProvisionProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(provisionProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = provisionProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ProvisionProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rejects an offer to share the specified portfolio.
     * </p>
     *
     * @param rejectPortfolioShareRequest
     * @return A Java Future containing the result of the RejectPortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.RejectPortfolioShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/RejectPortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectPortfolioShareResponse> rejectPortfolioShare(
            RejectPortfolioShareRequest rejectPortfolioShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectPortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectPortfolioShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectPortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RejectPortfolioShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectPortfolioShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectPortfolioShareRequest, RejectPortfolioShareResponse>()
                            .withOperationName("RejectPortfolioShare")
                            .withMarshaller(new RejectPortfolioShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rejectPortfolioShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rejectPortfolioShareRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<RejectPortfolioShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the provisioned products that are available (not terminated).
     * </p>
     * <p>
     * To use additional filtering, see <a>SearchProvisionedProducts</a>.
     * </p>
     *
     * @param scanProvisionedProductsRequest
     * @return A Java Future containing the result of the ScanProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.ScanProvisionedProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ScanProvisionedProductsResponse> scanProvisionedProducts(
            ScanProvisionedProductsRequest scanProvisionedProductsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, scanProvisionedProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ScanProvisionedProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ScanProvisionedProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ScanProvisionedProductsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ScanProvisionedProductsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ScanProvisionedProductsRequest, ScanProvisionedProductsResponse>()
                            .withOperationName("ScanProvisionedProducts")
                            .withMarshaller(new ScanProvisionedProductsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(scanProvisionedProductsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = scanProvisionedProductsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ScanProvisionedProductsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     *
     * @param searchProductsRequest
     * @return A Java Future containing the result of the SearchProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchProductsResponse> searchProducts(SearchProductsRequest searchProductsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchProductsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchProductsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchProductsRequest, SearchProductsResponse>()
                            .withOperationName("SearchProducts")
                            .withMarshaller(new SearchProductsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchProductsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = searchProductsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<SearchProductsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A Java Future containing the result of the SearchProductsAsAdmin operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchProductsAsAdminResponse> searchProductsAsAdmin(
            SearchProductsAsAdminRequest searchProductsAsAdminRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProductsAsAdminRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProductsAsAdmin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchProductsAsAdminResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchProductsAsAdminResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchProductsAsAdminResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchProductsAsAdminRequest, SearchProductsAsAdminResponse>()
                            .withOperationName("SearchProductsAsAdmin")
                            .withMarshaller(new SearchProductsAsAdminRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchProductsAsAdminRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = searchProductsAsAdminRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<SearchProductsAsAdminResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the products for the specified portfolio or all products.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsAsAdminPublisher publisher = client.searchProductsAsAdminPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProductsAsAdmin(software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsAsAdminRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProductsAsAdmin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchProductsAsAdminPublisher searchProductsAsAdminPaginator(SearchProductsAsAdminRequest searchProductsAsAdminRequest) {
        return new SearchProductsAsAdminPublisher(this, applyPaginatorUserAgent(searchProductsAsAdminRequest));
    }

    /**
     * <p>
     * Gets information about the products to which the caller has access.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProductsPublisher publisher = client.searchProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProducts" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchProductsPublisher searchProductsPaginator(SearchProductsRequest searchProductsRequest) {
        return new SearchProductsPublisher(this, applyPaginatorUserAgent(searchProductsRequest));
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A Java Future containing the result of the SearchProvisionedProducts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchProvisionedProductsResponse> searchProvisionedProducts(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchProvisionedProductsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchProvisionedProducts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchProvisionedProductsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchProvisionedProductsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchProvisionedProductsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchProvisionedProductsRequest, SearchProvisionedProductsResponse>()
                            .withOperationName("SearchProvisionedProducts")
                            .withMarshaller(new SearchProvisionedProductsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchProvisionedProductsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = searchProvisionedProductsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<SearchProvisionedProductsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the provisioned products that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalog.paginators.SearchProvisionedProductsPublisher publisher = client.searchProvisionedProductsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of PageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProvisionedProducts(software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProvisionedProductsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.SearchProvisionedProducts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchProvisionedProductsPublisher searchProvisionedProductsPaginator(
            SearchProvisionedProductsRequest searchProvisionedProductsRequest) {
        return new SearchProvisionedProductsPublisher(this, applyPaginatorUserAgent(searchProvisionedProductsRequest));
    }

    /**
     * <p>
     * Terminates the specified provisioned product.
     * </p>
     * <p>
     * This operation does not delete any records associated with the provisioned product.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param terminateProvisionedProductRequest
     * @return A Java Future containing the result of the TerminateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.TerminateProvisionedProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/TerminateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TerminateProvisionedProductResponse> terminateProvisionedProduct(
            TerminateProvisionedProductRequest terminateProvisionedProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateProvisionedProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TerminateProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TerminateProvisionedProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TerminateProvisionedProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TerminateProvisionedProductRequest, TerminateProvisionedProductResponse>()
                            .withOperationName("TerminateProvisionedProduct")
                            .withMarshaller(new TerminateProvisionedProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(terminateProvisionedProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = terminateProvisionedProductRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<TerminateProvisionedProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified constraint.
     * </p>
     *
     * @param updateConstraintRequest
     * @return A Java Future containing the result of the UpdateConstraint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateConstraint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateConstraint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConstraintResponse> updateConstraint(UpdateConstraintRequest updateConstraintRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConstraintRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConstraint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConstraintResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConstraintResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConstraintResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConstraintRequest, UpdateConstraintResponse>()
                            .withOperationName("UpdateConstraint")
                            .withMarshaller(new UpdateConstraintRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateConstraintRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateConstraintRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateConstraintResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified portfolio.
     * </p>
     * <p>
     * You cannot update a product that was shared with you.
     * </p>
     *
     * @param updatePortfolioRequest
     * @return A Java Future containing the result of the UpdatePortfolio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>LimitExceededException The current limits of the service would have been exceeded by this operation.
     *         Decrease your resource use or increase your service limits and retry the operation.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolio" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePortfolioResponse> updatePortfolio(UpdatePortfolioRequest updatePortfolioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortfolioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortfolio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePortfolioResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePortfolioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePortfolioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePortfolioRequest, UpdatePortfolioResponse>()
                            .withOperationName("UpdatePortfolio")
                            .withMarshaller(new UpdatePortfolioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePortfolioRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePortfolioRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdatePortfolioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an
     * existing portfolio share.
     * </p>
     * <p>
     * The portfolio share cannot be updated if the <code> CreatePortfolioShare</code> operation is
     * <code>IN_PROGRESS</code>, as the share is not available to recipient entities. In this case, you must wait for
     * the portfolio share to be COMPLETED.
     * </p>
     * <p>
     * You must provide the <code>accountId</code> or organization node in the input, but not both.
     * </p>
     * <p>
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be
     * updated, you must invoke <code>UpdatePortfolioShare</code> separately for each share type.
     * </p>
     * <p>
     * This API cannot be used for removing the portfolio share. You must use <code>DeletePortfolioShare</code> API for
     * that action.
     * </p>
     *
     * @param updatePortfolioShareRequest
     * @return A Java Future containing the result of the UpdatePortfolioShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>OperationNotSupportedException The operation is not supported.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdatePortfolioShare
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdatePortfolioShare"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePortfolioShareResponse> updatePortfolioShare(
            UpdatePortfolioShareRequest updatePortfolioShareRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortfolioShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortfolioShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePortfolioShareResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePortfolioShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePortfolioShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePortfolioShareRequest, UpdatePortfolioShareResponse>()
                            .withOperationName("UpdatePortfolioShare")
                            .withMarshaller(new UpdatePortfolioShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePortfolioShareRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePortfolioShareRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdatePortfolioShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified product.
     * </p>
     *
     * @param updateProductRequest
     * @return A Java Future containing the result of the UpdateProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProduct" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProductResponse> updateProduct(UpdateProductRequest updateProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProductResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProductRequest, UpdateProductResponse>()
                            .withOperationName("UpdateProduct")
                            .withMarshaller(new UpdateProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateProductRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests updates to the configuration of the specified provisioned product.
     * </p>
     * <p>
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates
     * requested, this operation can update with no interruption, with some interruption, or replace the provisioned
     * product entirely.
     * </p>
     * <p>
     * You can check the status of this request using <a>DescribeRecord</a>.
     * </p>
     *
     * @param updateProvisionedProductRequest
     * @return A Java Future containing the result of the UpdateProvisionedProduct operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProduct
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProvisionedProductResponse> updateProvisionedProduct(
            UpdateProvisionedProductRequest updateProvisionedProductRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProvisionedProductRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisionedProduct");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProvisionedProductResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProvisionedProductResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProvisionedProductResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisionedProductRequest, UpdateProvisionedProductResponse>()
                            .withOperationName("UpdateProvisionedProduct")
                            .withMarshaller(new UpdateProvisionedProductRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateProvisionedProductRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateProvisionedProductRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateProvisionedProductResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests updates to the properties of the specified provisioned product.
     * </p>
     *
     * @param updateProvisionedProductPropertiesRequest
     * @return A Java Future containing the result of the UpdateProvisionedProductProperties operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidStateException An attempt was made to modify a resource that is in a state that is not valid.
     *         Check your resources to ensure that they are in valid states before retrying the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisionedProductProperties
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProvisionedProductPropertiesResponse> updateProvisionedProductProperties(
            UpdateProvisionedProductPropertiesRequest updateProvisionedProductPropertiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateProvisionedProductPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisionedProductProperties");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProvisionedProductPropertiesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateProvisionedProductPropertiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProvisionedProductPropertiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisionedProductPropertiesRequest, UpdateProvisionedProductPropertiesResponse>()
                            .withOperationName("UpdateProvisionedProductProperties")
                            .withMarshaller(new UpdateProvisionedProductPropertiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateProvisionedProductPropertiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateProvisionedProductPropertiesRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateProvisionedProductPropertiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     * </p>
     * <p>
     * You cannot update a provisioning artifact for a product that was shared with you.
     * </p>
     *
     * @param updateProvisioningArtifactRequest
     * @return A Java Future containing the result of the UpdateProvisioningArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateProvisioningArtifact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProvisioningArtifactResponse> updateProvisioningArtifact(
            UpdateProvisioningArtifactRequest updateProvisioningArtifactRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProvisioningArtifactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisioningArtifact");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProvisioningArtifactResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProvisioningArtifactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProvisioningArtifactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisioningArtifactRequest, UpdateProvisioningArtifactResponse>()
                            .withOperationName("UpdateProvisioningArtifact")
                            .withMarshaller(new UpdateProvisioningArtifactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateProvisioningArtifactRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateProvisioningArtifactRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateProvisioningArtifactResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a self-service action.
     * </p>
     *
     * @param updateServiceActionRequest
     * @return A Java Future containing the result of the UpdateServiceAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateServiceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateServiceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateServiceActionResponse> updateServiceAction(
            UpdateServiceActionRequest updateServiceActionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServiceActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceAction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateServiceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateServiceActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateServiceActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateServiceActionRequest, UpdateServiceActionResponse>()
                            .withOperationName("UpdateServiceAction")
                            .withMarshaller(new UpdateServiceActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateServiceActionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateServiceActionRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateServiceActionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified TagOption.
     * </p>
     *
     * @param updateTagOptionRequest
     * @return A Java Future containing the result of the UpdateTagOption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagOptionNotMigratedException An operation requiring TagOptions failed because the TagOptions
     *         migration process has not been performed for this account. Please use the AWS console to perform the
     *         migration process before retrying the operation.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>DuplicateResourceException The specified resource is a duplicate.</li>
     *         <li>InvalidParametersException One or more parameters provided to the operation are not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceCatalogException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceCatalogAsyncClient.UpdateTagOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateTagOption" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTagOptionResponse> updateTagOption(UpdateTagOptionRequest updateTagOptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTagOptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Service Catalog");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTagOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTagOptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTagOptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTagOptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTagOptionRequest, UpdateTagOptionResponse>()
                            .withOperationName("UpdateTagOption")
                            .withMarshaller(new UpdateTagOptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTagOptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTagOptionRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateTagOptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ServiceCatalogException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParametersException")
                                .exceptionBuilderSupplier(InvalidParametersException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                                .exceptionBuilderSupplier(OperationNotSupportedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateException")
                                .exceptionBuilderSupplier(InvalidStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateResourceException")
                                .exceptionBuilderSupplier(DuplicateResourceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagOptionNotMigratedException")
                                .exceptionBuilderSupplier(TagOptionNotMigratedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ServiceCatalogRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
