/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceActionAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceActionAssociation> {
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceActionId").getter(ServiceActionAssociation.getter(ServiceActionAssociation::serviceActionId)).setter(ServiceActionAssociation.setter(Builder::serviceActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ServiceActionAssociation.getter(ServiceActionAssociation::productId)).setter(ServiceActionAssociation.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ServiceActionAssociation.getter(ServiceActionAssociation::provisioningArtifactId)).setter(ServiceActionAssociation.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ID_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serviceActionId;
    private final String productId;
    private final String provisioningArtifactId;

    private ServiceActionAssociation(BuilderImpl builder) {
        this.serviceActionId = builder.serviceActionId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    public final String serviceActionId() {
        return this.serviceActionId;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionAssociation)) {
            return false;
        }
        ServiceActionAssociation other = (ServiceActionAssociation)obj;
        return Objects.equals(this.serviceActionId(), other.serviceActionId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceActionAssociation").add("ServiceActionId", (Object)this.serviceActionId()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionId": {
                return Optional.ofNullable(clazz.cast(this.serviceActionId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionAssociation, T> g) {
        return obj -> g.apply((ServiceActionAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceActionId;
        private String productId;
        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionAssociation model) {
            this.serviceActionId(model.serviceActionId);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getServiceActionId() {
            return this.serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public ServiceActionAssociation build() {
            return new ServiceActionAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceActionAssociation> {
        public Builder serviceActionId(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);
    }
}

