/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisionedProductPlanResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, CreateProvisionedProductPlanResponse> {
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanName").getter(CreateProvisionedProductPlanResponse.getter(CreateProvisionedProductPlanResponse::planName)).setter(CreateProvisionedProductPlanResponse.setter(Builder::planName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()}).build();
    private static final SdkField<String> PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanId").getter(CreateProvisionedProductPlanResponse.getter(CreateProvisionedProductPlanResponse::planId)).setter(CreateProvisionedProductPlanResponse.setter(Builder::planId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionProductId").getter(CreateProvisionedProductPlanResponse.getter(CreateProvisionedProductPlanResponse::provisionProductId)).setter(CreateProvisionedProductPlanResponse.setter(Builder::provisionProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionedProductName").getter(CreateProvisionedProductPlanResponse.getter(CreateProvisionedProductPlanResponse::provisionedProductName)).setter(CreateProvisionedProductPlanResponse.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(CreateProvisionedProductPlanResponse.getter(CreateProvisionedProductPlanResponse::provisioningArtifactId)).setter(CreateProvisionedProductPlanResponse.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_NAME_FIELD, PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_ARTIFACT_ID_FIELD));
    private final String planName;
    private final String planId;
    private final String provisionProductId;
    private final String provisionedProductName;
    private final String provisioningArtifactId;

    private CreateProvisionedProductPlanResponse(BuilderImpl builder) {
        super(builder);
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    public final String planName() {
        return this.planName;
    }

    public final String planId() {
        return this.planId;
    }

    public final String provisionProductId() {
        return this.provisionProductId;
    }

    public final String provisionedProductName() {
        return this.provisionedProductName;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisionedProductPlanResponse)) {
            return false;
        }
        CreateProvisionedProductPlanResponse other = (CreateProvisionedProductPlanResponse)((Object)obj);
        return Objects.equals(this.planName(), other.planName()) && Objects.equals(this.planId(), other.planId()) && Objects.equals(this.provisionProductId(), other.provisionProductId()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisionedProductPlanResponse").add("PlanName", (Object)this.planName()).add("PlanId", (Object)this.planId()).add("ProvisionProductId", (Object)this.provisionProductId()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlanName": {
                return Optional.ofNullable(clazz.cast(this.planName()));
            }
            case "PlanId": {
                return Optional.ofNullable(clazz.cast(this.planId()));
            }
            case "ProvisionProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionProductId()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisionedProductPlanResponse, T> g) {
        return obj -> g.apply((CreateProvisionedProductPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private String planName;
        private String planId;
        private String provisionProductId;
        private String provisionedProductName;
        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisionedProductPlanResponse model) {
            super(model);
            this.planName(model.planName);
            this.planId(model.planId);
            this.provisionProductId(model.provisionProductId);
            this.provisionedProductName(model.provisionedProductName);
            this.provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getPlanName() {
            return this.planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        public final String getPlanId() {
            return this.planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        public final String getProvisionProductId() {
            return this.provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public CreateProvisionedProductPlanResponse build() {
            return new CreateProvisionedProductPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisionedProductPlanResponse> {
        public Builder planName(String var1);

        public Builder planId(String var1);

        public Builder provisionProductId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisioningArtifactId(String var1);
    }
}

