/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactGuidance;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningArtifactDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningArtifactDetail> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::id)).setter(ProvisioningArtifactDetail.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::name)).setter(ProvisioningArtifactDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::description)).setter(ProvisioningArtifactDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::typeAsString)).setter(ProvisioningArtifactDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::createdTime)).setter(ProvisioningArtifactDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Active").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::active)).setter(ProvisioningArtifactDetail.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()}).build();
    private static final SdkField<String> GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Guidance").getter(ProvisioningArtifactDetail.getter(ProvisioningArtifactDetail::guidanceAsString)).setter(ProvisioningArtifactDetail.setter(Builder::guidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Guidance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, CREATED_TIME_FIELD, ACTIVE_FIELD, GUIDANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String description;
    private final String type;
    private final Instant createdTime;
    private final Boolean active;
    private final String guidance;

    private ProvisioningArtifactDetail(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.createdTime = builder.createdTime;
        this.active = builder.active;
        this.guidance = builder.guidance;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public ProvisioningArtifactType type() {
        return ProvisioningArtifactType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Boolean active() {
        return this.active;
    }

    public ProvisioningArtifactGuidance guidance() {
        return ProvisioningArtifactGuidance.fromValue(this.guidance);
    }

    public String guidanceAsString() {
        return this.guidance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.guidanceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactDetail)) {
            return false;
        }
        ProvisioningArtifactDetail other = (ProvisioningArtifactDetail)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.guidanceAsString(), other.guidanceAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProvisioningArtifactDetail").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("CreatedTime", (Object)this.createdTime()).add("Active", (Object)this.active()).add("Guidance", (Object)this.guidanceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "Guidance": {
                return Optional.ofNullable(clazz.cast(this.guidanceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactDetail, T> g) {
        return obj -> g.apply((ProvisioningArtifactDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String type;
        private Instant createdTime;
        private Boolean active;
        private String guidance;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactDetail model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.createdTime(model.createdTime);
            this.active(model.active);
            this.guidance(model.guidance);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getGuidance() {
            return this.guidance;
        }

        @Override
        public final Builder guidance(String guidance) {
            this.guidance = guidance;
            return this;
        }

        @Override
        public final Builder guidance(ProvisioningArtifactGuidance guidance) {
            this.guidance(guidance == null ? null : guidance.toString());
            return this;
        }

        public final void setGuidance(String guidance) {
            this.guidance = guidance;
        }

        public ProvisioningArtifactDetail build() {
            return new ProvisioningArtifactDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningArtifactDetail> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(ProvisioningArtifactType var1);

        public Builder createdTime(Instant var1);

        public Builder active(Boolean var1);

        public Builder guidance(String var1);

        public Builder guidance(ProvisioningArtifactGuidance var1);
    }
}

