/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;

public class ListServiceActionsPublisher
implements SdkPublisher<ListServiceActionsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListServiceActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceActionsPublisher(ServiceCatalogAsyncClient client, ListServiceActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceActionsPublisher(ServiceCatalogAsyncClient client, ListServiceActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListServiceActionsResponseFetcher
    implements AsyncPageFetcher<ListServiceActionsResponse> {
        private ListServiceActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListServiceActionsResponse> nextPage(ListServiceActionsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceActionsPublisher.this.client.listServiceActions(ListServiceActionsPublisher.this.firstRequest);
            }
            return ListServiceActionsPublisher.this.client.listServiceActions((ListServiceActionsRequest)((Object)ListServiceActionsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

