/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfolioAccessResponse;

public class ListPortfolioAccessPublisher
implements SdkPublisher<ListPortfolioAccessResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListPortfolioAccessRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPortfolioAccessPublisher(ServiceCatalogAsyncClient client, ListPortfolioAccessRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPortfolioAccessPublisher(ServiceCatalogAsyncClient client, ListPortfolioAccessRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPortfolioAccessResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPortfolioAccessResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPortfolioAccessResponseFetcher
    implements AsyncPageFetcher<ListPortfolioAccessResponse> {
        private ListPortfolioAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfolioAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListPortfolioAccessResponse> nextPage(ListPortfolioAccessResponse previousPage) {
            if (previousPage == null) {
                return ListPortfolioAccessPublisher.this.client.listPortfolioAccess(ListPortfolioAccessPublisher.this.firstRequest);
            }
            return ListPortfolioAccessPublisher.this.client.listPortfolioAccess((ListPortfolioAccessRequest)((Object)ListPortfolioAccessPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

