/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.NotificationArnsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanStatus;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanType;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.UpdateProvisioningParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionedProductPlanDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisionedProductPlanDetails> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::createdTime)).setter(ProvisionedProductPlanDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathId").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::pathId)).setter(ProvisionedProductPlanDetails.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::productId)).setter(ProvisionedProductPlanDetails.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanName").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::planName)).setter(ProvisionedProductPlanDetails.setter(Builder::planName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()}).build();
    private static final SdkField<String> PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanId").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::planId)).setter(ProvisionedProductPlanDetails.setter(Builder::planId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionProductId").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::provisionProductId)).setter(ProvisionedProductPlanDetails.setter(Builder::provisionProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisionProductName").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::provisionProductName)).setter(ProvisionedProductPlanDetails.setter(Builder::provisionProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductName").build()}).build();
    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlanType").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::planTypeAsString)).setter(ProvisionedProductPlanDetails.setter(Builder::planType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanType").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::provisioningArtifactId)).setter(ProvisionedProductPlanDetails.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::statusAsString)).setter(ProvisionedProductPlanDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::updatedTime)).setter(ProvisionedProductPlanDetails.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationArns").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::notificationArns)).setter(ProvisionedProductPlanDetails.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UpdateProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningParameters").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::provisioningParameters)).setter(ProvisionedProductPlanDetails.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::tags)).setter(ProvisionedProductPlanDetails.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProvisionedProductPlanDetails.getter(ProvisionedProductPlanDetails::statusMessage)).setter(ProvisionedProductPlanDetails.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, PATH_ID_FIELD, PRODUCT_ID_FIELD, PLAN_NAME_FIELD, PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD, PROVISION_PRODUCT_NAME_FIELD, PLAN_TYPE_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, STATUS_FIELD, UPDATED_TIME_FIELD, NOTIFICATION_ARNS_FIELD, PROVISIONING_PARAMETERS_FIELD, TAGS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdTime;
    private final String pathId;
    private final String productId;
    private final String planName;
    private final String planId;
    private final String provisionProductId;
    private final String provisionProductName;
    private final String planType;
    private final String provisioningArtifactId;
    private final String status;
    private final Instant updatedTime;
    private final List<String> notificationArns;
    private final List<UpdateProvisioningParameter> provisioningParameters;
    private final List<Tag> tags;
    private final String statusMessage;

    private ProvisionedProductPlanDetails(BuilderImpl builder) {
        this.createdTime = builder.createdTime;
        this.pathId = builder.pathId;
        this.productId = builder.productId;
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionProductName = builder.provisionProductName;
        this.planType = builder.planType;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.status = builder.status;
        this.updatedTime = builder.updatedTime;
        this.notificationArns = builder.notificationArns;
        this.provisioningParameters = builder.provisioningParameters;
        this.tags = builder.tags;
        this.statusMessage = builder.statusMessage;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String pathId() {
        return this.pathId;
    }

    public String productId() {
        return this.productId;
    }

    public String planName() {
        return this.planName;
    }

    public String planId() {
        return this.planId;
    }

    public String provisionProductId() {
        return this.provisionProductId;
    }

    public String provisionProductName() {
        return this.provisionProductName;
    }

    public ProvisionedProductPlanType planType() {
        return ProvisionedProductPlanType.fromValue(this.planType);
    }

    public String planTypeAsString() {
        return this.planType;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public ProvisionedProductPlanStatus status() {
        return ProvisionedProductPlanStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant updatedTime() {
        return this.updatedTime;
    }

    public boolean hasNotificationArns() {
        return this.notificationArns != null && !(this.notificationArns instanceof SdkAutoConstructList);
    }

    public List<String> notificationArns() {
        return this.notificationArns;
    }

    public boolean hasProvisioningParameters() {
        return this.provisioningParameters != null && !(this.provisioningParameters instanceof SdkAutoConstructList);
    }

    public List<UpdateProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.planName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationArns() ? this.notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningParameters() ? this.provisioningParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductPlanDetails)) {
            return false;
        }
        ProvisionedProductPlanDetails other = (ProvisionedProductPlanDetails)obj;
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.planName(), other.planName()) && Objects.equals(this.planId(), other.planId()) && Objects.equals(this.provisionProductId(), other.provisionProductId()) && Objects.equals(this.provisionProductName(), other.provisionProductName()) && Objects.equals(this.planTypeAsString(), other.planTypeAsString()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedTime(), other.updatedTime()) && this.hasNotificationArns() == other.hasNotificationArns() && Objects.equals(this.notificationArns(), other.notificationArns()) && this.hasProvisioningParameters() == other.hasProvisioningParameters() && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionedProductPlanDetails").add("CreatedTime", (Object)this.createdTime()).add("PathId", (Object)this.pathId()).add("ProductId", (Object)this.productId()).add("PlanName", (Object)this.planName()).add("PlanId", (Object)this.planId()).add("ProvisionProductId", (Object)this.provisionProductId()).add("ProvisionProductName", (Object)this.provisionProductName()).add("PlanType", (Object)this.planTypeAsString()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("Status", (Object)this.statusAsString()).add("UpdatedTime", (Object)this.updatedTime()).add("NotificationArns", this.hasNotificationArns() ? this.notificationArns() : null).add("ProvisioningParameters", this.hasProvisioningParameters() ? this.provisioningParameters() : null).add("Tags", this.hasTags() ? this.tags() : null).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "PlanName": {
                return Optional.ofNullable(clazz.cast(this.planName()));
            }
            case "PlanId": {
                return Optional.ofNullable(clazz.cast(this.planId()));
            }
            case "ProvisionProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionProductId()));
            }
            case "ProvisionProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionProductName()));
            }
            case "PlanType": {
                return Optional.ofNullable(clazz.cast(this.planTypeAsString()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductPlanDetails, T> g) {
        return obj -> g.apply((ProvisionedProductPlanDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdTime;
        private String pathId;
        private String productId;
        private String planName;
        private String planId;
        private String provisionProductId;
        private String provisionProductName;
        private String planType;
        private String provisioningArtifactId;
        private String status;
        private Instant updatedTime;
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private List<UpdateProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductPlanDetails model) {
            this.createdTime(model.createdTime);
            this.pathId(model.pathId);
            this.productId(model.productId);
            this.planName(model.planName);
            this.planId(model.planId);
            this.provisionProductId(model.provisionProductId);
            this.provisionProductName(model.provisionProductName);
            this.planType(model.planType);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.status(model.status);
            this.updatedTime(model.updatedTime);
            this.notificationArns(model.notificationArns);
            this.provisioningParameters(model.provisioningParameters);
            this.tags(model.tags);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getPlanName() {
            return this.planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        public final String getPlanId() {
            return this.planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        public final String getProvisionProductId() {
            return this.provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        public final String getProvisionProductName() {
            return this.provisionProductName;
        }

        @Override
        public final Builder provisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
            return this;
        }

        public final void setProvisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
        }

        public final String getPlanType() {
            return this.planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(ProvisionedProductPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedProductPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        public final Collection<String> getNotificationArns() {
            if (this.notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        public final Collection<UpdateProvisioningParameter.Builder> getProvisioningParameters() {
            if (this.provisioningParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.provisioningParameters != null ? (Collection)this.provisioningParameters.stream().map(UpdateProvisioningParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<UpdateProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(UpdateProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (UpdateProvisioningParameter)((UpdateProvisioningParameter.Builder)UpdateProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<UpdateProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = UpdateProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ProvisionedProductPlanDetails build() {
            return new ProvisionedProductPlanDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisionedProductPlanDetails> {
        public Builder createdTime(Instant var1);

        public Builder pathId(String var1);

        public Builder productId(String var1);

        public Builder planName(String var1);

        public Builder planId(String var1);

        public Builder provisionProductId(String var1);

        public Builder provisionProductName(String var1);

        public Builder planType(String var1);

        public Builder planType(ProvisionedProductPlanType var1);

        public Builder provisioningArtifactId(String var1);

        public Builder status(String var1);

        public Builder status(ProvisionedProductPlanStatus var1);

        public Builder updatedTime(Instant var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder provisioningParameters(Collection<UpdateProvisioningParameter> var1);

        public Builder provisioningParameters(UpdateProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<UpdateProvisioningParameter.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder statusMessage(String var1);
    }
}

