/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecordStatus {
    CREATED("CREATED"),
    IN_PROGRESS("IN_PROGRESS"),
    IN_PROGRESS_IN_ERROR("IN_PROGRESS_IN_ERROR"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecordStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecordStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordStatus> knownValues() {
        return Stream.of(RecordStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

