/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.Principal;
import software.amazon.awssdk.services.servicecatalog.model.PrincipalsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPrincipalsForPortfolioResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListPrincipalsForPortfolioResponse> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Principals").getter(ListPrincipalsForPortfolioResponse.getter(ListPrincipalsForPortfolioResponse::principals)).setter(ListPrincipalsForPortfolioResponse.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListPrincipalsForPortfolioResponse.getter(ListPrincipalsForPortfolioResponse::nextPageToken)).setter(ListPrincipalsForPortfolioResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPALS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<Principal> principals;
    private final String nextPageToken;

    private ListPrincipalsForPortfolioResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalsForPortfolioResponse)) {
            return false;
        }
        ListPrincipalsForPortfolioResponse other = (ListPrincipalsForPortfolioResponse)((Object)obj);
        return Objects.equals(this.principals(), other.principals()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPrincipalsForPortfolioResponse").add("Principals", this.principals()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrincipalsForPortfolioResponse, T> g) {
        return obj -> g.apply((ListPrincipalsForPortfolioResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalsForPortfolioResponse model) {
            super(model);
            this.principals(model.principals);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Principal.Builder> getPrincipals() {
            return this.principals != null ? (Collection)this.principals.stream().map(Principal::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalsCopier.copyFromBuilder(principals);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListPrincipalsForPortfolioResponse build() {
            return new ListPrincipalsForPortfolioResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPrincipalsForPortfolioResponse> {
        public Builder principals(Collection<Principal> var1);

        public Builder principals(Principal ... var1);

        public Builder principals(Consumer<Principal.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

