/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateTagOptionWithResourceRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, AssociateTagOptionWithResourceRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(AssociateTagOptionWithResourceRequest.getter(AssociateTagOptionWithResourceRequest::resourceId)).setter(AssociateTagOptionWithResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> TAG_OPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagOptionId").getter(AssociateTagOptionWithResourceRequest.getter(AssociateTagOptionWithResourceRequest::tagOptionId)).setter(AssociateTagOptionWithResourceRequest.setter(Builder::tagOptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, TAG_OPTION_ID_FIELD));
    private final String resourceId;
    private final String tagOptionId;

    private AssociateTagOptionWithResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagOptionId = builder.tagOptionId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String tagOptionId() {
        return this.tagOptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTagOptionWithResourceRequest)) {
            return false;
        }
        AssociateTagOptionWithResourceRequest other = (AssociateTagOptionWithResourceRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.tagOptionId(), other.tagOptionId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateTagOptionWithResourceRequest").add("ResourceId", (Object)this.resourceId()).add("TagOptionId", (Object)this.tagOptionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "TagOptionId": {
                return Optional.ofNullable(clazz.cast(this.tagOptionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTagOptionWithResourceRequest, T> g) {
        return obj -> g.apply((AssociateTagOptionWithResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String tagOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTagOptionWithResourceRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.tagOptionId(model.tagOptionId);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTagOptionId() {
            return this.tagOptionId;
        }

        @Override
        public final Builder tagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        public final void setTagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTagOptionWithResourceRequest build() {
            return new AssociateTagOptionWithResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateTagOptionWithResourceRequest> {
        public Builder resourceId(String var1);

        public Builder tagOptionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

