/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A self-service action association consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceActionAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceActionAssociation.Builder, ServiceActionAssociation> {
    private static final SdkField<String> SERVICE_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionAssociation::serviceActionId)).setter(setter(Builder::serviceActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionId").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionAssociation::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceActionAssociation::provisioningArtifactId)).setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_ID_FIELD,
            PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceActionId;

    private final String productId;

    private final String provisioningArtifactId;

    private ServiceActionAssociation(BuilderImpl builder) {
        this.serviceActionId = builder.serviceActionId;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    /**
     * <p>
     * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     * </p>
     * 
     * @return The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
     */
    public String serviceActionId() {
        return serviceActionId;
    }

    /**
     * <p>
     * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     * </p>
     * 
     * @return The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
     */
    public String productId() {
        return productId;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     * </p>
     * 
     * @return The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
     */
    public String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionId());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceActionAssociation)) {
            return false;
        }
        ServiceActionAssociation other = (ServiceActionAssociation) obj;
        return Objects.equals(serviceActionId(), other.serviceActionId()) && Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceActionAssociation").add("ServiceActionId", serviceActionId())
                .add("ProductId", productId()).add("ProvisioningArtifactId", provisioningArtifactId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionId":
            return Optional.ofNullable(clazz.cast(serviceActionId()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceActionAssociation, T> g) {
        return obj -> g.apply((ServiceActionAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceActionAssociation> {
        /**
         * <p>
         * The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * </p>
         * 
         * @param serviceActionId
         *        The self-service action identifier. For example, <code>act-fs7abcd89wxyz</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionId(String serviceActionId);

        /**
         * <p>
         * The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * </p>
         * 
         * @param productId
         *        The product identifier. For example, <code>prod-abcdzk7xy33qa</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact. For example, <code>pa-4abcdjnxjj6ne</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);
    }

    static final class BuilderImpl implements Builder {
        private String serviceActionId;

        private String productId;

        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceActionAssociation model) {
            serviceActionId(model.serviceActionId);
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getServiceActionId() {
            return serviceActionId;
        }

        @Override
        public final Builder serviceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        public final void setServiceActionId(String serviceActionId) {
            this.serviceActionId = serviceActionId;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public ServiceActionAssociation build() {
            return new ServiceActionAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
