/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a change to a resource attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceChangeDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceChangeDetail.Builder, ResourceChangeDetail> {
    private static final SdkField<ResourceTargetDefinition> TARGET_FIELD = SdkField
            .<ResourceTargetDefinition> builder(MarshallingType.SDK_POJO).getter(getter(ResourceChangeDetail::target))
            .setter(setter(Builder::target)).constructor(ResourceTargetDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> EVALUATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChangeDetail::evaluationAsString)).setter(setter(Builder::evaluation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluation").build()).build();

    private static final SdkField<String> CAUSING_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceChangeDetail::causingEntity)).setter(setter(Builder::causingEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CausingEntity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD,
            EVALUATION_FIELD, CAUSING_ENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceTargetDefinition target;

    private final String evaluation;

    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.causingEntity = builder.causingEntity;
    }

    /**
     * <p>
     * Information about the resource attribute to be modified.
     * </p>
     * 
     * @return Information about the resource attribute to be modified.
     */
    public ResourceTargetDefinition target() {
        return target;
    }

    /**
     * <p>
     * For static evaluations, the value of the resource attribute will change and the new value is known. For dynamic
     * evaluations, the value might change, and any new value will be determined when the plan is updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluation} will
     * return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #evaluationAsString}.
     * </p>
     * 
     * @return For static evaluations, the value of the resource attribute will change and the new value is known. For
     *         dynamic evaluations, the value might change, and any new value will be determined when the plan is
     *         updated.
     * @see EvaluationType
     */
    public EvaluationType evaluation() {
        return EvaluationType.fromValue(evaluation);
    }

    /**
     * <p>
     * For static evaluations, the value of the resource attribute will change and the new value is known. For dynamic
     * evaluations, the value might change, and any new value will be determined when the plan is updated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluation} will
     * return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #evaluationAsString}.
     * </p>
     * 
     * @return For static evaluations, the value of the resource attribute will change and the new value is known. For
     *         dynamic evaluations, the value might change, and any new value will be determined when the plan is
     *         updated.
     * @see EvaluationType
     */
    public String evaluationAsString() {
        return evaluation;
    }

    /**
     * <p>
     * The ID of the entity that caused the change.
     * </p>
     * 
     * @return The ID of the entity that caused the change.
     */
    public String causingEntity() {
        return causingEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(causingEntity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(evaluationAsString(), other.evaluationAsString())
                && Objects.equals(causingEntity(), other.causingEntity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceChangeDetail").add("Target", target()).add("Evaluation", evaluationAsString())
                .add("CausingEntity", causingEntity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Evaluation":
            return Optional.ofNullable(clazz.cast(evaluationAsString()));
        case "CausingEntity":
            return Optional.ofNullable(clazz.cast(causingEntity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceChangeDetail, T> g) {
        return obj -> g.apply((ResourceChangeDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceChangeDetail> {
        /**
         * <p>
         * Information about the resource attribute to be modified.
         * </p>
         * 
         * @param target
         *        Information about the resource attribute to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(ResourceTargetDefinition target);

        /**
         * <p>
         * Information about the resource attribute to be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceTargetDefinition.Builder} avoiding the
         * need to create one manually via {@link ResourceTargetDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceTargetDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #target(ResourceTargetDefinition)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link ResourceTargetDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(ResourceTargetDefinition)
         */
        default Builder target(Consumer<ResourceTargetDefinition.Builder> target) {
            return target(ResourceTargetDefinition.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * For static evaluations, the value of the resource attribute will change and the new value is known. For
         * dynamic evaluations, the value might change, and any new value will be determined when the plan is updated.
         * </p>
         * 
         * @param evaluation
         *        For static evaluations, the value of the resource attribute will change and the new value is known.
         *        For dynamic evaluations, the value might change, and any new value will be determined when the plan is
         *        updated.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluation(String evaluation);

        /**
         * <p>
         * For static evaluations, the value of the resource attribute will change and the new value is known. For
         * dynamic evaluations, the value might change, and any new value will be determined when the plan is updated.
         * </p>
         * 
         * @param evaluation
         *        For static evaluations, the value of the resource attribute will change and the new value is known.
         *        For dynamic evaluations, the value might change, and any new value will be determined when the plan is
         *        updated.
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluation(EvaluationType evaluation);

        /**
         * <p>
         * The ID of the entity that caused the change.
         * </p>
         * 
         * @param causingEntity
         *        The ID of the entity that caused the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder causingEntity(String causingEntity);
    }

    static final class BuilderImpl implements Builder {
        private ResourceTargetDefinition target;

        private String evaluation;

        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            target(model.target);
            evaluation(model.evaluation);
            causingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getEvaluation() {
            return evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation == null ? null : evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final String getCausingEntity() {
            return causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        @Override
        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
