/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the product created as the result of a request. For example, the output for a CloudFormation-backed
 * product that creates an S3 bucket would include the S3 bucket URL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordOutput implements SdkPojo, Serializable, ToCopyableBuilder<RecordOutput.Builder, RecordOutput> {
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordOutput::outputKey)).setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordOutput::outputValue)).setter(setter(Builder::outputValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecordOutput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_KEY_FIELD,
            OUTPUT_VALUE_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputKey;

    private final String outputValue;

    private final String description;

    private RecordOutput(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
    }

    /**
     * <p>
     * The output key.
     * </p>
     * 
     * @return The output key.
     */
    public String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The output value.
     * </p>
     * 
     * @return The output value.
     */
    public String outputValue() {
        return outputValue;
    }

    /**
     * <p>
     * The description of the output.
     * </p>
     * 
     * @return The description of the output.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordOutput)) {
            return false;
        }
        RecordOutput other = (RecordOutput) obj;
        return Objects.equals(outputKey(), other.outputKey()) && Objects.equals(outputValue(), other.outputValue())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecordOutput").add("OutputKey", outputKey()).add("OutputValue", outputValue())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputValue":
            return Optional.ofNullable(clazz.cast(outputValue()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordOutput, T> g) {
        return obj -> g.apply((RecordOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordOutput> {
        /**
         * <p>
         * The output key.
         * </p>
         * 
         * @param outputKey
         *        The output key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The output value.
         * </p>
         * 
         * @param outputValue
         *        The output value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputValue(String outputValue);

        /**
         * <p>
         * The description of the output.
         * </p>
         * 
         * @param description
         *        The description of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String outputKey;

        private String outputValue;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordOutput model) {
            outputKey(model.outputKey);
            outputValue(model.outputValue);
            description(model.description);
        }

        public final String getOutputKey() {
            return outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public RecordOutput build() {
            return new RecordOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
