/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedProductPlanSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedProductPlanSummary.Builder, ProvisionedProductPlanSummary> {
    private static final SdkField<String> PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::planName)).setter(setter(Builder::planName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanName").build()).build();

    private static final SdkField<String> PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::planId)).setter(setter(Builder::planId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanId").build()).build();

    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::provisionProductId)).setter(setter(Builder::provisionProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build())
            .build();

    private static final SdkField<String> PROVISION_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::provisionProductName)).setter(setter(Builder::provisionProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductName").build())
            .build();

    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::planTypeAsString)).setter(setter(Builder::planType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanType").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedProductPlanSummary::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_NAME_FIELD,
            PLAN_ID_FIELD, PROVISION_PRODUCT_ID_FIELD, PROVISION_PRODUCT_NAME_FIELD, PLAN_TYPE_FIELD,
            PROVISIONING_ARTIFACT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String planName;

    private final String planId;

    private final String provisionProductId;

    private final String provisionProductName;

    private final String planType;

    private final String provisioningArtifactId;

    private ProvisionedProductPlanSummary(BuilderImpl builder) {
        this.planName = builder.planName;
        this.planId = builder.planId;
        this.provisionProductId = builder.provisionProductId;
        this.provisionProductName = builder.provisionProductName;
        this.planType = builder.planType;
        this.provisioningArtifactId = builder.provisioningArtifactId;
    }

    /**
     * <p>
     * The name of the plan.
     * </p>
     * 
     * @return The name of the plan.
     */
    public String planName() {
        return planName;
    }

    /**
     * <p>
     * The plan identifier.
     * </p>
     * 
     * @return The plan identifier.
     */
    public String planId() {
        return planId;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public String provisionProductId() {
        return provisionProductId;
    }

    /**
     * <p>
     * The user-friendly name of the provisioned product.
     * </p>
     * 
     * @return The user-friendly name of the provisioned product.
     */
    public String provisionProductName() {
        return provisionProductName;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link ProvisionedProductPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see ProvisionedProductPlanType
     */
    public ProvisionedProductPlanType planType() {
        return ProvisionedProductPlanType.fromValue(planType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link ProvisionedProductPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see ProvisionedProductPlanType
     */
    public String planTypeAsString() {
        return planType;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(planName());
        hashCode = 31 * hashCode + Objects.hashCode(planId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionProductName());
        hashCode = 31 * hashCode + Objects.hashCode(planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedProductPlanSummary)) {
            return false;
        }
        ProvisionedProductPlanSummary other = (ProvisionedProductPlanSummary) obj;
        return Objects.equals(planName(), other.planName()) && Objects.equals(planId(), other.planId())
                && Objects.equals(provisionProductId(), other.provisionProductId())
                && Objects.equals(provisionProductName(), other.provisionProductName())
                && Objects.equals(planTypeAsString(), other.planTypeAsString())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisionedProductPlanSummary").add("PlanName", planName()).add("PlanId", planId())
                .add("ProvisionProductId", provisionProductId()).add("ProvisionProductName", provisionProductName())
                .add("PlanType", planTypeAsString()).add("ProvisioningArtifactId", provisioningArtifactId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlanName":
            return Optional.ofNullable(clazz.cast(planName()));
        case "PlanId":
            return Optional.ofNullable(clazz.cast(planId()));
        case "ProvisionProductId":
            return Optional.ofNullable(clazz.cast(provisionProductId()));
        case "ProvisionProductName":
            return Optional.ofNullable(clazz.cast(provisionProductName()));
        case "PlanType":
            return Optional.ofNullable(clazz.cast(planTypeAsString()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedProductPlanSummary, T> g) {
        return obj -> g.apply((ProvisionedProductPlanSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedProductPlanSummary> {
        /**
         * <p>
         * The name of the plan.
         * </p>
         * 
         * @param planName
         *        The name of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planName(String planName);

        /**
         * <p>
         * The plan identifier.
         * </p>
         * 
         * @param planId
         *        The plan identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planId(String planId);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param provisionProductId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductId(String provisionProductId);

        /**
         * <p>
         * The user-friendly name of the provisioned product.
         * </p>
         * 
         * @param provisionProductName
         *        The user-friendly name of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionProductName(String provisionProductName);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see ProvisionedProductPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanType
         */
        Builder planType(String planType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see ProvisionedProductPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedProductPlanType
         */
        Builder planType(ProvisionedProductPlanType planType);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);
    }

    static final class BuilderImpl implements Builder {
        private String planName;

        private String planId;

        private String provisionProductId;

        private String provisionProductName;

        private String planType;

        private String provisioningArtifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedProductPlanSummary model) {
            planName(model.planName);
            planId(model.planId);
            provisionProductId(model.provisionProductId);
            provisionProductName(model.provisionProductName);
            planType(model.planType);
            provisioningArtifactId(model.provisioningArtifactId);
        }

        public final String getPlanName() {
            return planName;
        }

        @Override
        public final Builder planName(String planName) {
            this.planName = planName;
            return this;
        }

        public final void setPlanName(String planName) {
            this.planName = planName;
        }

        public final String getPlanId() {
            return planId;
        }

        @Override
        public final Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public final void setPlanId(String planId) {
            this.planId = planId;
        }

        public final String getProvisionProductId() {
            return provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        public final String getProvisionProductName() {
            return provisionProductName;
        }

        @Override
        public final Builder provisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
            return this;
        }

        public final void setProvisionProductName(String provisionProductName) {
            this.provisionProductName = provisionProductName;
        }

        public final String getPlanType() {
            return planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(ProvisionedProductPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public ProvisionedProductPlanSummary build() {
            return new ProvisionedProductPlanSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
