/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionProductRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ProvisionProductRequest.Builder, ProvisionProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::provisioningArtifactId)).setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> PATH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::pathId)).setter(setter(Builder::pathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()).build();

    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::provisionedProductName)).setter(setter(Builder::provisionedProductName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build())
            .build();

    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField
            .<List<ProvisioningParameter>> builder(MarshallingType.LIST)
            .getter(getter(ProvisionProductRequest::provisioningParameters))
            .setter(setter(Builder::provisioningParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField
            .<ProvisioningPreferences> builder(MarshallingType.SDK_POJO)
            .getter(getter(ProvisionProductRequest::provisioningPreferences)).setter(setter(Builder::provisioningPreferences))
            .constructor(ProvisioningPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ProvisionProductRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ProvisionProductRequest::notificationArns))
            .setter(setter(Builder::notificationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVISION_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionProductRequest::provisionToken))
            .setter(setter(Builder::provisionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD,
            PROVISIONING_PARAMETERS_FIELD, PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, NOTIFICATION_ARNS_FIELD,
            PROVISION_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String productId;

    private final String provisioningArtifactId;

    private final String pathId;

    private final String provisionedProductName;

    private final List<ProvisioningParameter> provisioningParameters;

    private final ProvisioningPreferences provisioningPreferences;

    private final List<Tag> tags;

    private final List<String> notificationArns;

    private final String provisionToken;

    private ProvisionProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.notificationArns = builder.notificationArns;
        this.provisionToken = builder.provisionToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public String productId() {
        return productId;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The path identifier of the product. This value is optional if the product has a default path, and required if the
     * product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>.
     * </p>
     * 
     * @return The path identifier of the product. This value is optional if the product has a default path, and
     *         required if the product has more than one path. To list the paths for a product, use
     *         <a>ListLaunchPaths</a>.
     */
    public String pathId() {
        return pathId;
    }

    /**
     * <p>
     * A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be
     * updated after the product is provisioned.
     * </p>
     * 
     * @return A user-friendly name for the provisioned product. This value must be unique for the AWS account and
     *         cannot be updated after the product is provisioned.
     */
    public String provisionedProductName() {
        return provisionedProductName;
    }

    /**
     * Returns true if the ProvisioningParameters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProvisioningParameters() {
        return provisioningParameters != null && !(provisioningParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters specified by the administrator that are required for provisioning the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Parameters specified by the administrator that are required for provisioning the product.
     */
    public List<ProvisioningParameter> provisioningParameters() {
        return provisioningParameters;
    }

    /**
     * <p>
     * An object that contains information about the provisioning preferences for a stack set.
     * </p>
     * 
     * @return An object that contains information about the provisioning preferences for a stack set.
     */
    public ProvisioningPreferences provisioningPreferences() {
        return provisioningPreferences;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the NotificationArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNotificationArns() {
        return notificationArns != null && !(notificationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
     */
    public List<String> notificationArns() {
        return notificationArns;
    }

    /**
     * <p>
     * An idempotency token that uniquely identifies the provisioning request.
     * </p>
     * 
     * @return An idempotency token that uniquely identifies the provisioning request.
     */
    public String provisionToken() {
        return provisionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(pathId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningParameters());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(notificationArns());
        hashCode = 31 * hashCode + Objects.hashCode(provisionToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionProductRequest)) {
            return false;
        }
        ProvisionProductRequest other = (ProvisionProductRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(pathId(), other.pathId())
                && Objects.equals(provisionedProductName(), other.provisionedProductName())
                && Objects.equals(provisioningParameters(), other.provisioningParameters())
                && Objects.equals(provisioningPreferences(), other.provisioningPreferences())
                && Objects.equals(tags(), other.tags()) && Objects.equals(notificationArns(), other.notificationArns())
                && Objects.equals(provisionToken(), other.provisionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisionProductRequest").add("AcceptLanguage", acceptLanguage()).add("ProductId", productId())
                .add("ProvisioningArtifactId", provisioningArtifactId()).add("PathId", pathId())
                .add("ProvisionedProductName", provisionedProductName()).add("ProvisioningParameters", provisioningParameters())
                .add("ProvisioningPreferences", provisioningPreferences()).add("Tags", tags())
                .add("NotificationArns", notificationArns()).add("ProvisionToken", provisionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "PathId":
            return Optional.ofNullable(clazz.cast(pathId()));
        case "ProvisionedProductName":
            return Optional.ofNullable(clazz.cast(provisionedProductName()));
        case "ProvisioningParameters":
            return Optional.ofNullable(clazz.cast(provisioningParameters()));
        case "ProvisioningPreferences":
            return Optional.ofNullable(clazz.cast(provisioningPreferences()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NotificationArns":
            return Optional.ofNullable(clazz.cast(notificationArns()));
        case "ProvisionToken":
            return Optional.ofNullable(clazz.cast(provisionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionProductRequest, T> g) {
        return obj -> g.apply((ProvisionProductRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionProductRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param productId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The path identifier of the product. This value is optional if the product has a default path, and required if
         * the product has more than one path. To list the paths for a product, use <a>ListLaunchPaths</a>.
         * </p>
         * 
         * @param pathId
         *        The path identifier of the product. This value is optional if the product has a default path, and
         *        required if the product has more than one path. To list the paths for a product, use
         *        <a>ListLaunchPaths</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathId(String pathId);

        /**
         * <p>
         * A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be
         * updated after the product is provisioned.
         * </p>
         * 
         * @param provisionedProductName
         *        A user-friendly name for the provisioned product. This value must be unique for the AWS account and
         *        cannot be updated after the product is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductName(String provisionedProductName);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * 
         * @param provisioningParameters
         *        Parameters specified by the administrator that are required for provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningParameters(ProvisioningParameter... provisioningParameters);

        /**
         * <p>
         * Parameters specified by the administrator that are required for provisioning the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningParameter>.Builder} avoiding
         * the need to create one manually via {@link List<ProvisioningParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningParameter>.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningParameters(List<ProvisioningParameter>)}.
         * 
         * @param provisioningParameters
         *        a consumer that will call methods on {@link List<ProvisioningParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningParameters(List<ProvisioningParameter>)
         */
        Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * 
         * @param provisioningPreferences
         *        An object that contains information about the provisioning preferences for a stack set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences);

        /**
         * <p>
         * An object that contains information about the provisioning preferences for a stack set.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisioningPreferences.Builder} avoiding the
         * need to create one manually via {@link ProvisioningPreferences#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningPreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningPreferences(ProvisioningPreferences)}.
         * 
         * @param provisioningPreferences
         *        a consumer that will call methods on {@link ProvisioningPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningPreferences(ProvisioningPreferences)
         */
        default Builder provisioningPreferences(Consumer<ProvisioningPreferences.Builder> provisioningPreferences) {
            return provisioningPreferences(ProvisioningPreferences.builder().applyMutation(provisioningPreferences).build());
        }

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(Collection<String> notificationArns);

        /**
         * <p>
         * Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * </p>
         * 
         * @param notificationArns
         *        Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(String... notificationArns);

        /**
         * <p>
         * An idempotency token that uniquely identifies the provisioning request.
         * </p>
         * 
         * @param provisionToken
         *        An idempotency token that uniquely identifies the provisioning request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionToken(String provisionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String productId;

        private String provisioningArtifactId;

        private String pathId;

        private String provisionedProductName;

        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningPreferences provisioningPreferences;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();

        private String provisionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionProductRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
            pathId(model.pathId);
            provisionedProductName(model.provisionedProductName);
            provisioningParameters(model.provisioningParameters);
            provisioningPreferences(model.provisioningPreferences);
            tags(model.tags);
            notificationArns(model.notificationArns);
            provisionToken(model.provisionToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getProvisionedProductName() {
            return provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final Collection<ProvisioningParameter.Builder> getProvisioningParameters() {
            return provisioningParameters != null ? provisioningParameters.stream().map(ProvisioningParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter... provisioningParameters) {
            provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder>... provisioningParameters) {
            provisioningParameters(Stream.of(provisioningParameters)
                    .map(c -> ProvisioningParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final ProvisioningPreferences.Builder getProvisioningPreferences() {
            return provisioningPreferences != null ? provisioningPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final void setProvisioningPreferences(ProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getNotificationArns() {
            return notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String... notificationArns) {
            notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        public final String getProvisionToken() {
            return provisionToken;
        }

        @Override
        public final Builder provisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
            return this;
        }

        public final void setProvisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionProductRequest build() {
            return new ProvisionProductRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
