/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ProductViewFiltersCopier {
    static Map<String, List<String>> copy(Map<String, ? extends Collection<String>> productViewFiltersParam) {
        if (productViewFiltersParam == null || productViewFiltersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, List<String>> productViewFiltersParamCopy = productViewFiltersParam
                .entrySet()
                .stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), ProductViewFilterValuesCopier.copy(e.getValue())),
                        HashMap::putAll);
        return Collections.unmodifiableMap(productViewFiltersParamCopy);
    }

    static Map<String, List<String>> copyEnumToString(
            Map<ProductViewFilterBy, ? extends Collection<String>> productViewFiltersParam) {
        if (productViewFiltersParam == null || productViewFiltersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, List<String>> productViewFiltersParamCopy = productViewFiltersParam
                .entrySet()
                .stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey().toString(), ProductViewFilterValuesCopier.copy(e.getValue())),
                        HashMap::putAll);
        return Collections.unmodifiableMap(productViewFiltersParamCopy);
    }

    static Map<ProductViewFilterBy, List<String>> copyStringToEnum(
            Map<String, ? extends Collection<String>> productViewFiltersParam) {
        if (productViewFiltersParam == null || productViewFiltersParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<ProductViewFilterBy, List<String>> productViewFiltersParamCopy = productViewFiltersParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> {
                    ProductViewFilterBy keyAsEnum = ProductViewFilterBy.fromValue(e.getKey());
                    if (keyAsEnum != ProductViewFilterBy.UNKNOWN_TO_SDK_VERSION) {
                        m.put(keyAsEnum, ProductViewFilterValuesCopier.copy(e.getValue()));
                    }
                }, HashMap::putAll);
        return Collections.unmodifiableMap(productViewFiltersParamCopy);
    }
}
