/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackInstancesForProvisionedProductResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<ListStackInstancesForProvisionedProductResponse.Builder, ListStackInstancesForProvisionedProductResponse> {
    private static final SdkField<List<StackInstance>> STACK_INSTANCES_FIELD = SdkField
            .<List<StackInstance>> builder(MarshallingType.LIST)
            .getter(getter(ListStackInstancesForProvisionedProductResponse::stackInstances))
            .setter(setter(Builder::stackInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStackInstancesForProvisionedProductResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_INSTANCES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<StackInstance> stackInstances;

    private final String nextPageToken;

    private ListStackInstancesForProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.stackInstances = builder.stackInstances;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the StackInstances property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStackInstances() {
        return stackInstances != null && !(stackInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stack instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of stack instances.
     */
    public List<StackInstance> stackInstances() {
        return stackInstances;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackInstances());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstancesForProvisionedProductResponse)) {
            return false;
        }
        ListStackInstancesForProvisionedProductResponse other = (ListStackInstancesForProvisionedProductResponse) obj;
        return Objects.equals(stackInstances(), other.stackInstances()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStackInstancesForProvisionedProductResponse").add("StackInstances", stackInstances())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackInstances":
            return Optional.ofNullable(clazz.cast(stackInstances()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstancesForProvisionedProductResponse, T> g) {
        return obj -> g.apply((ListStackInstancesForProvisionedProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackInstancesForProvisionedProductResponse> {
        /**
         * <p>
         * List of stack instances.
         * </p>
         * 
         * @param stackInstances
         *        List of stack instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstances(Collection<StackInstance> stackInstances);

        /**
         * <p>
         * List of stack instances.
         * </p>
         * 
         * @param stackInstances
         *        List of stack instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstances(StackInstance... stackInstances);

        /**
         * <p>
         * List of stack instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StackInstance>.Builder} avoiding the need
         * to create one manually via {@link List<StackInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StackInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #stackInstances(List<StackInstance>)}.
         * 
         * @param stackInstances
         *        a consumer that will call methods on {@link List<StackInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackInstances(List<StackInstance>)
         */
        Builder stackInstances(Consumer<StackInstance.Builder>... stackInstances);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<StackInstance> stackInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstancesForProvisionedProductResponse model) {
            super(model);
            stackInstances(model.stackInstances);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<StackInstance.Builder> getStackInstances() {
            return stackInstances != null ? stackInstances.stream().map(StackInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stackInstances(Collection<StackInstance> stackInstances) {
            this.stackInstances = StackInstancesCopier.copy(stackInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstances(StackInstance... stackInstances) {
            stackInstances(Arrays.asList(stackInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstances(Consumer<StackInstance.Builder>... stackInstances) {
            stackInstances(Stream.of(stackInstances).map(c -> StackInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStackInstances(Collection<StackInstance.BuilderImpl> stackInstances) {
            this.stackInstances = StackInstancesCopier.copyFromBuilder(stackInstances);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListStackInstancesForProvisionedProductResponse build() {
            return new ListStackInstancesForProvisionedProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
