/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceActionsForProvisioningArtifactResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<ListServiceActionsForProvisioningArtifactResponse.Builder, ListServiceActionsForProvisioningArtifactResponse> {
    private static final SdkField<List<ServiceActionSummary>> SERVICE_ACTION_SUMMARIES_FIELD = SdkField
            .<List<ServiceActionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListServiceActionsForProvisioningArtifactResponse::serviceActionSummaries))
            .setter(setter(Builder::serviceActionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceActionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceActionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServiceActionsForProvisioningArtifactResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_ACTION_SUMMARIES_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<ServiceActionSummary> serviceActionSummaries;

    private final String nextPageToken;

    private ListServiceActionsForProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionSummaries = builder.serviceActionSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ServiceActionSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceActionSummaries() {
        return serviceActionSummaries != null && !(serviceActionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object containing information about the self-service actions associated with the provisioning artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceActionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object containing information about the self-service actions associated with the provisioning
     *         artifact.
     */
    public List<ServiceActionSummary> serviceActionSummaries() {
        return serviceActionSummaries;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceActionsForProvisioningArtifactResponse)) {
            return false;
        }
        ListServiceActionsForProvisioningArtifactResponse other = (ListServiceActionsForProvisioningArtifactResponse) obj;
        return Objects.equals(serviceActionSummaries(), other.serviceActionSummaries())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListServiceActionsForProvisioningArtifactResponse")
                .add("ServiceActionSummaries", serviceActionSummaries()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionSummaries":
            return Optional.ofNullable(clazz.cast(serviceActionSummaries()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceActionsForProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((ListServiceActionsForProvisioningArtifactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceActionsForProvisioningArtifactResponse> {
        /**
         * <p>
         * An object containing information about the self-service actions associated with the provisioning artifact.
         * </p>
         * 
         * @param serviceActionSummaries
         *        An object containing information about the self-service actions associated with the provisioning
         *        artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionSummaries(Collection<ServiceActionSummary> serviceActionSummaries);

        /**
         * <p>
         * An object containing information about the self-service actions associated with the provisioning artifact.
         * </p>
         * 
         * @param serviceActionSummaries
         *        An object containing information about the self-service actions associated with the provisioning
         *        artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionSummaries(ServiceActionSummary... serviceActionSummaries);

        /**
         * <p>
         * An object containing information about the self-service actions associated with the provisioning artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceActionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ServiceActionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceActionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceActionSummaries(List<ServiceActionSummary>)}.
         * 
         * @param serviceActionSummaries
         *        a consumer that will call methods on {@link List<ServiceActionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionSummaries(List<ServiceActionSummary>)
         */
        Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder>... serviceActionSummaries);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ServiceActionSummary> serviceActionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceActionsForProvisioningArtifactResponse model) {
            super(model);
            serviceActionSummaries(model.serviceActionSummaries);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ServiceActionSummary.Builder> getServiceActionSummaries() {
            return serviceActionSummaries != null ? serviceActionSummaries.stream().map(ServiceActionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceActionSummaries(Collection<ServiceActionSummary> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copy(serviceActionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(ServiceActionSummary... serviceActionSummaries) {
            serviceActionSummaries(Arrays.asList(serviceActionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder>... serviceActionSummaries) {
            serviceActionSummaries(Stream.of(serviceActionSummaries)
                    .map(c -> ServiceActionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceActionSummaries(Collection<ServiceActionSummary.BuilderImpl> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copyFromBuilder(serviceActionSummaries);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListServiceActionsForProvisioningArtifactResponse build() {
            return new ListServiceActionsForProvisioningArtifactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
