/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationPortfolioAccessResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListOrganizationPortfolioAccessResponse.Builder, ListOrganizationPortfolioAccessResponse> {
    private static final SdkField<List<OrganizationNode>> ORGANIZATION_NODES_FIELD = SdkField
            .<List<OrganizationNode>> builder(MarshallingType.LIST)
            .getter(getter(ListOrganizationPortfolioAccessResponse::organizationNodes))
            .setter(setter(Builder::organizationNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationPortfolioAccessResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NODES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<OrganizationNode> organizationNodes;

    private final String nextPageToken;

    private ListOrganizationPortfolioAccessResponse(BuilderImpl builder) {
        super(builder);
        this.organizationNodes = builder.organizationNodes;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the OrganizationNodes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOrganizationNodes() {
        return organizationNodes != null && !(organizationNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Displays information about the organization nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationNodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Displays information about the organization nodes.
     */
    public List<OrganizationNode> organizationNodes() {
        return organizationNodes;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationNodes());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationPortfolioAccessResponse)) {
            return false;
        }
        ListOrganizationPortfolioAccessResponse other = (ListOrganizationPortfolioAccessResponse) obj;
        return Objects.equals(organizationNodes(), other.organizationNodes())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOrganizationPortfolioAccessResponse").add("OrganizationNodes", organizationNodes())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationNodes":
            return Optional.ofNullable(clazz.cast(organizationNodes()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationPortfolioAccessResponse, T> g) {
        return obj -> g.apply((ListOrganizationPortfolioAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationPortfolioAccessResponse> {
        /**
         * <p>
         * Displays information about the organization nodes.
         * </p>
         * 
         * @param organizationNodes
         *        Displays information about the organization nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationNodes(Collection<OrganizationNode> organizationNodes);

        /**
         * <p>
         * Displays information about the organization nodes.
         * </p>
         * 
         * @param organizationNodes
         *        Displays information about the organization nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationNodes(OrganizationNode... organizationNodes);

        /**
         * <p>
         * Displays information about the organization nodes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrganizationNode>.Builder} avoiding the
         * need to create one manually via {@link List<OrganizationNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrganizationNode>.Builder#build()} is called immediately and
         * its result is passed to {@link #organizationNodes(List<OrganizationNode>)}.
         * 
         * @param organizationNodes
         *        a consumer that will call methods on {@link List<OrganizationNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationNodes(List<OrganizationNode>)
         */
        Builder organizationNodes(Consumer<OrganizationNode.Builder>... organizationNodes);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<OrganizationNode> organizationNodes = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationPortfolioAccessResponse model) {
            super(model);
            organizationNodes(model.organizationNodes);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<OrganizationNode.Builder> getOrganizationNodes() {
            return organizationNodes != null ? organizationNodes.stream().map(OrganizationNode::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationNodes(Collection<OrganizationNode> organizationNodes) {
            this.organizationNodes = OrganizationNodesCopier.copy(organizationNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationNodes(OrganizationNode... organizationNodes) {
            organizationNodes(Arrays.asList(organizationNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationNodes(Consumer<OrganizationNode.Builder>... organizationNodes) {
            organizationNodes(Stream.of(organizationNodes).map(c -> OrganizationNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationNodes(Collection<OrganizationNode.BuilderImpl> organizationNodes) {
            this.organizationNodes = OrganizationNodesCopier.copyFromBuilder(organizationNodes);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListOrganizationPortfolioAccessResponse build() {
            return new ListOrganizationPortfolioAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
