/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLaunchPathsResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListLaunchPathsResponse.Builder, ListLaunchPathsResponse> {
    private static final SdkField<List<LaunchPathSummary>> LAUNCH_PATH_SUMMARIES_FIELD = SdkField
            .<List<LaunchPathSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListLaunchPathsResponse::launchPathSummaries))
            .setter(setter(Builder::launchPathSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPathSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LaunchPathSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchPathSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLaunchPathsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PATH_SUMMARIES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<LaunchPathSummary> launchPathSummaries;

    private final String nextPageToken;

    private ListLaunchPathsResponse(BuilderImpl builder) {
        super(builder);
        this.launchPathSummaries = builder.launchPathSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the LaunchPathSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchPathSummaries() {
        return launchPathSummaries != null && !(launchPathSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the launch path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchPathSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the launch path.
     */
    public List<LaunchPathSummary> launchPathSummaries() {
        return launchPathSummaries;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchPathSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchPathsResponse)) {
            return false;
        }
        ListLaunchPathsResponse other = (ListLaunchPathsResponse) obj;
        return Objects.equals(launchPathSummaries(), other.launchPathSummaries())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLaunchPathsResponse").add("LaunchPathSummaries", launchPathSummaries())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchPathSummaries":
            return Optional.ofNullable(clazz.cast(launchPathSummaries()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchPathsResponse, T> g) {
        return obj -> g.apply((ListLaunchPathsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLaunchPathsResponse> {
        /**
         * <p>
         * Information about the launch path.
         * </p>
         * 
         * @param launchPathSummaries
         *        Information about the launch path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries);

        /**
         * <p>
         * Information about the launch path.
         * </p>
         * 
         * @param launchPathSummaries
         *        Information about the launch path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPathSummaries(LaunchPathSummary... launchPathSummaries);

        /**
         * <p>
         * Information about the launch path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchPathSummary>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchPathSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchPathSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #launchPathSummaries(List<LaunchPathSummary>)}.
         * 
         * @param launchPathSummaries
         *        a consumer that will call methods on {@link List<LaunchPathSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPathSummaries(List<LaunchPathSummary>)
         */
        Builder launchPathSummaries(Consumer<LaunchPathSummary.Builder>... launchPathSummaries);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<LaunchPathSummary> launchPathSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchPathsResponse model) {
            super(model);
            launchPathSummaries(model.launchPathSummaries);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<LaunchPathSummary.Builder> getLaunchPathSummaries() {
            return launchPathSummaries != null ? launchPathSummaries.stream().map(LaunchPathSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copy(launchPathSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(LaunchPathSummary... launchPathSummaries) {
            launchPathSummaries(Arrays.asList(launchPathSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(Consumer<LaunchPathSummary.Builder>... launchPathSummaries) {
            launchPathSummaries(Stream.of(launchPathSummaries).map(c -> LaunchPathSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchPathSummaries(Collection<LaunchPathSummary.BuilderImpl> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copyFromBuilder(launchPathSummaries);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListLaunchPathsResponse build() {
            return new ListLaunchPathsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
