/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServiceActionExecutionParametersResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<DescribeServiceActionExecutionParametersResponse.Builder, DescribeServiceActionExecutionParametersResponse> {
    private static final SdkField<List<ExecutionParameter>> SERVICE_ACTION_PARAMETERS_FIELD = SdkField
            .<List<ExecutionParameter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeServiceActionExecutionParametersResponse::serviceActionParameters))
            .setter(setter(Builder::serviceActionParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_ACTION_PARAMETERS_FIELD));

    private final List<ExecutionParameter> serviceActionParameters;

    private DescribeServiceActionExecutionParametersResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionParameters = builder.serviceActionParameters;
    }

    /**
     * Returns true if the ServiceActionParameters property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceActionParameters() {
        return serviceActionParameters != null && !(serviceActionParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters of the self-service action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceActionParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters of the self-service action.
     */
    public List<ExecutionParameter> serviceActionParameters() {
        return serviceActionParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceActionExecutionParametersResponse)) {
            return false;
        }
        DescribeServiceActionExecutionParametersResponse other = (DescribeServiceActionExecutionParametersResponse) obj;
        return Objects.equals(serviceActionParameters(), other.serviceActionParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeServiceActionExecutionParametersResponse")
                .add("ServiceActionParameters", serviceActionParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionParameters":
            return Optional.ofNullable(clazz.cast(serviceActionParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceActionExecutionParametersResponse, T> g) {
        return obj -> g.apply((DescribeServiceActionExecutionParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServiceActionExecutionParametersResponse> {
        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * 
         * @param serviceActionParameters
         *        The parameters of the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionParameters(Collection<ExecutionParameter> serviceActionParameters);

        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * 
         * @param serviceActionParameters
         *        The parameters of the self-service action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionParameters(ExecutionParameter... serviceActionParameters);

        /**
         * <p>
         * The parameters of the self-service action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExecutionParameter>.Builder} avoiding the
         * need to create one manually via {@link List<ExecutionParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceActionParameters(List<ExecutionParameter>)}.
         * 
         * @param serviceActionParameters
         *        a consumer that will call methods on {@link List<ExecutionParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionParameters(List<ExecutionParameter>)
         */
        Builder serviceActionParameters(Consumer<ExecutionParameter.Builder>... serviceActionParameters);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ExecutionParameter> serviceActionParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceActionExecutionParametersResponse model) {
            super(model);
            serviceActionParameters(model.serviceActionParameters);
        }

        public final Collection<ExecutionParameter.Builder> getServiceActionParameters() {
            return serviceActionParameters != null ? serviceActionParameters.stream().map(ExecutionParameter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceActionParameters(Collection<ExecutionParameter> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copy(serviceActionParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(ExecutionParameter... serviceActionParameters) {
            serviceActionParameters(Arrays.asList(serviceActionParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionParameters(Consumer<ExecutionParameter.Builder>... serviceActionParameters) {
            serviceActionParameters(Stream.of(serviceActionParameters)
                    .map(c -> ExecutionParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceActionParameters(Collection<ExecutionParameter.BuilderImpl> serviceActionParameters) {
            this.serviceActionParameters = ExecutionParametersCopier.copyFromBuilder(serviceActionParameters);
        }

        @Override
        public DescribeServiceActionExecutionParametersResponse build() {
            return new DescribeServiceActionExecutionParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
