/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningArtifactResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProvisioningArtifactResponse.Builder, DescribeProvisioningArtifactResponse> {
    private static final SdkField<ProvisioningArtifactDetail> PROVISIONING_ARTIFACT_DETAIL_FIELD = SdkField
            .<ProvisioningArtifactDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProvisioningArtifactResponse::provisioningArtifactDetail))
            .setter(setter(Builder::provisioningArtifactDetail))
            .constructor(ProvisioningArtifactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetail").build())
            .build();

    private static final SdkField<Map<String, String>> INFO_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeProvisioningArtifactResponse::info))
            .setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningArtifactResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_DETAIL_FIELD, INFO_FIELD, STATUS_FIELD));

    private final ProvisioningArtifactDetail provisioningArtifactDetail;

    private final Map<String, String> info;

    private final String status;

    private DescribeProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactDetail = builder.provisioningArtifactDetail;
        this.info = builder.info;
        this.status = builder.status;
    }

    /**
     * <p>
     * Information about the provisioning artifact.
     * </p>
     * 
     * @return Information about the provisioning artifact.
     */
    public ProvisioningArtifactDetail provisioningArtifactDetail() {
        return provisioningArtifactDetail;
    }

    /**
     * Returns true if the Info property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInfo() {
        return info != null && !(info instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The URL of the CloudFormation template in Amazon S3.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The URL of the CloudFormation template in Amazon S3.
     */
    public Map<String, String> info() {
        return info;
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the current request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current request.
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactDetail());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningArtifactResponse)) {
            return false;
        }
        DescribeProvisioningArtifactResponse other = (DescribeProvisioningArtifactResponse) obj;
        return Objects.equals(provisioningArtifactDetail(), other.provisioningArtifactDetail())
                && Objects.equals(info(), other.info()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProvisioningArtifactResponse")
                .add("ProvisioningArtifactDetail", provisioningArtifactDetail()).add("Info", info())
                .add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactDetail":
            return Optional.ofNullable(clazz.cast(provisioningArtifactDetail()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningArtifactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisioningArtifactResponse> {
        /**
         * <p>
         * Information about the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactDetail
         *        Information about the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail);

        /**
         * <p>
         * Information about the provisioning artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisioningArtifactDetail.Builder} avoiding the
         * need to create one manually via {@link ProvisioningArtifactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisioningArtifactDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningArtifactDetail(ProvisioningArtifactDetail)}.
         * 
         * @param provisioningArtifactDetail
         *        a consumer that will call methods on {@link ProvisioningArtifactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactDetail(ProvisioningArtifactDetail)
         */
        default Builder provisioningArtifactDetail(Consumer<ProvisioningArtifactDetail.Builder> provisioningArtifactDetail) {
            return provisioningArtifactDetail(ProvisioningArtifactDetail.builder().applyMutation(provisioningArtifactDetail)
                    .build());
        }

        /**
         * <p>
         * The URL of the CloudFormation template in Amazon S3.
         * </p>
         * 
         * @param info
         *        The URL of the CloudFormation template in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Map<String, String> info);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the current request.
         * </p>
         * 
         * @param status
         *        The status of the current request.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProvisioningArtifactDetail provisioningArtifactDetail;

        private Map<String, String> info = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningArtifactResponse model) {
            super(model);
            provisioningArtifactDetail(model.provisioningArtifactDetail);
            info(model.info);
            status(model.status);
        }

        public final ProvisioningArtifactDetail.Builder getProvisioningArtifactDetail() {
            return provisioningArtifactDetail != null ? provisioningArtifactDetail.toBuilder() : null;
        }

        @Override
        public final Builder provisioningArtifactDetail(ProvisioningArtifactDetail provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail;
            return this;
        }

        public final void setProvisioningArtifactDetail(ProvisioningArtifactDetail.BuilderImpl provisioningArtifactDetail) {
            this.provisioningArtifactDetail = provisioningArtifactDetail != null ? provisioningArtifactDetail.build() : null;
        }

        public final Map<String, String> getInfo() {
            return info;
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DescribeProvisioningArtifactResponse build() {
            return new DescribeProvisioningArtifactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
