/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisionedProductResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProvisionedProductResponse.Builder, DescribeProvisionedProductResponse> {
    private static final SdkField<ProvisionedProductDetail> PROVISIONED_PRODUCT_DETAIL_FIELD = SdkField
            .<ProvisionedProductDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProvisionedProductResponse::provisionedProductDetail))
            .setter(setter(Builder::provisionedProductDetail)).constructor(ProvisionedProductDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductDetail").build())
            .build();

    private static final SdkField<List<CloudWatchDashboard>> CLOUD_WATCH_DASHBOARDS_FIELD = SdkField
            .<List<CloudWatchDashboard>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProvisionedProductResponse::cloudWatchDashboards))
            .setter(setter(Builder::cloudWatchDashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchDashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchDashboard> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchDashboard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONED_PRODUCT_DETAIL_FIELD, CLOUD_WATCH_DASHBOARDS_FIELD));

    private final ProvisionedProductDetail provisionedProductDetail;

    private final List<CloudWatchDashboard> cloudWatchDashboards;

    private DescribeProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductDetail = builder.provisionedProductDetail;
        this.cloudWatchDashboards = builder.cloudWatchDashboards;
    }

    /**
     * <p>
     * Information about the provisioned product.
     * </p>
     * 
     * @return Information about the provisioned product.
     */
    public ProvisionedProductDetail provisionedProductDetail() {
        return provisionedProductDetail;
    }

    /**
     * Returns true if the CloudWatchDashboards property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCloudWatchDashboards() {
        return cloudWatchDashboards != null && !(cloudWatchDashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any CloudWatch dashboards that were created when provisioning the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCloudWatchDashboards()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any CloudWatch dashboards that were created when provisioning the product.
     */
    public List<CloudWatchDashboard> cloudWatchDashboards() {
        return cloudWatchDashboards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductDetail());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchDashboards());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisionedProductResponse)) {
            return false;
        }
        DescribeProvisionedProductResponse other = (DescribeProvisionedProductResponse) obj;
        return Objects.equals(provisionedProductDetail(), other.provisionedProductDetail())
                && Objects.equals(cloudWatchDashboards(), other.cloudWatchDashboards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProvisionedProductResponse").add("ProvisionedProductDetail", provisionedProductDetail())
                .add("CloudWatchDashboards", cloudWatchDashboards()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedProductDetail":
            return Optional.ofNullable(clazz.cast(provisionedProductDetail()));
        case "CloudWatchDashboards":
            return Optional.ofNullable(clazz.cast(cloudWatchDashboards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisionedProductResponse, T> g) {
        return obj -> g.apply((DescribeProvisionedProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProvisionedProductResponse> {
        /**
         * <p>
         * Information about the provisioned product.
         * </p>
         * 
         * @param provisionedProductDetail
         *        Information about the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductDetail(ProvisionedProductDetail provisionedProductDetail);

        /**
         * <p>
         * Information about the provisioned product.
         * </p>
         * This is a convenience that creates an instance of the {@link ProvisionedProductDetail.Builder} avoiding the
         * need to create one manually via {@link ProvisionedProductDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedProductDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedProductDetail(ProvisionedProductDetail)}.
         * 
         * @param provisionedProductDetail
         *        a consumer that will call methods on {@link ProvisionedProductDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedProductDetail(ProvisionedProductDetail)
         */
        default Builder provisionedProductDetail(Consumer<ProvisionedProductDetail.Builder> provisionedProductDetail) {
            return provisionedProductDetail(ProvisionedProductDetail.builder().applyMutation(provisionedProductDetail).build());
        }

        /**
         * <p>
         * Any CloudWatch dashboards that were created when provisioning the product.
         * </p>
         * 
         * @param cloudWatchDashboards
         *        Any CloudWatch dashboards that were created when provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchDashboards(Collection<CloudWatchDashboard> cloudWatchDashboards);

        /**
         * <p>
         * Any CloudWatch dashboards that were created when provisioning the product.
         * </p>
         * 
         * @param cloudWatchDashboards
         *        Any CloudWatch dashboards that were created when provisioning the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchDashboards(CloudWatchDashboard... cloudWatchDashboards);

        /**
         * <p>
         * Any CloudWatch dashboards that were created when provisioning the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchDashboard>.Builder} avoiding the
         * need to create one manually via {@link List<CloudWatchDashboard>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchDashboard>.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchDashboards(List<CloudWatchDashboard>)}.
         * 
         * @param cloudWatchDashboards
         *        a consumer that will call methods on {@link List<CloudWatchDashboard>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchDashboards(List<CloudWatchDashboard>)
         */
        Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder>... cloudWatchDashboards);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProvisionedProductDetail provisionedProductDetail;

        private List<CloudWatchDashboard> cloudWatchDashboards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisionedProductResponse model) {
            super(model);
            provisionedProductDetail(model.provisionedProductDetail);
            cloudWatchDashboards(model.cloudWatchDashboards);
        }

        public final ProvisionedProductDetail.Builder getProvisionedProductDetail() {
            return provisionedProductDetail != null ? provisionedProductDetail.toBuilder() : null;
        }

        @Override
        public final Builder provisionedProductDetail(ProvisionedProductDetail provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail;
            return this;
        }

        public final void setProvisionedProductDetail(ProvisionedProductDetail.BuilderImpl provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail != null ? provisionedProductDetail.build() : null;
        }

        public final Collection<CloudWatchDashboard.Builder> getCloudWatchDashboards() {
            return cloudWatchDashboards != null ? cloudWatchDashboards.stream().map(CloudWatchDashboard::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchDashboards(Collection<CloudWatchDashboard> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copy(cloudWatchDashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(CloudWatchDashboard... cloudWatchDashboards) {
            cloudWatchDashboards(Arrays.asList(cloudWatchDashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder>... cloudWatchDashboards) {
            cloudWatchDashboards(Stream.of(cloudWatchDashboards).map(c -> CloudWatchDashboard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchDashboards(Collection<CloudWatchDashboard.BuilderImpl> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copyFromBuilder(cloudWatchDashboards);
        }

        @Override
        public DescribeProvisionedProductResponse build() {
            return new DescribeProvisionedProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
