/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProductResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProductResponse.Builder, DescribeProductResponse> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField
            .<ProductViewSummary> builder(MarshallingType.SDK_POJO).getter(getter(DescribeProductResponse::productViewSummary))
            .setter(setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build())
            .build();

    private static final SdkField<List<ProvisioningArtifact>> PROVISIONING_ARTIFACTS_FIELD = SdkField
            .<List<ProvisioningArtifact>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductResponse::provisioningArtifacts))
            .setter(setter(Builder::provisioningArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField
            .<List<BudgetDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductResponse::budgets))
            .setter(setter(Builder::budgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD,
            PROVISIONING_ARTIFACTS_FIELD, BUDGETS_FIELD));

    private final ProductViewSummary productViewSummary;

    private final List<ProvisioningArtifact> provisioningArtifacts;

    private final List<BudgetDetail> budgets;

    private DescribeProductResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
        this.budgets = builder.budgets;
    }

    /**
     * <p>
     * Summary information about the product view.
     * </p>
     * 
     * @return Summary information about the product view.
     */
    public ProductViewSummary productViewSummary() {
        return productViewSummary;
    }

    /**
     * Returns true if the ProvisioningArtifacts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProvisioningArtifacts() {
        return provisioningArtifacts != null && !(provisioningArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioning artifacts for the specified product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the provisioning artifacts for the specified product.
     */
    public List<ProvisioningArtifact> provisioningArtifacts() {
        return provisioningArtifacts;
    }

    /**
     * Returns true if the Budgets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBudgets() {
        return budgets != null && !(budgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associated budgets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBudgets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associated budgets.
     */
    public List<BudgetDetail> budgets() {
        return budgets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(budgets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductResponse)) {
            return false;
        }
        DescribeProductResponse other = (DescribeProductResponse) obj;
        return Objects.equals(productViewSummary(), other.productViewSummary())
                && Objects.equals(provisioningArtifacts(), other.provisioningArtifacts())
                && Objects.equals(budgets(), other.budgets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProductResponse").add("ProductViewSummary", productViewSummary())
                .add("ProvisioningArtifacts", provisioningArtifacts()).add("Budgets", budgets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewSummary":
            return Optional.ofNullable(clazz.cast(productViewSummary()));
        case "ProvisioningArtifacts":
            return Optional.ofNullable(clazz.cast(provisioningArtifacts()));
        case "Budgets":
            return Optional.ofNullable(clazz.cast(budgets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductResponse, T> g) {
        return obj -> g.apply((DescribeProductResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProductResponse> {
        /**
         * <p>
         * Summary information about the product view.
         * </p>
         * 
         * @param productViewSummary
         *        Summary information about the product view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummary(ProductViewSummary productViewSummary);

        /**
         * <p>
         * Summary information about the product view.
         * </p>
         * This is a convenience that creates an instance of the {@link ProductViewSummary.Builder} avoiding the need to
         * create one manually via {@link ProductViewSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductViewSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewSummary(ProductViewSummary)}.
         * 
         * @param productViewSummary
         *        a consumer that will call methods on {@link ProductViewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewSummary(ProductViewSummary)
         */
        default Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return productViewSummary(ProductViewSummary.builder().applyMutation(productViewSummary).build());
        }

        /**
         * <p>
         * Information about the provisioning artifacts for the specified product.
         * </p>
         * 
         * @param provisioningArtifacts
         *        Information about the provisioning artifacts for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts);

        /**
         * <p>
         * Information about the provisioning artifacts for the specified product.
         * </p>
         * 
         * @param provisioningArtifacts
         *        Information about the provisioning artifacts for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifacts(ProvisioningArtifact... provisioningArtifacts);

        /**
         * <p>
         * Information about the provisioning artifacts for the specified product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningArtifact>.Builder} avoiding the
         * need to create one manually via {@link List<ProvisioningArtifact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifact>.Builder#build()} is called immediately
         * and its result is passed to {@link #provisioningArtifacts(List<ProvisioningArtifact>)}.
         * 
         * @param provisioningArtifacts
         *        a consumer that will call methods on {@link List<ProvisioningArtifact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifacts(List<ProvisioningArtifact>)
         */
        Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder>... provisioningArtifacts);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Collection<BudgetDetail> budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(BudgetDetail... budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BudgetDetail>.Builder} avoiding the need to
         * create one manually via {@link List<BudgetDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BudgetDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #budgets(List<BudgetDetail>)}.
         * 
         * @param budgets
         *        a consumer that will call methods on {@link List<BudgetDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgets(List<BudgetDetail>)
         */
        Builder budgets(Consumer<BudgetDetail.Builder>... budgets);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProductViewSummary productViewSummary;

        private List<ProvisioningArtifact> provisioningArtifacts = DefaultSdkAutoConstructList.getInstance();

        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductResponse model) {
            super(model);
            productViewSummary(model.productViewSummary);
            provisioningArtifacts(model.provisioningArtifacts);
            budgets(model.budgets);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return productViewSummary != null ? productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final Collection<ProvisioningArtifact.Builder> getProvisioningArtifacts() {
            return provisioningArtifacts != null ? provisioningArtifacts.stream().map(ProvisioningArtifact::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact... provisioningArtifacts) {
            provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder>... provisioningArtifacts) {
            provisioningArtifacts(Stream.of(provisioningArtifacts)
                    .map(c -> ProvisioningArtifact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact.BuilderImpl> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copyFromBuilder(provisioningArtifacts);
        }

        public final Collection<BudgetDetail.Builder> getBudgets() {
            return budgets != null ? budgets.stream().map(BudgetDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail... budgets) {
            budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder>... budgets) {
            budgets(Stream.of(budgets).map(c -> BudgetDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public DescribeProductResponse build() {
            return new DescribeProductResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
