/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceActionRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<CreateServiceActionRequest.Builder, CreateServiceActionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceActionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DEFINITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceActionRequest::definitionTypeAsString)).setter(setter(Builder::definitionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionType").build()).build();

    private static final SdkField<Map<String, String>> DEFINITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateServiceActionRequest::definitionAsStrings))
            .setter(setter(Builder::definitionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceActionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceActionRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServiceActionRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DEFINITION_TYPE_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, ACCEPT_LANGUAGE_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String name;

    private final String definitionType;

    private final Map<String, String> definition;

    private final String description;

    private final String acceptLanguage;

    private final String idempotencyToken;

    private CreateServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.definitionType = builder.definitionType;
        this.definition = builder.definition;
        this.description = builder.description;
        this.acceptLanguage = builder.acceptLanguage;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The self-service action name.
     * </p>
     * 
     * @return The self-service action name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #definitionType}
     * will return {@link ServiceActionDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #definitionTypeAsString}.
     * </p>
     * 
     * @return The service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * @see ServiceActionDefinitionType
     */
    public ServiceActionDefinitionType definitionType() {
        return ServiceActionDefinitionType.fromValue(definitionType);
    }

    /**
     * <p>
     * The service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #definitionType}
     * will return {@link ServiceActionDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #definitionTypeAsString}.
     * </p>
     * 
     * @return The service action definition type. For example, <code>SSM_AUTOMATION</code>.
     * @see ServiceActionDefinitionType
     */
    public String definitionTypeAsString() {
        return definitionType;
    }

    /**
     * <p>
     * The self-service action definition. Can be one of the following:
     * </p>
     * <dl>
     * <dt>Name</dt>
     * <dd>
     * <p>
     * The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
     * </p>
     * </dd>
     * <dt>Version</dt>
     * <dd>
     * <p>
     * The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
     * </p>
     * </dd>
     * <dt>AssumeRole</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example,
     * <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
     * </p>
     * <p>
     * To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
     * </p>
     * </dd>
     * <dt>Parameters</dt>
     * <dd>
     * <p>
     * The list of parameters in JSON format.
     * </p>
     * <p>
     * For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
     * <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The self-service action definition. Can be one of the following:</p>
     *         <dl>
     *         <dt>Name</dt>
     *         <dd>
     *         <p>
     *         The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
     *         </p>
     *         </dd>
     *         <dt>Version</dt>
     *         <dd>
     *         <p>
     *         The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
     *         </p>
     *         </dd>
     *         <dt>AssumeRole</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
     *         example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
     *         </p>
     *         <p>
     *         To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
     *         </p>
     *         </dd>
     *         <dt>Parameters</dt>
     *         <dd>
     *         <p>
     *         The list of parameters in JSON format.
     *         </p>
     *         <p>
     *         For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
     *         <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
     *         </p>
     *         </dd>
     */
    public Map<ServiceActionDefinitionKey, String> definition() {
        return ServiceActionDefinitionMapCopier.copyStringToEnum(definition);
    }

    /**
     * Returns true if the Definition property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDefinition() {
        return definition != null && !(definition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The self-service action definition. Can be one of the following:
     * </p>
     * <dl>
     * <dt>Name</dt>
     * <dd>
     * <p>
     * The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
     * </p>
     * </dd>
     * <dt>Version</dt>
     * <dd>
     * <p>
     * The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
     * </p>
     * </dd>
     * <dt>AssumeRole</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example,
     * <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
     * </p>
     * <p>
     * To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
     * </p>
     * </dd>
     * <dt>Parameters</dt>
     * <dd>
     * <p>
     * The list of parameters in JSON format.
     * </p>
     * <p>
     * For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
     * <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDefinition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The self-service action definition. Can be one of the following:</p>
     *         <dl>
     *         <dt>Name</dt>
     *         <dd>
     *         <p>
     *         The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
     *         </p>
     *         </dd>
     *         <dt>Version</dt>
     *         <dd>
     *         <p>
     *         The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
     *         </p>
     *         </dd>
     *         <dt>AssumeRole</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
     *         example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
     *         </p>
     *         <p>
     *         To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
     *         </p>
     *         </dd>
     *         <dt>Parameters</dt>
     *         <dd>
     *         <p>
     *         The list of parameters in JSON format.
     *         </p>
     *         <p>
     *         For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
     *         <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
     *         </p>
     *         </dd>
     */
    public Map<String, String> definitionAsStrings() {
        return definition;
    }

    /**
     * <p>
     * The self-service action description.
     * </p>
     * 
     * @return The self-service action description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency
     * token, the same response is returned for each repeated request.
     * </p>
     * 
     * @return A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
     *         idempotency token, the same response is returned for each repeated request.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definitionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definitionAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceActionRequest)) {
            return false;
        }
        CreateServiceActionRequest other = (CreateServiceActionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(definitionTypeAsString(), other.definitionTypeAsString())
                && Objects.equals(definitionAsStrings(), other.definitionAsStrings())
                && Objects.equals(description(), other.description()) && Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateServiceActionRequest").add("Name", name()).add("DefinitionType", definitionTypeAsString())
                .add("Definition", definitionAsStrings()).add("Description", description())
                .add("AcceptLanguage", acceptLanguage()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefinitionType":
            return Optional.ofNullable(clazz.cast(definitionTypeAsString()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definitionAsStrings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceActionRequest, T> g) {
        return obj -> g.apply((CreateServiceActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceActionRequest> {
        /**
         * <p>
         * The self-service action name.
         * </p>
         * 
         * @param name
         *        The self-service action name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * </p>
         * 
         * @param definitionType
         *        The service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * @see ServiceActionDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionDefinitionType
         */
        Builder definitionType(String definitionType);

        /**
         * <p>
         * The service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * </p>
         * 
         * @param definitionType
         *        The service action definition type. For example, <code>SSM_AUTOMATION</code>.
         * @see ServiceActionDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceActionDefinitionType
         */
        Builder definitionType(ServiceActionDefinitionType definitionType);

        /**
         * <p>
         * The self-service action definition. Can be one of the following:
         * </p>
         * <dl>
         * <dt>Name</dt>
         * <dd>
         * <p>
         * The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
         * </p>
         * </dd>
         * <dt>Version</dt>
         * <dd>
         * <p>
         * The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
         * </p>
         * </dd>
         * <dt>AssumeRole</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
         * example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
         * </p>
         * <p>
         * To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
         * </p>
         * </dd>
         * <dt>Parameters</dt>
         * <dd>
         * <p>
         * The list of parameters in JSON format.
         * </p>
         * <p>
         * For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
         * <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param definition
         *        The self-service action definition. Can be one of the following:</p>
         *        <dl>
         *        <dt>Name</dt>
         *        <dd>
         *        <p>
         *        The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
         *        </p>
         *        </dd>
         *        <dt>Version</dt>
         *        <dd>
         *        <p>
         *        The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
         *        </p>
         *        </dd>
         *        <dt>AssumeRole</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
         *        example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
         *        </p>
         *        <p>
         *        To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
         *        </p>
         *        </dd>
         *        <dt>Parameters</dt>
         *        <dd>
         *        <p>
         *        The list of parameters in JSON format.
         *        </p>
         *        <p>
         *        For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
         *        <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionWithStrings(Map<String, String> definition);

        /**
         * <p>
         * The self-service action definition. Can be one of the following:
         * </p>
         * <dl>
         * <dt>Name</dt>
         * <dd>
         * <p>
         * The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
         * </p>
         * </dd>
         * <dt>Version</dt>
         * <dd>
         * <p>
         * The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
         * </p>
         * </dd>
         * <dt>AssumeRole</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
         * example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
         * </p>
         * <p>
         * To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
         * </p>
         * </dd>
         * <dt>Parameters</dt>
         * <dd>
         * <p>
         * The list of parameters in JSON format.
         * </p>
         * <p>
         * For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
         * <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param definition
         *        The self-service action definition. Can be one of the following:</p>
         *        <dl>
         *        <dt>Name</dt>
         *        <dd>
         *        <p>
         *        The name of the AWS Systems Manager Document. For example, <code>AWS-RestartEC2Instance</code>.
         *        </p>
         *        </dd>
         *        <dt>Version</dt>
         *        <dd>
         *        <p>
         *        The AWS Systems Manager automation document version. For example, <code>"Version": "1"</code>
         *        </p>
         *        </dd>
         *        <dt>AssumeRole</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For
         *        example, <code>"AssumeRole": "arn:aws:iam::12345678910:role/ActionRole"</code>.
         *        </p>
         *        <p>
         *        To reuse the provisioned product launch role, set to <code>"AssumeRole": "LAUNCH_ROLE"</code>.
         *        </p>
         *        </dd>
         *        <dt>Parameters</dt>
         *        <dd>
         *        <p>
         *        The list of parameters in JSON format.
         *        </p>
         *        <p>
         *        For example: <code>[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]</code> or
         *        <code>[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]</code>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Map<ServiceActionDefinitionKey, String> definition);

        /**
         * <p>
         * The self-service action description.
         * </p>
         * 
         * @param description
         *        The self-service action description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         * idempotency token, the same response is returned for each repeated request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the
         *        idempotency token, the same response is returned for each repeated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String name;

        private String definitionType;

        private Map<String, String> definition = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private String acceptLanguage;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceActionRequest model) {
            super(model);
            name(model.name);
            definitionType(model.definitionType);
            definitionWithStrings(model.definition);
            description(model.description);
            acceptLanguage(model.acceptLanguage);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefinitionType() {
            return definitionType;
        }

        @Override
        public final Builder definitionType(String definitionType) {
            this.definitionType = definitionType;
            return this;
        }

        @Override
        public final Builder definitionType(ServiceActionDefinitionType definitionType) {
            this.definitionType(definitionType == null ? null : definitionType.toString());
            return this;
        }

        public final void setDefinitionType(String definitionType) {
            this.definitionType = definitionType;
        }

        public final Map<String, String> getDefinition() {
            return definition;
        }

        @Override
        public final Builder definitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
            return this;
        }

        @Override
        public final Builder definition(Map<ServiceActionDefinitionKey, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copyEnumToString(definition);
            return this;
        }

        public final void setDefinition(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceActionRequest build() {
            return new CreateServiceActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
