/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortfolioShareResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<CreatePortfolioShareResponse.Builder, CreatePortfolioShareResponse> {
    private static final SdkField<String> PORTFOLIO_SHARE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePortfolioShareResponse::portfolioShareToken)).setter(setter(Builder::portfolioShareToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioShareToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTFOLIO_SHARE_TOKEN_FIELD));

    private final String portfolioShareToken;

    private CreatePortfolioShareResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioShareToken = builder.portfolioShareToken;
    }

    /**
     * <p>
     * The portfolio share unique identifier. This will only be returned if portfolio is shared to an organization node.
     * </p>
     * 
     * @return The portfolio share unique identifier. This will only be returned if portfolio is shared to an
     *         organization node.
     */
    public String portfolioShareToken() {
        return portfolioShareToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portfolioShareToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortfolioShareResponse)) {
            return false;
        }
        CreatePortfolioShareResponse other = (CreatePortfolioShareResponse) obj;
        return Objects.equals(portfolioShareToken(), other.portfolioShareToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePortfolioShareResponse").add("PortfolioShareToken", portfolioShareToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PortfolioShareToken":
            return Optional.ofNullable(clazz.cast(portfolioShareToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortfolioShareResponse, T> g) {
        return obj -> g.apply((CreatePortfolioShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePortfolioShareResponse> {
        /**
         * <p>
         * The portfolio share unique identifier. This will only be returned if portfolio is shared to an organization
         * node.
         * </p>
         * 
         * @param portfolioShareToken
         *        The portfolio share unique identifier. This will only be returned if portfolio is shared to an
         *        organization node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioShareToken(String portfolioShareToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private String portfolioShareToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortfolioShareResponse model) {
            super(model);
            portfolioShareToken(model.portfolioShareToken);
        }

        public final String getPortfolioShareToken() {
            return portfolioShareToken;
        }

        @Override
        public final Builder portfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
            return this;
        }

        public final void setPortfolioShareToken(String portfolioShareToken) {
            this.portfolioShareToken = portfolioShareToken;
        }

        @Override
        public CreatePortfolioShareResponse build() {
            return new CreatePortfolioShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
