/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateServiceActionWithProvisioningArtifactRequest extends ServiceCatalogRequest
        implements
        ToCopyableBuilder<BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder, BatchAssociateServiceActionWithProvisioningArtifactRequest> {
    private static final SdkField<List<ServiceActionAssociation>> SERVICE_ACTION_ASSOCIATIONS_FIELD = SdkField
            .<List<ServiceActionAssociation>> builder(MarshallingType.LIST)
            .getter(getter(BatchAssociateServiceActionWithProvisioningArtifactRequest::serviceActionAssociations))
            .setter(setter(Builder::serviceActionAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceActionAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceActionAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchAssociateServiceActionWithProvisioningArtifactRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_ACTION_ASSOCIATIONS_FIELD, ACCEPT_LANGUAGE_FIELD));

    private final List<ServiceActionAssociation> serviceActionAssociations;

    private final String acceptLanguage;

    private BatchAssociateServiceActionWithProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.serviceActionAssociations = builder.serviceActionAssociations;
        this.acceptLanguage = builder.acceptLanguage;
    }

    /**
     * Returns true if the ServiceActionAssociations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServiceActionAssociations() {
        return serviceActionAssociations != null && !(serviceActionAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceActionAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact
     *         ID.
     */
    public List<ServiceActionAssociation> serviceActionAssociations() {
        return serviceActionAssociations;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceActionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateServiceActionWithProvisioningArtifactRequest)) {
            return false;
        }
        BatchAssociateServiceActionWithProvisioningArtifactRequest other = (BatchAssociateServiceActionWithProvisioningArtifactRequest) obj;
        return Objects.equals(serviceActionAssociations(), other.serviceActionAssociations())
                && Objects.equals(acceptLanguage(), other.acceptLanguage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchAssociateServiceActionWithProvisioningArtifactRequest")
                .add("ServiceActionAssociations", serviceActionAssociations()).add("AcceptLanguage", acceptLanguage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceActionAssociations":
            return Optional.ofNullable(clazz.cast(serviceActionAssociations()));
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateServiceActionWithProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((BatchAssociateServiceActionWithProvisioningArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateServiceActionWithProvisioningArtifactRequest> {
        /**
         * <p>
         * One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
         * </p>
         * 
         * @param serviceActionAssociations
         *        One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning
         *        Artifact ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionAssociations(Collection<ServiceActionAssociation> serviceActionAssociations);

        /**
         * <p>
         * One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
         * </p>
         * 
         * @param serviceActionAssociations
         *        One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning
         *        Artifact ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceActionAssociations(ServiceActionAssociation... serviceActionAssociations);

        /**
         * <p>
         * One or more associations, each consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceActionAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<ServiceActionAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceActionAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceActionAssociations(List<ServiceActionAssociation>)}.
         * 
         * @param serviceActionAssociations
         *        a consumer that will call methods on {@link List<ServiceActionAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceActionAssociations(List<ServiceActionAssociation>)
         */
        Builder serviceActionAssociations(Consumer<ServiceActionAssociation.Builder>... serviceActionAssociations);

        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private List<ServiceActionAssociation> serviceActionAssociations = DefaultSdkAutoConstructList.getInstance();

        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateServiceActionWithProvisioningArtifactRequest model) {
            super(model);
            serviceActionAssociations(model.serviceActionAssociations);
            acceptLanguage(model.acceptLanguage);
        }

        public final Collection<ServiceActionAssociation.Builder> getServiceActionAssociations() {
            return serviceActionAssociations != null ? serviceActionAssociations.stream()
                    .map(ServiceActionAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceActionAssociations(Collection<ServiceActionAssociation> serviceActionAssociations) {
            this.serviceActionAssociations = ServiceActionAssociationsCopier.copy(serviceActionAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionAssociations(ServiceActionAssociation... serviceActionAssociations) {
            serviceActionAssociations(Arrays.asList(serviceActionAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionAssociations(Consumer<ServiceActionAssociation.Builder>... serviceActionAssociations) {
            serviceActionAssociations(Stream.of(serviceActionAssociations)
                    .map(c -> ServiceActionAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceActionAssociations(Collection<ServiceActionAssociation.BuilderImpl> serviceActionAssociations) {
            this.serviceActionAssociations = ServiceActionAssociationsCopier.copyFromBuilder(serviceActionAssociations);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateServiceActionWithProvisioningArtifactRequest build() {
            return new BatchAssociateServiceActionWithProvisioningArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
