/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordOutput> {
    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecordOutput.getter(RecordOutput::outputKey)).setter(RecordOutput.setter(Builder::outputKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()}).build();
    private static final SdkField<String> OUTPUT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecordOutput.getter(RecordOutput::outputValue)).setter(RecordOutput.setter(Builder::outputValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecordOutput.getter(RecordOutput::description)).setter(RecordOutput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_KEY_FIELD, OUTPUT_VALUE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputKey;
    private final String outputValue;
    private final String description;

    private RecordOutput(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
    }

    public String outputKey() {
        return this.outputKey;
    }

    public String outputValue() {
        return this.outputValue;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordOutput)) {
            return false;
        }
        RecordOutput other = (RecordOutput)obj;
        return Objects.equals(this.outputKey(), other.outputKey()) && Objects.equals(this.outputValue(), other.outputValue()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"RecordOutput").add("OutputKey", (Object)this.outputKey()).add("OutputValue", (Object)this.outputValue()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputKey": {
                return Optional.ofNullable(clazz.cast(this.outputKey()));
            }
            case "OutputValue": {
                return Optional.ofNullable(clazz.cast(this.outputValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordOutput, T> g) {
        return obj -> g.apply((RecordOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputKey;
        private String outputValue;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordOutput model) {
            this.outputKey(model.outputKey);
            this.outputValue(model.outputValue);
            this.description(model.description);
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return this.outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public RecordOutput build() {
            return new RecordOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordOutput> {
        public Builder outputKey(String var1);

        public Builder outputValue(String var1);

        public Builder description(String var1);
    }
}

