/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisioningArtifactRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateProvisioningArtifactRequest.Builder, UpdateProvisioningArtifactRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::provisioningArtifactId))
            .setter(setter(Builder::provisioningArtifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateProvisioningArtifactRequest::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<String> GUIDANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisioningArtifactRequest::guidanceAsString)).setter(setter(Builder::guidance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Guidance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ACTIVE_FIELD, GUIDANCE_FIELD));

    private final String acceptLanguage;

    private final String productId;

    private final String provisioningArtifactId;

    private final String name;

    private final String description;

    private final Boolean active;

    private final String guidance;

    private UpdateProvisioningArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.name = builder.name;
        this.description = builder.description;
        this.active = builder.active;
        this.guidance = builder.guidance;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The product identifier.
     * </p>
     * 
     * @return The product identifier.
     */
    public String productId() {
        return productId;
    }

    /**
     * <p>
     * The identifier of the provisioning artifact.
     * </p>
     * 
     * @return The identifier of the provisioning artifact.
     */
    public String provisioningArtifactId() {
        return provisioningArtifactId;
    }

    /**
     * <p>
     * The updated name of the provisioning artifact.
     * </p>
     * 
     * @return The updated name of the provisioning artifact.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The updated description of the provisioning artifact.
     * </p>
     * 
     * @return The updated description of the provisioning artifact.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the product version is active.
     * </p>
     * 
     * @return Indicates whether the product version is active.
     */
    public Boolean active() {
        return active;
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * The <code>DEFAULT</code> value indicates that the product version is active.
     * </p>
     * <p>
     * The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is
     * deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new
     * provisioned products using a deprecated version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.</p>
     *         <p>
     *         The <code>DEFAULT</code> value indicates that the product version is active.
     *         </p>
     *         <p>
     *         The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product
     *         version is deprecated. Users are able to make updates to a provisioned product of a deprecated version
     *         but cannot launch new provisioned products using a deprecated version.
     * @see ProvisioningArtifactGuidance
     */
    public ProvisioningArtifactGuidance guidance() {
        return ProvisioningArtifactGuidance.fromValue(guidance);
    }

    /**
     * <p>
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     * </p>
     * <p>
     * The <code>DEFAULT</code> value indicates that the product version is active.
     * </p>
     * <p>
     * The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is
     * deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new
     * provisioned products using a deprecated version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #guidance} will
     * return {@link ProvisioningArtifactGuidance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #guidanceAsString}.
     * </p>
     * 
     * @return Information set by the administrator to provide guidance to end users about which provisioning artifacts
     *         to use.</p>
     *         <p>
     *         The <code>DEFAULT</code> value indicates that the product version is active.
     *         </p>
     *         <p>
     *         The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product
     *         version is deprecated. Users are able to make updates to a provisioned product of a deprecated version
     *         but cannot launch new provisioned products using a deprecated version.
     * @see ProvisioningArtifactGuidance
     */
    public String guidanceAsString() {
        return guidance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(guidanceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningArtifactRequest)) {
            return false;
        }
        UpdateProvisioningArtifactRequest other = (UpdateProvisioningArtifactRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(productId(), other.productId())
                && Objects.equals(provisioningArtifactId(), other.provisioningArtifactId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(active(), other.active()) && Objects.equals(guidanceAsString(), other.guidanceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProvisioningArtifactRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProductId", productId()).add("ProvisioningArtifactId", provisioningArtifactId()).add("Name", name())
                .add("Description", description()).add("Active", active()).add("Guidance", guidanceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProvisioningArtifactId":
            return Optional.ofNullable(clazz.cast(provisioningArtifactId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "Guidance":
            return Optional.ofNullable(clazz.cast(guidanceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisioningArtifactRequest, T> g) {
        return obj -> g.apply((UpdateProvisioningArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProvisioningArtifactRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The product identifier.
         * </p>
         * 
         * @param productId
         *        The product identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The identifier of the provisioning artifact.
         * </p>
         * 
         * @param provisioningArtifactId
         *        The identifier of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactId(String provisioningArtifactId);

        /**
         * <p>
         * The updated name of the provisioning artifact.
         * </p>
         * 
         * @param name
         *        The updated name of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description of the provisioning artifact.
         * </p>
         * 
         * @param description
         *        The updated description of the provisioning artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the product version is active.
         * </p>
         * 
         * @param active
         *        Indicates whether the product version is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * <p>
         * The <code>DEFAULT</code> value indicates that the product version is active.
         * </p>
         * <p>
         * The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is
         * deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch
         * new provisioned products using a deprecated version.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.</p>
         *        <p>
         *        The <code>DEFAULT</code> value indicates that the product version is active.
         *        </p>
         *        <p>
         *        The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product
         *        version is deprecated. Users are able to make updates to a provisioned product of a deprecated version
         *        but cannot launch new provisioned products using a deprecated version.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(String guidance);

        /**
         * <p>
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to
         * use.
         * </p>
         * <p>
         * The <code>DEFAULT</code> value indicates that the product version is active.
         * </p>
         * <p>
         * The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product version is
         * deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch
         * new provisioned products using a deprecated version.
         * </p>
         * 
         * @param guidance
         *        Information set by the administrator to provide guidance to end users about which provisioning
         *        artifacts to use.</p>
         *        <p>
         *        The <code>DEFAULT</code> value indicates that the product version is active.
         *        </p>
         *        <p>
         *        The administrator can set the guidance to <code>DEPRECATED</code> to inform users that the product
         *        version is deprecated. Users are able to make updates to a provisioned product of a deprecated version
         *        but cannot launch new provisioned products using a deprecated version.
         * @see ProvisioningArtifactGuidance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactGuidance
         */
        Builder guidance(ProvisioningArtifactGuidance guidance);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String productId;

        private String provisioningArtifactId;

        private String name;

        private String description;

        private Boolean active;

        private String guidance;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningArtifactRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            productId(model.productId);
            provisioningArtifactId(model.provisioningArtifactId);
            name(model.name);
            description(model.description);
            active(model.active);
            guidance(model.guidance);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getActive() {
            return active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getGuidanceAsString() {
            return guidance;
        }

        @Override
        public final Builder guidance(String guidance) {
            this.guidance = guidance;
            return this;
        }

        @Override
        public final Builder guidance(ProvisioningArtifactGuidance guidance) {
            this.guidance(guidance == null ? null : guidance.toString());
            return this;
        }

        public final void setGuidance(String guidance) {
            this.guidance = guidance;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisioningArtifactRequest build() {
            return new UpdateProvisioningArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
