/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProvisionedProductPropertiesRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<UpdateProvisionedProductPropertiesRequest.Builder, UpdateProvisionedProductPropertiesRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisionedProductPropertiesRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisionedProductPropertiesRequest::provisionedProductId))
            .setter(setter(Builder::provisionedProductId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build())
            .build();

    private static final SdkField<Map<String, String>> PROVISIONED_PRODUCT_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateProvisionedProductPropertiesRequest::provisionedProductPropertiesAsStrings))
            .setter(setter(Builder::provisionedProductPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductProperties")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateProvisionedProductPropertiesRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PROVISIONED_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_PROPERTIES_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String acceptLanguage;

    private final String provisionedProductId;

    private final Map<String, String> provisionedProductProperties;

    private final String idempotencyToken;

    private UpdateProvisionedProductPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductProperties = builder.provisionedProductProperties;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The identifier of the provisioned product.
     * </p>
     * 
     * @return The identifier of the provisioned product.
     */
    public String provisionedProductId() {
        return provisionedProductId;
    }

    /**
     * <p>
     * A map that contains the provisioned product properties to be updated.
     * </p>
     * <p>
     * The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
     * terminate, and execute service actions in the provisioned product.
     * </p>
     * <p>
     * The administrator can change the owner of a provisioned product to another IAM user within the same account. Both
     * end user owners and administrators can see ownership history of the provisioned product using the
     * <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using
     * the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can
     * still see the product's history from when he was an owner using <code>ListRecordHistory</code>.
     * </p>
     * <p>
     * If a provisioned product ownership is assigned to an end user, they can see and perform any action through the
     * API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions
     * a product and the owner is updated to someone else, they will no longer be able to see or perform any actions
     * through API or the Service Catalog console on that provisioned product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisionedProductProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains the provisioned product properties to be updated.</p>
     *         <p>
     *         The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
     *         terminate, and execute service actions in the provisioned product.
     *         </p>
     *         <p>
     *         The administrator can change the owner of a provisioned product to another IAM user within the same
     *         account. Both end user owners and administrators can see ownership history of the provisioned product
     *         using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the
     *         provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use
     *         <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using
     *         <code>ListRecordHistory</code>.
     *         </p>
     *         <p>
     *         If a provisioned product ownership is assigned to an end user, they can see and perform any action
     *         through the API or Service Catalog console such as update, terminate, and execute service actions. If an
     *         end user provisions a product and the owner is updated to someone else, they will no longer be able to
     *         see or perform any actions through API or the Service Catalog console on that provisioned product.
     */
    public Map<PropertyKey, String> provisionedProductProperties() {
        return ProvisionedProductPropertiesCopier.copyStringToEnum(provisionedProductProperties);
    }

    /**
     * Returns true if the ProvisionedProductProperties property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasProvisionedProductProperties() {
        return provisionedProductProperties != null && !(provisionedProductProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains the provisioned product properties to be updated.
     * </p>
     * <p>
     * The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
     * terminate, and execute service actions in the provisioned product.
     * </p>
     * <p>
     * The administrator can change the owner of a provisioned product to another IAM user within the same account. Both
     * end user owners and administrators can see ownership history of the provisioned product using the
     * <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product using
     * the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>, but can
     * still see the product's history from when he was an owner using <code>ListRecordHistory</code>.
     * </p>
     * <p>
     * If a provisioned product ownership is assigned to an end user, they can see and perform any action through the
     * API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions
     * a product and the owner is updated to someone else, they will no longer be able to see or perform any actions
     * through API or the Service Catalog console on that provisioned product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisionedProductProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains the provisioned product properties to be updated.</p>
     *         <p>
     *         The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
     *         terminate, and execute service actions in the provisioned product.
     *         </p>
     *         <p>
     *         The administrator can change the owner of a provisioned product to another IAM user within the same
     *         account. Both end user owners and administrators can see ownership history of the provisioned product
     *         using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the
     *         provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use
     *         <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using
     *         <code>ListRecordHistory</code>.
     *         </p>
     *         <p>
     *         If a provisioned product ownership is assigned to an end user, they can see and perform any action
     *         through the API or Service Catalog console such as update, terminate, and execute service actions. If an
     *         end user provisions a product and the owner is updated to someone else, they will no longer be able to
     *         see or perform any actions through API or the Service Catalog console on that provisioned product.
     */
    public Map<String, String> provisionedProductPropertiesAsStrings() {
        return provisionedProductProperties;
    }

    /**
     * <p>
     * The idempotency token that uniquely identifies the provisioning product update request.
     * </p>
     * 
     * @return The idempotency token that uniquely identifies the provisioning product update request.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedProductPropertiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductPropertiesRequest)) {
            return false;
        }
        UpdateProvisionedProductPropertiesRequest other = (UpdateProvisionedProductPropertiesRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage())
                && Objects.equals(provisionedProductId(), other.provisionedProductId())
                && Objects.equals(provisionedProductPropertiesAsStrings(), other.provisionedProductPropertiesAsStrings())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateProvisionedProductPropertiesRequest").add("AcceptLanguage", acceptLanguage())
                .add("ProvisionedProductId", provisionedProductId())
                .add("ProvisionedProductProperties", provisionedProductPropertiesAsStrings())
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "ProvisionedProductId":
            return Optional.ofNullable(clazz.cast(provisionedProductId()));
        case "ProvisionedProductProperties":
            return Optional.ofNullable(clazz.cast(provisionedProductPropertiesAsStrings()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductPropertiesRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedProductPropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateProvisionedProductPropertiesRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The identifier of the provisioned product.
         * </p>
         * 
         * @param provisionedProductId
         *        The identifier of the provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductId(String provisionedProductId);

        /**
         * <p>
         * A map that contains the provisioned product properties to be updated.
         * </p>
         * <p>
         * The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
         * terminate, and execute service actions in the provisioned product.
         * </p>
         * <p>
         * The administrator can change the owner of a provisioned product to another IAM user within the same account.
         * Both end user owners and administrators can see ownership history of the provisioned product using the
         * <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product
         * using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>,
         * but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.
         * </p>
         * <p>
         * If a provisioned product ownership is assigned to an end user, they can see and perform any action through
         * the API or Service Catalog console such as update, terminate, and execute service actions. If an end user
         * provisions a product and the owner is updated to someone else, they will no longer be able to see or perform
         * any actions through API or the Service Catalog console on that provisioned product.
         * </p>
         * 
         * @param provisionedProductProperties
         *        A map that contains the provisioned product properties to be updated.</p>
         *        <p>
         *        The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see,
         *        update, terminate, and execute service actions in the provisioned product.
         *        </p>
         *        <p>
         *        The administrator can change the owner of a provisioned product to another IAM user within the same
         *        account. Both end user owners and administrators can see ownership history of the provisioned product
         *        using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the
         *        provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use
         *        <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using
         *        <code>ListRecordHistory</code>.
         *        </p>
         *        <p>
         *        If a provisioned product ownership is assigned to an end user, they can see and perform any action
         *        through the API or Service Catalog console such as update, terminate, and execute service actions. If
         *        an end user provisions a product and the owner is updated to someone else, they will no longer be able
         *        to see or perform any actions through API or the Service Catalog console on that provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties);

        /**
         * <p>
         * A map that contains the provisioned product properties to be updated.
         * </p>
         * <p>
         * The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see, update,
         * terminate, and execute service actions in the provisioned product.
         * </p>
         * <p>
         * The administrator can change the owner of a provisioned product to another IAM user within the same account.
         * Both end user owners and administrators can see ownership history of the provisioned product using the
         * <code>ListRecordHistory</code> API. The new owner can describe all past records for the provisioned product
         * using the <code>DescribeRecord</code> API. The previous owner can no longer use <code>DescribeRecord</code>,
         * but can still see the product's history from when he was an owner using <code>ListRecordHistory</code>.
         * </p>
         * <p>
         * If a provisioned product ownership is assigned to an end user, they can see and perform any action through
         * the API or Service Catalog console such as update, terminate, and execute service actions. If an end user
         * provisions a product and the owner is updated to someone else, they will no longer be able to see or perform
         * any actions through API or the Service Catalog console on that provisioned product.
         * </p>
         * 
         * @param provisionedProductProperties
         *        A map that contains the provisioned product properties to be updated.</p>
         *        <p>
         *        The <code>OWNER</code> key only accepts user ARNs. The owner is the user that is allowed to see,
         *        update, terminate, and execute service actions in the provisioned product.
         *        </p>
         *        <p>
         *        The administrator can change the owner of a provisioned product to another IAM user within the same
         *        account. Both end user owners and administrators can see ownership history of the provisioned product
         *        using the <code>ListRecordHistory</code> API. The new owner can describe all past records for the
         *        provisioned product using the <code>DescribeRecord</code> API. The previous owner can no longer use
         *        <code>DescribeRecord</code>, but can still see the product's history from when he was an owner using
         *        <code>ListRecordHistory</code>.
         *        </p>
         *        <p>
         *        If a provisioned product ownership is assigned to an end user, they can see and perform any action
         *        through the API or Service Catalog console such as update, terminate, and execute service actions. If
         *        an end user provisions a product and the owner is updated to someone else, they will no longer be able
         *        to see or perform any actions through API or the Service Catalog console on that provisioned product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties);

        /**
         * <p>
         * The idempotency token that uniquely identifies the provisioning product update request.
         * </p>
         * 
         * @param idempotencyToken
         *        The idempotency token that uniquely identifies the provisioning product update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String provisionedProductId;

        private Map<String, String> provisionedProductProperties = DefaultSdkAutoConstructMap.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductPropertiesRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            provisionedProductId(model.provisionedProductId);
            provisionedProductPropertiesWithStrings(model.provisionedProductProperties);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductId() {
            return provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final Map<String, String> getProvisionedProductPropertiesAsStrings() {
            return provisionedProductProperties;
        }

        @Override
        public final Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
            return this;
        }

        @Override
        public final Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copyEnumToString(provisionedProductProperties);
            return this;
        }

        public final void setProvisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedProductPropertiesRequest build() {
            return new UpdateProvisionedProductPropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
