/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchProductsAsAdminResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<SearchProductsAsAdminResponse.Builder, SearchProductsAsAdminResponse> {
    private static final SdkField<List<ProductViewDetail>> PRODUCT_VIEW_DETAILS_FIELD = SdkField
            .<List<ProductViewDetail>> builder(MarshallingType.LIST)
            .getter(getter(SearchProductsAsAdminResponse::productViewDetails))
            .setter(setter(Builder::productViewDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductViewDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductViewDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchProductsAsAdminResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAILS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<ProductViewDetail> productViewDetails;

    private final String nextPageToken;

    private SearchProductsAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetails = builder.productViewDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ProductViewDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProductViewDetails() {
        return productViewDetails != null && !(productViewDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the product views.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductViewDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the product views.
     */
    public List<ProductViewDetail> productViewDetails() {
        return productViewDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productViewDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminResponse)) {
            return false;
        }
        SearchProductsAsAdminResponse other = (SearchProductsAsAdminResponse) obj;
        return Objects.equals(productViewDetails(), other.productViewDetails())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchProductsAsAdminResponse").add("ProductViewDetails", productViewDetails())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewDetails":
            return Optional.ofNullable(clazz.cast(productViewDetails()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsAsAdminResponse, T> g) {
        return obj -> g.apply((SearchProductsAsAdminResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchProductsAsAdminResponse> {
        /**
         * <p>
         * Information about the product views.
         * </p>
         * 
         * @param productViewDetails
         *        Information about the product views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewDetails(Collection<ProductViewDetail> productViewDetails);

        /**
         * <p>
         * Information about the product views.
         * </p>
         * 
         * @param productViewDetails
         *        Information about the product views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewDetails(ProductViewDetail... productViewDetails);

        /**
         * <p>
         * Information about the product views.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductViewDetail>.Builder} avoiding the
         * need to create one manually via {@link List<ProductViewDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductViewDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #productViewDetails(List<ProductViewDetail>)}.
         * 
         * @param productViewDetails
         *        a consumer that will call methods on {@link List<ProductViewDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewDetails(List<ProductViewDetail>)
         */
        Builder productViewDetails(Consumer<ProductViewDetail.Builder>... productViewDetails);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProductViewDetail> productViewDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminResponse model) {
            super(model);
            productViewDetails(model.productViewDetails);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewDetail.Builder> getProductViewDetails() {
            return productViewDetails != null ? productViewDetails.stream().map(ProductViewDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewDetails(Collection<ProductViewDetail> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copy(productViewDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(ProductViewDetail... productViewDetails) {
            productViewDetails(Arrays.asList(productViewDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewDetails(Consumer<ProductViewDetail.Builder>... productViewDetails) {
            productViewDetails(Stream.of(productViewDetails).map(c -> ProductViewDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductViewDetails(Collection<ProductViewDetail.BuilderImpl> productViewDetails) {
            this.productViewDetails = ProductViewDetailsCopier.copyFromBuilder(productViewDetails);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsAsAdminResponse build() {
            return new SearchProductsAsAdminResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
