/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a provisioning artifact (also known as a version) for a product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningArtifactProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningArtifactProperties.Builder, ProvisioningArtifactProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisioningArtifactProperties::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisioningArtifactProperties::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> INFO_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ProvisioningArtifactProperties::info))
            .setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisioningArtifactProperties::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> DISABLE_TEMPLATE_VALIDATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(ProvisioningArtifactProperties::disableTemplateValidation))
            .setter(setter(Builder::disableTemplateValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableTemplateValidation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            INFO_FIELD, TYPE_FIELD, DISABLE_TEMPLATE_VALIDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final Map<String, String> info;

    private final String type;

    private final Boolean disableTemplateValidation;

    private ProvisioningArtifactProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.info = builder.info;
        this.type = builder.type;
        this.disableTemplateValidation = builder.disableTemplateValidation;
    }

    /**
     * <p>
     * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
     * </p>
     * 
     * @return The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
     * </p>
     * 
     * @return The description of the provisioning artifact, including how it differs from the previous provisioning
     *         artifact.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Info property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInfo() {
        return info != null && !(info instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:
     * </p>
     * <p>
     * <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:</p>
     *         <p>
     *         <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
     */
    public Map<String, String> info() {
        return info;
    }

    /**
     * <p>
     * The type of provisioning artifact.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProvisioningArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of provisioning artifact.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
     *         </p>
     *         </li>
     * @see ProvisioningArtifactType
     */
    public ProvisioningArtifactType type() {
        return ProvisioningArtifactType.fromValue(type);
    }

    /**
     * <p>
     * The type of provisioning artifact.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProvisioningArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of provisioning artifact.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
     *         </p>
     *         </li>
     * @see ProvisioningArtifactType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is invalid.
     * </p>
     * 
     * @return If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is
     *         invalid.
     */
    public Boolean disableTemplateValidation() {
        return disableTemplateValidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disableTemplateValidation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactProperties)) {
            return false;
        }
        ProvisioningArtifactProperties other = (ProvisioningArtifactProperties) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(info(), other.info()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(disableTemplateValidation(), other.disableTemplateValidation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisioningArtifactProperties").add("Name", name()).add("Description", description())
                .add("Info", info()).add("Type", typeAsString()).add("DisableTemplateValidation", disableTemplateValidation())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DisableTemplateValidation":
            return Optional.ofNullable(clazz.cast(disableTemplateValidation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningArtifactProperties, T> g) {
        return obj -> g.apply((ProvisioningArtifactProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningArtifactProperties> {
        /**
         * <p>
         * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
         * </p>
         * 
         * @param name
         *        The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the provisioning artifact, including how it differs from the previous provisioning
         * artifact.
         * </p>
         * 
         * @param description
         *        The description of the provisioning artifact, including how it differs from the previous provisioning
         *        artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:
         * </p>
         * <p>
         * <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
         * </p>
         * 
         * @param info
         *        The URL of the CloudFormation template in Amazon S3. Specify the URL in JSON format as follows:</p>
         *        <p>
         *        <code>"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Map<String, String> info);

        /**
         * <p>
         * The type of provisioning artifact.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of provisioning artifact.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
         *        </p>
         *        </li>
         * @see ProvisioningArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of provisioning artifact.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of provisioning artifact.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLOUD_FORMATION_TEMPLATE</code> - AWS CloudFormation template
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE_AMI</code> - AWS Marketplace AMI
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MARKETPLACE_CAR</code> - AWS Marketplace Clusters and AWS Resources
         *        </p>
         *        </li>
         * @see ProvisioningArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningArtifactType
         */
        Builder type(ProvisioningArtifactType type);

        /**
         * <p>
         * If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is
         * invalid.
         * </p>
         * 
         * @param disableTemplateValidation
         *        If set to true, AWS Service Catalog stops validating the specified provisioning artifact even if it is
         *        invalid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableTemplateValidation(Boolean disableTemplateValidation);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private Map<String, String> info = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private Boolean disableTemplateValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactProperties model) {
            name(model.name);
            description(model.description);
            info(model.info);
            type(model.type);
            disableTemplateValidation(model.disableTemplateValidation);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getInfo() {
            return info;
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Boolean getDisableTemplateValidation() {
            return disableTemplateValidation;
        }

        @Override
        public final Builder disableTemplateValidation(Boolean disableTemplateValidation) {
            this.disableTemplateValidation = disableTemplateValidation;
            return this;
        }

        public final void setDisableTemplateValidation(Boolean disableTemplateValidation) {
            this.disableTemplateValidation = disableTemplateValidation;
        }

        @Override
        public ProvisioningArtifactProperties build() {
            return new ProvisioningArtifactProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
