/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a product view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductViewDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductViewDetail.Builder, ProductViewDetail> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField
            .<ProductViewSummary> builder(MarshallingType.SDK_POJO).getter(getter(ProductViewDetail::productViewSummary))
            .setter(setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductViewDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProductViewDetail::productARN)).setter(setter(Builder::productARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductARN").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProductViewDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD,
            STATUS_FIELD, PRODUCT_ARN_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProductViewSummary productViewSummary;

    private final String status;

    private final String productARN;

    private final Instant createdTime;

    private ProductViewDetail(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.status = builder.status;
        this.productARN = builder.productARN;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * Summary information about the product view.
     * </p>
     * 
     * @return Summary information about the product view.
     */
    public ProductViewSummary productViewSummary() {
        return productViewSummary;
    }

    /**
     * <p>
     * The status of the product.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The product is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Product creation has started; the product is not ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - An action failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the product.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The product is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Product creation has started; the product is not ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - An action failed.
     *         </p>
     *         </li>
     * @see Status
     */
    public Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the product.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The product is ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code> - Product creation has started; the product is not ready for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - An action failed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the product.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The product is ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - Product creation has started; the product is not ready for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - An action failed.
     *         </p>
     *         </li>
     * @see Status
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ARN of the product.
     * </p>
     * 
     * @return The ARN of the product.
     */
    public String productARN() {
        return productARN;
    }

    /**
     * <p>
     * The UTC time stamp of the creation time.
     * </p>
     * 
     * @return The UTC time stamp of the creation time.
     */
    public Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productARN());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewDetail)) {
            return false;
        }
        ProductViewDetail other = (ProductViewDetail) obj;
        return Objects.equals(productViewSummary(), other.productViewSummary())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(productARN(), other.productARN())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProductViewDetail").add("ProductViewSummary", productViewSummary())
                .add("Status", statusAsString()).add("ProductARN", productARN()).add("CreatedTime", createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewSummary":
            return Optional.ofNullable(clazz.cast(productViewSummary()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ProductARN":
            return Optional.ofNullable(clazz.cast(productARN()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductViewDetail, T> g) {
        return obj -> g.apply((ProductViewDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductViewDetail> {
        /**
         * <p>
         * Summary information about the product view.
         * </p>
         * 
         * @param productViewSummary
         *        Summary information about the product view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewSummary(ProductViewSummary productViewSummary);

        /**
         * <p>
         * Summary information about the product view.
         * </p>
         * This is a convenience that creates an instance of the {@link ProductViewSummary.Builder} avoiding the need to
         * create one manually via {@link ProductViewSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductViewSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewSummary(ProductViewSummary)}.
         * 
         * @param productViewSummary
         *        a consumer that will call methods on {@link ProductViewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewSummary(ProductViewSummary)
         */
        default Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return productViewSummary(ProductViewSummary.builder().applyMutation(productViewSummary).build());
        }

        /**
         * <p>
         * The status of the product.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The product is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Product creation has started; the product is not ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - An action failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the product.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The product is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Product creation has started; the product is not ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - An action failed.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the product.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The product is ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code> - Product creation has started; the product is not ready for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - An action failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the product.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The product is ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - Product creation has started; the product is not ready for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - An action failed.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The ARN of the product.
         * </p>
         * 
         * @param productARN
         *        The ARN of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productARN(String productARN);

        /**
         * <p>
         * The UTC time stamp of the creation time.
         * </p>
         * 
         * @param createdTime
         *        The UTC time stamp of the creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private ProductViewSummary productViewSummary;

        private String status;

        private String productARN;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewDetail model) {
            productViewSummary(model.productViewSummary);
            status(model.status);
            productARN(model.productARN);
            createdTime(model.createdTime);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return productViewSummary != null ? productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getProductARN() {
            return productARN;
        }

        @Override
        public final Builder productARN(String productARN) {
            this.productARN = productARN;
            return this;
        }

        public final void setProductARN(String productARN) {
            this.productARN = productARN;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public ProductViewDetail build() {
            return new ProductViewDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
