/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisioningArtifactsResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<ListProvisioningArtifactsResponse.Builder, ListProvisioningArtifactsResponse> {
    private static final SdkField<List<ProvisioningArtifactDetail>> PROVISIONING_ARTIFACT_DETAILS_FIELD = SdkField
            .<List<ProvisioningArtifactDetail>> builder(MarshallingType.LIST)
            .getter(getter(ListProvisioningArtifactsResponse::provisioningArtifactDetails))
            .setter(setter(Builder::provisioningArtifactDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProvisioningArtifactsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_DETAILS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<ProvisioningArtifactDetail> provisioningArtifactDetails;

    private final String nextPageToken;

    private ListProvisioningArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactDetails = builder.provisioningArtifactDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ProvisioningArtifactDetails property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasProvisioningArtifactDetails() {
        return provisioningArtifactDetails != null && !(provisioningArtifactDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioning artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningArtifactDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the provisioning artifacts.
     */
    public List<ProvisioningArtifactDetail> provisioningArtifactDetails() {
        return provisioningArtifactDetails;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsResponse)) {
            return false;
        }
        ListProvisioningArtifactsResponse other = (ListProvisioningArtifactsResponse) obj;
        return Objects.equals(provisioningArtifactDetails(), other.provisioningArtifactDetails())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProvisioningArtifactsResponse")
                .add("ProvisioningArtifactDetails", provisioningArtifactDetails()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactDetails":
            return Optional.ofNullable(clazz.cast(provisioningArtifactDetails()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningArtifactsResponse, T> g) {
        return obj -> g.apply((ListProvisioningArtifactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisioningArtifactsResponse> {
        /**
         * <p>
         * Information about the provisioning artifacts.
         * </p>
         * 
         * @param provisioningArtifactDetails
         *        Information about the provisioning artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> provisioningArtifactDetails);

        /**
         * <p>
         * Information about the provisioning artifacts.
         * </p>
         * 
         * @param provisioningArtifactDetails
         *        Information about the provisioning artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactDetails(ProvisioningArtifactDetail... provisioningArtifactDetails);

        /**
         * <p>
         * Information about the provisioning artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningArtifactDetail>.Builder}
         * avoiding the need to create one manually via {@link List<ProvisioningArtifactDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifactDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #provisioningArtifactDetails(List<ProvisioningArtifactDetail>)}.
         * 
         * @param provisioningArtifactDetails
         *        a consumer that will call methods on {@link List<ProvisioningArtifactDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactDetails(List<ProvisioningArtifactDetail>)
         */
        Builder provisioningArtifactDetails(Consumer<ProvisioningArtifactDetail.Builder>... provisioningArtifactDetails);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisioningArtifactDetail> provisioningArtifactDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsResponse model) {
            super(model);
            provisioningArtifactDetails(model.provisioningArtifactDetails);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisioningArtifactDetail.Builder> getProvisioningArtifactDetails() {
            return provisioningArtifactDetails != null ? provisioningArtifactDetails.stream()
                    .map(ProvisioningArtifactDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactDetails(Collection<ProvisioningArtifactDetail> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copy(provisioningArtifactDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactDetails(ProvisioningArtifactDetail... provisioningArtifactDetails) {
            provisioningArtifactDetails(Arrays.asList(provisioningArtifactDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactDetails(
                Consumer<ProvisioningArtifactDetail.Builder>... provisioningArtifactDetails) {
            provisioningArtifactDetails(Stream.of(provisioningArtifactDetails)
                    .map(c -> ProvisioningArtifactDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactDetails(
                Collection<ProvisioningArtifactDetail.BuilderImpl> provisioningArtifactDetails) {
            this.provisioningArtifactDetails = ProvisioningArtifactDetailsCopier.copyFromBuilder(provisioningArtifactDetails);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisioningArtifactsResponse build() {
            return new ListProvisioningArtifactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
