/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProvisioningArtifactsForServiceActionResponse extends ServiceCatalogResponse
        implements
        ToCopyableBuilder<ListProvisioningArtifactsForServiceActionResponse.Builder, ListProvisioningArtifactsForServiceActionResponse> {
    private static final SdkField<List<ProvisioningArtifactView>> PROVISIONING_ARTIFACT_VIEWS_FIELD = SdkField
            .<List<ProvisioningArtifactView>> builder(MarshallingType.LIST)
            .getter(getter(ListProvisioningArtifactsForServiceActionResponse::provisioningArtifactViews))
            .setter(setter(Builder::provisioningArtifactViews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactViews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactView> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactView::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProvisioningArtifactsForServiceActionResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROVISIONING_ARTIFACT_VIEWS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<ProvisioningArtifactView> provisioningArtifactViews;

    private final String nextPageToken;

    private ListProvisioningArtifactsForServiceActionResponse(BuilderImpl builder) {
        super(builder);
        this.provisioningArtifactViews = builder.provisioningArtifactViews;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the ProvisioningArtifactViews property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProvisioningArtifactViews() {
        return provisioningArtifactViews != null && !(provisioningArtifactViews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects with information about product views and provisioning artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningArtifactViews()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects with information about product views and provisioning artifacts.
     */
    public List<ProvisioningArtifactView> provisioningArtifactViews() {
        return provisioningArtifactViews;
    }

    /**
     * <p>
     * The page token to use to retrieve the next set of results. If there are no additional results, this value is
     * null.
     * </p>
     * 
     * @return The page token to use to retrieve the next set of results. If there are no additional results, this value
     *         is null.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactViews());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisioningArtifactsForServiceActionResponse)) {
            return false;
        }
        ListProvisioningArtifactsForServiceActionResponse other = (ListProvisioningArtifactsForServiceActionResponse) obj;
        return Objects.equals(provisioningArtifactViews(), other.provisioningArtifactViews())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProvisioningArtifactsForServiceActionResponse")
                .add("ProvisioningArtifactViews", provisioningArtifactViews()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisioningArtifactViews":
            return Optional.ofNullable(clazz.cast(provisioningArtifactViews()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisioningArtifactsForServiceActionResponse, T> g) {
        return obj -> g.apply((ListProvisioningArtifactsForServiceActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProvisioningArtifactsForServiceActionResponse> {
        /**
         * <p>
         * An array of objects with information about product views and provisioning artifacts.
         * </p>
         * 
         * @param provisioningArtifactViews
         *        An array of objects with information about product views and provisioning artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactViews(Collection<ProvisioningArtifactView> provisioningArtifactViews);

        /**
         * <p>
         * An array of objects with information about product views and provisioning artifacts.
         * </p>
         * 
         * @param provisioningArtifactViews
         *        An array of objects with information about product views and provisioning artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactViews(ProvisioningArtifactView... provisioningArtifactViews);

        /**
         * <p>
         * An array of objects with information about product views and provisioning artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningArtifactView>.Builder} avoiding
         * the need to create one manually via {@link List<ProvisioningArtifactView>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifactView>.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningArtifactViews(List<ProvisioningArtifactView>)}.
         * 
         * @param provisioningArtifactViews
         *        a consumer that will call methods on {@link List<ProvisioningArtifactView>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactViews(List<ProvisioningArtifactView>)
         */
        Builder provisioningArtifactViews(Consumer<ProvisioningArtifactView.Builder>... provisioningArtifactViews);

        /**
         * <p>
         * The page token to use to retrieve the next set of results. If there are no additional results, this value is
         * null.
         * </p>
         * 
         * @param nextPageToken
         *        The page token to use to retrieve the next set of results. If there are no additional results, this
         *        value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private List<ProvisioningArtifactView> provisioningArtifactViews = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisioningArtifactsForServiceActionResponse model) {
            super(model);
            provisioningArtifactViews(model.provisioningArtifactViews);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisioningArtifactView.Builder> getProvisioningArtifactViews() {
            return provisioningArtifactViews != null ? provisioningArtifactViews.stream()
                    .map(ProvisioningArtifactView::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactViews(Collection<ProvisioningArtifactView> provisioningArtifactViews) {
            this.provisioningArtifactViews = ProvisioningArtifactViewsCopier.copy(provisioningArtifactViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactViews(ProvisioningArtifactView... provisioningArtifactViews) {
            provisioningArtifactViews(Arrays.asList(provisioningArtifactViews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactViews(Consumer<ProvisioningArtifactView.Builder>... provisioningArtifactViews) {
            provisioningArtifactViews(Stream.of(provisioningArtifactViews)
                    .map(c -> ProvisioningArtifactView.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactViews(Collection<ProvisioningArtifactView.BuilderImpl> provisioningArtifactViews) {
            this.provisioningArtifactViews = ProvisioningArtifactViewsCopier.copyFromBuilder(provisioningArtifactViews);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisioningArtifactsForServiceActionResponse build() {
            return new ListProvisioningArtifactsForServiceActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
