/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationPortfolioAccessRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<ListOrganizationPortfolioAccessRequest.Builder, ListOrganizationPortfolioAccessRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationPortfolioAccessRequest::acceptLanguage)).setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationPortfolioAccessRequest::portfolioId)).setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> ORGANIZATION_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationPortfolioAccessRequest::organizationNodeTypeAsString))
            .setter(setter(Builder::organizationNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNodeType").build())
            .build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOrganizationPortfolioAccessRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListOrganizationPortfolioAccessRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, ORGANIZATION_NODE_TYPE_FIELD, PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private final String acceptLanguage;

    private final String portfolioId;

    private final String organizationNodeType;

    private final String pageToken;

    private final Integer pageSize;

    private ListOrganizationPortfolioAccessRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.organizationNodeType = builder.organizationNodeType;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code> - English (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code> - English (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.
     * </p>
     * 
     * @return The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.
     */
    public String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The organization node type that will be returned in the output.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORGANIZATION</code> - Organization that has access to the portfolio.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationNodeType} will return {@link OrganizationNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #organizationNodeTypeAsString}.
     * </p>
     * 
     * @return The organization node type that will be returned in the output.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORGANIZATION</code> - Organization that has access to the portfolio.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
     *         </p>
     *         </li>
     * @see OrganizationNodeType
     */
    public OrganizationNodeType organizationNodeType() {
        return OrganizationNodeType.fromValue(organizationNodeType);
    }

    /**
     * <p>
     * The organization node type that will be returned in the output.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ORGANIZATION</code> - Organization that has access to the portfolio.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your organization.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationNodeType} will return {@link OrganizationNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #organizationNodeTypeAsString}.
     * </p>
     * 
     * @return The organization node type that will be returned in the output.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ORGANIZATION</code> - Organization that has access to the portfolio.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
     *         organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
     *         </p>
     *         </li>
     * @see OrganizationNodeType
     */
    public String organizationNodeTypeAsString() {
        return organizationNodeType;
    }

    /**
     * <p>
     * The page token for the next set of results. To retrieve the first set of results, use null.
     * </p>
     * 
     * @return The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationNodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationPortfolioAccessRequest)) {
            return false;
        }
        ListOrganizationPortfolioAccessRequest other = (ListOrganizationPortfolioAccessRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(organizationNodeTypeAsString(), other.organizationNodeTypeAsString())
                && Objects.equals(pageToken(), other.pageToken()) && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOrganizationPortfolioAccessRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("OrganizationNodeType", organizationNodeTypeAsString())
                .add("PageToken", pageToken()).add("PageSize", pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "OrganizationNodeType":
            return Optional.ofNullable(clazz.cast(organizationNodeTypeAsString()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationPortfolioAccessRequest, T> g) {
        return obj -> g.apply((ListOrganizationPortfolioAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationPortfolioAccessRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code> - English (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code> - English (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier. For example, <code>port-2abcdext3y5fk</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The organization node type that will be returned in the output.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORGANIZATION</code> - Organization that has access to the portfolio.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
         * organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationNodeType
         *        The organization node type that will be returned in the output.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORGANIZATION</code> - Organization that has access to the portfolio.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
         *        organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
         *        </p>
         *        </li>
         * @see OrganizationNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationNodeType
         */
        Builder organizationNodeType(String organizationNodeType);

        /**
         * <p>
         * The organization node type that will be returned in the output.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ORGANIZATION</code> - Organization that has access to the portfolio.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
         * organization.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param organizationNodeType
         *        The organization node type that will be returned in the output.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ORGANIZATION</code> - Organization that has access to the portfolio.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ORGANIZATIONAL_UNIT</code> - Organizational unit that has access to the portfolio within your
         *        organization.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT</code> - Account that has access to the portfolio within your organization.
         *        </p>
         *        </li>
         * @see OrganizationNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationNodeType
         */
        Builder organizationNodeType(OrganizationNodeType organizationNodeType);

        /**
         * <p>
         * The page token for the next set of results. To retrieve the first set of results, use null.
         * </p>
         * 
         * @param pageToken
         *        The page token for the next set of results. To retrieve the first set of results, use null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String organizationNodeType;

        private String pageToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationPortfolioAccessRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            organizationNodeType(model.organizationNodeType);
            pageToken(model.pageToken);
            pageSize(model.pageSize);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getOrganizationNodeTypeAsString() {
            return organizationNodeType;
        }

        @Override
        public final Builder organizationNodeType(String organizationNodeType) {
            this.organizationNodeType = organizationNodeType;
            return this;
        }

        @Override
        public final Builder organizationNodeType(OrganizationNodeType organizationNodeType) {
            this.organizationNodeType(organizationNodeType == null ? null : organizationNodeType.toString());
            return this;
        }

        public final void setOrganizationNodeType(String organizationNodeType) {
            this.organizationNodeType = organizationNodeType;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOrganizationPortfolioAccessRequest build() {
            return new ListOrganizationPortfolioAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
