/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProductAsAdminResponse extends ServiceCatalogResponse implements
        ToCopyableBuilder<DescribeProductAsAdminResponse.Builder, DescribeProductAsAdminResponse> {
    private static final SdkField<ProductViewDetail> PRODUCT_VIEW_DETAIL_FIELD = SdkField
            .<ProductViewDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProductAsAdminResponse::productViewDetail)).setter(setter(Builder::productViewDetail))
            .constructor(ProductViewDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewDetail").build()).build();

    private static final SdkField<List<ProvisioningArtifactSummary>> PROVISIONING_ARTIFACT_SUMMARIES_FIELD = SdkField
            .<List<ProvisioningArtifactSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductAsAdminResponse::provisioningArtifactSummaries))
            .setter(setter(Builder::provisioningArtifactSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningArtifactSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningArtifactSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductAsAdminResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagOptionDetail>> TAG_OPTIONS_FIELD = SdkField
            .<List<TagOptionDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductAsAdminResponse::tagOptions))
            .setter(setter(Builder::tagOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagOptionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagOptionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField
            .<List<BudgetDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProductAsAdminResponse::budgets))
            .setter(setter(Builder::budgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_DETAIL_FIELD,
            PROVISIONING_ARTIFACT_SUMMARIES_FIELD, TAGS_FIELD, TAG_OPTIONS_FIELD, BUDGETS_FIELD));

    private final ProductViewDetail productViewDetail;

    private final List<ProvisioningArtifactSummary> provisioningArtifactSummaries;

    private final List<Tag> tags;

    private final List<TagOptionDetail> tagOptions;

    private final List<BudgetDetail> budgets;

    private DescribeProductAsAdminResponse(BuilderImpl builder) {
        super(builder);
        this.productViewDetail = builder.productViewDetail;
        this.provisioningArtifactSummaries = builder.provisioningArtifactSummaries;
        this.tags = builder.tags;
        this.tagOptions = builder.tagOptions;
        this.budgets = builder.budgets;
    }

    /**
     * <p>
     * Information about the product view.
     * </p>
     * 
     * @return Information about the product view.
     */
    public ProductViewDetail productViewDetail() {
        return productViewDetail;
    }

    /**
     * Returns true if the ProvisioningArtifactSummaries property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasProvisioningArtifactSummaries() {
        return provisioningArtifactSummaries != null && !(provisioningArtifactSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the provisioning artifacts (also known as versions) for the specified product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProvisioningArtifactSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the provisioning artifacts (also known as versions) for the specified product.
     */
    public List<ProvisioningArtifactSummary> provisioningArtifactSummaries() {
        return provisioningArtifactSummaries;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the tags associated with the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the tags associated with the product.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the TagOptions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTagOptions() {
        return tagOptions != null && !(tagOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the TagOptions associated with the product.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the TagOptions associated with the product.
     */
    public List<TagOptionDetail> tagOptions() {
        return tagOptions;
    }

    /**
     * Returns true if the Budgets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBudgets() {
        return budgets != null && !(budgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associated budgets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBudgets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the associated budgets.
     */
    public List<BudgetDetail> budgets() {
        return budgets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productViewDetail());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningArtifactSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(tagOptions());
        hashCode = 31 * hashCode + Objects.hashCode(budgets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductAsAdminResponse)) {
            return false;
        }
        DescribeProductAsAdminResponse other = (DescribeProductAsAdminResponse) obj;
        return Objects.equals(productViewDetail(), other.productViewDetail())
                && Objects.equals(provisioningArtifactSummaries(), other.provisioningArtifactSummaries())
                && Objects.equals(tags(), other.tags()) && Objects.equals(tagOptions(), other.tagOptions())
                && Objects.equals(budgets(), other.budgets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProductAsAdminResponse").add("ProductViewDetail", productViewDetail())
                .add("ProvisioningArtifactSummaries", provisioningArtifactSummaries()).add("Tags", tags())
                .add("TagOptions", tagOptions()).add("Budgets", budgets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductViewDetail":
            return Optional.ofNullable(clazz.cast(productViewDetail()));
        case "ProvisioningArtifactSummaries":
            return Optional.ofNullable(clazz.cast(provisioningArtifactSummaries()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TagOptions":
            return Optional.ofNullable(clazz.cast(tagOptions()));
        case "Budgets":
            return Optional.ofNullable(clazz.cast(budgets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductAsAdminResponse, T> g) {
        return obj -> g.apply((DescribeProductAsAdminResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProductAsAdminResponse> {
        /**
         * <p>
         * Information about the product view.
         * </p>
         * 
         * @param productViewDetail
         *        Information about the product view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productViewDetail(ProductViewDetail productViewDetail);

        /**
         * <p>
         * Information about the product view.
         * </p>
         * This is a convenience that creates an instance of the {@link ProductViewDetail.Builder} avoiding the need to
         * create one manually via {@link ProductViewDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProductViewDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #productViewDetail(ProductViewDetail)}.
         * 
         * @param productViewDetail
         *        a consumer that will call methods on {@link ProductViewDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productViewDetail(ProductViewDetail)
         */
        default Builder productViewDetail(Consumer<ProductViewDetail.Builder> productViewDetail) {
            return productViewDetail(ProductViewDetail.builder().applyMutation(productViewDetail).build());
        }

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * 
         * @param provisioningArtifactSummaries
         *        Information about the provisioning artifacts (also known as versions) for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * 
         * @param provisioningArtifactSummaries
         *        Information about the provisioning artifacts (also known as versions) for the specified product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningArtifactSummaries(ProvisioningArtifactSummary... provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the provisioning artifacts (also known as versions) for the specified product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProvisioningArtifactSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ProvisioningArtifactSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProvisioningArtifactSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #provisioningArtifactSummaries(List<ProvisioningArtifactSummary>)}.
         * 
         * @param provisioningArtifactSummaries
         *        a consumer that will call methods on {@link List<ProvisioningArtifactSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningArtifactSummaries(List<ProvisioningArtifactSummary>)
         */
        Builder provisioningArtifactSummaries(Consumer<ProvisioningArtifactSummary.Builder>... provisioningArtifactSummaries);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * 
         * @param tags
         *        Information about the tags associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Information about the tags associated with the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(Collection<TagOptionDetail> tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * 
         * @param tagOptions
         *        Information about the TagOptions associated with the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagOptions(TagOptionDetail... tagOptions);

        /**
         * <p>
         * Information about the TagOptions associated with the product.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagOptionDetail>.Builder} avoiding the need
         * to create one manually via {@link List<TagOptionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagOptionDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagOptions(List<TagOptionDetail>)}.
         * 
         * @param tagOptions
         *        a consumer that will call methods on {@link List<TagOptionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagOptions(List<TagOptionDetail>)
         */
        Builder tagOptions(Consumer<TagOptionDetail.Builder>... tagOptions);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(Collection<BudgetDetail> budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * 
         * @param budgets
         *        Information about the associated budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgets(BudgetDetail... budgets);

        /**
         * <p>
         * Information about the associated budgets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BudgetDetail>.Builder} avoiding the need to
         * create one manually via {@link List<BudgetDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BudgetDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #budgets(List<BudgetDetail>)}.
         * 
         * @param budgets
         *        a consumer that will call methods on {@link List<BudgetDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgets(List<BudgetDetail>)
         */
        Builder budgets(Consumer<BudgetDetail.Builder>... budgets);
    }

    static final class BuilderImpl extends ServiceCatalogResponse.BuilderImpl implements Builder {
        private ProductViewDetail productViewDetail;

        private List<ProvisioningArtifactSummary> provisioningArtifactSummaries = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<TagOptionDetail> tagOptions = DefaultSdkAutoConstructList.getInstance();

        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductAsAdminResponse model) {
            super(model);
            productViewDetail(model.productViewDetail);
            provisioningArtifactSummaries(model.provisioningArtifactSummaries);
            tags(model.tags);
            tagOptions(model.tagOptions);
            budgets(model.budgets);
        }

        public final ProductViewDetail.Builder getProductViewDetail() {
            return productViewDetail != null ? productViewDetail.toBuilder() : null;
        }

        @Override
        public final Builder productViewDetail(ProductViewDetail productViewDetail) {
            this.productViewDetail = productViewDetail;
            return this;
        }

        public final void setProductViewDetail(ProductViewDetail.BuilderImpl productViewDetail) {
            this.productViewDetail = productViewDetail != null ? productViewDetail.build() : null;
        }

        public final Collection<ProvisioningArtifactSummary.Builder> getProvisioningArtifactSummaries() {
            return provisioningArtifactSummaries != null ? provisioningArtifactSummaries.stream()
                    .map(ProvisioningArtifactSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifactSummaries(Collection<ProvisioningArtifactSummary> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier.copy(provisioningArtifactSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(ProvisioningArtifactSummary... provisioningArtifactSummaries) {
            provisioningArtifactSummaries(Arrays.asList(provisioningArtifactSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifactSummaries(
                Consumer<ProvisioningArtifactSummary.Builder>... provisioningArtifactSummaries) {
            provisioningArtifactSummaries(Stream.of(provisioningArtifactSummaries)
                    .map(c -> ProvisioningArtifactSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifactSummaries(
                Collection<ProvisioningArtifactSummary.BuilderImpl> provisioningArtifactSummaries) {
            this.provisioningArtifactSummaries = ProvisioningArtifactSummariesCopier
                    .copyFromBuilder(provisioningArtifactSummaries);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<TagOptionDetail.Builder> getTagOptions() {
            return tagOptions != null ? tagOptions.stream().map(TagOptionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptions(Collection<TagOptionDetail> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copy(tagOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(TagOptionDetail... tagOptions) {
            tagOptions(Arrays.asList(tagOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptions(Consumer<TagOptionDetail.Builder>... tagOptions) {
            tagOptions(Stream.of(tagOptions).map(c -> TagOptionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptions(Collection<TagOptionDetail.BuilderImpl> tagOptions) {
            this.tagOptions = TagOptionDetailsCopier.copyFromBuilder(tagOptions);
        }

        public final Collection<BudgetDetail.Builder> getBudgets() {
            return budgets != null ? budgets.stream().map(BudgetDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail... budgets) {
            budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder>... budgets) {
            budgets(Stream.of(budgets).map(c -> BudgetDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public DescribeProductAsAdminResponse build() {
            return new DescribeProductAsAdminResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
