/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.PropertyKey;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPropertiesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisionedProductPropertiesRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProvisionedProductPropertiesRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductPropertiesRequest.getter(UpdateProvisionedProductPropertiesRequest::acceptLanguage)).setter(UpdateProvisionedProductPropertiesRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductPropertiesRequest.getter(UpdateProvisionedProductPropertiesRequest::provisionedProductId)).setter(UpdateProvisionedProductPropertiesRequest.setter(Builder::provisionedProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductId").build()}).build();
    private static final SdkField<Map<String, String>> PROVISIONED_PRODUCT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateProvisionedProductPropertiesRequest.getter(UpdateProvisionedProductPropertiesRequest::provisionedProductPropertiesAsStrings)).setter(UpdateProvisionedProductPropertiesRequest.setter(Builder::provisionedProductPropertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateProvisionedProductPropertiesRequest.getter(UpdateProvisionedProductPropertiesRequest::idempotencyToken)).setter(UpdateProvisionedProductPropertiesRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PROVISIONED_PRODUCT_ID_FIELD, PROVISIONED_PRODUCT_PROPERTIES_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String acceptLanguage;
    private final String provisionedProductId;
    private final Map<String, String> provisionedProductProperties;
    private final String idempotencyToken;

    private UpdateProvisionedProductPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionedProductId = builder.provisionedProductId;
        this.provisionedProductProperties = builder.provisionedProductProperties;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisionedProductId() {
        return this.provisionedProductId;
    }

    public Map<PropertyKey, String> provisionedProductProperties() {
        return ProvisionedProductPropertiesCopier.copyStringToEnum(this.provisionedProductProperties);
    }

    public Map<String, String> provisionedProductPropertiesAsStrings() {
        return this.provisionedProductProperties;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductPropertiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisionedProductPropertiesRequest)) {
            return false;
        }
        UpdateProvisionedProductPropertiesRequest other = (UpdateProvisionedProductPropertiesRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.provisionedProductId(), other.provisionedProductId()) && Objects.equals(this.provisionedProductPropertiesAsStrings(), other.provisionedProductPropertiesAsStrings()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateProvisionedProductPropertiesRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProvisionedProductId", (Object)this.provisionedProductId()).add("ProvisionedProductProperties", this.provisionedProductPropertiesAsStrings()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisionedProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductId()));
            }
            case "ProvisionedProductProperties": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductPropertiesAsStrings()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProvisionedProductPropertiesRequest, T> g) {
        return obj -> g.apply((UpdateProvisionedProductPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionedProductId;
        private Map<String, String> provisionedProductProperties = DefaultSdkAutoConstructMap.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisionedProductPropertiesRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.provisionedProductId(model.provisionedProductId);
            this.provisionedProductPropertiesWithStrings(model.provisionedProductProperties);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionedProductId() {
            return this.provisionedProductId;
        }

        @Override
        public final Builder provisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
            return this;
        }

        public final void setProvisionedProductId(String provisionedProductId) {
            this.provisionedProductId = provisionedProductId;
        }

        public final Map<String, String> getProvisionedProductPropertiesAsStrings() {
            return this.provisionedProductProperties;
        }

        @Override
        public final Builder provisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
            return this;
        }

        @Override
        public final Builder provisionedProductProperties(Map<PropertyKey, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copyEnumToString(provisionedProductProperties);
            return this;
        }

        public final void setProvisionedProductPropertiesWithStrings(Map<String, String> provisionedProductProperties) {
            this.provisionedProductProperties = ProvisionedProductPropertiesCopier.copy(provisionedProductProperties);
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProvisionedProductPropertiesRequest build() {
            return new UpdateProvisionedProductPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProvisionedProductPropertiesRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionedProductId(String var1);

        public Builder provisionedProductPropertiesWithStrings(Map<String, String> var1);

        public Builder provisionedProductProperties(Map<PropertyKey, String> var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

