/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosForProductResponse;

public class ListPortfoliosForProductIterable
implements SdkIterable<ListPortfoliosForProductResponse> {
    private final ServiceCatalogClient client;
    private final ListPortfoliosForProductRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPortfoliosForProductIterable(ServiceCatalogClient client, ListPortfoliosForProductRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPortfoliosForProductResponseFetcher();
    }

    public Iterator<ListPortfoliosForProductResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListPortfoliosForProductIterable resume(ListPortfoliosForProductResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPortfoliosForProductIterable(this.client, (ListPortfoliosForProductRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPortfoliosForProductIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPortfoliosForProductResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPortfoliosForProductResponseFetcher
    implements SyncPageFetcher<ListPortfoliosForProductResponse> {
        private ListPortfoliosForProductResponseFetcher() {
        }

        public boolean hasNextPage(ListPortfoliosForProductResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListPortfoliosForProductResponse nextPage(ListPortfoliosForProductResponse previousPage) {
            if (previousPage == null) {
                return ListPortfoliosForProductIterable.this.client.listPortfoliosForProduct(ListPortfoliosForProductIterable.this.firstRequest);
            }
            return ListPortfoliosForProductIterable.this.client.listPortfoliosForProduct((ListPortfoliosForProductRequest)((Object)ListPortfoliosForProductIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

