/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;

public final class SearchProductsPaginator
implements SdkIterable<SearchProductsResponse> {
    private final ServiceCatalogClient client;
    private final SearchProductsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchProductsPaginator(ServiceCatalogClient client, SearchProductsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchProductsResponseFetcher();
    }

    public Iterator<SearchProductsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchProductsResponseFetcher
    implements NextPageFetcher<SearchProductsResponse> {
        private SearchProductsResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public SearchProductsResponse nextPage(SearchProductsResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsPaginator.this.client.searchProducts(SearchProductsPaginator.this.firstRequest);
            }
            return SearchProductsPaginator.this.client.searchProducts((SearchProductsRequest)((Object)SearchProductsPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

