/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisioningArtifactSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisioningArtifactSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisioningArtifactSummary> {
    private final String id;
    private final String name;
    private final String description;
    private final Instant createdTime;
    private final Map<String, String> provisioningArtifactMetadata;

    private ProvisioningArtifactSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.provisioningArtifactMetadata = builder.provisioningArtifactMetadata;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Map<String, String> provisioningArtifactMetadata() {
        return this.provisioningArtifactMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactSummary)) {
            return false;
        }
        ProvisioningArtifactSummary other = (ProvisioningArtifactSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.provisioningArtifactMetadata(), other.provisioningArtifactMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ProvisioningArtifactSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedTime", (Object)this.createdTime()).add("ProvisioningArtifactMetadata", this.provisioningArtifactMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "CreatedTime": {
                return Optional.of(clazz.cast(this.createdTime()));
            }
            case "ProvisioningArtifactMetadata": {
                return Optional.of(clazz.cast(this.provisioningArtifactMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisioningArtifactSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Instant createdTime;
        private Map<String, String> provisioningArtifactMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.createdTime(model.createdTime);
            this.provisioningArtifactMetadata(model.provisioningArtifactMetadata);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Map<String, String> getProvisioningArtifactMetadata() {
            return this.provisioningArtifactMetadata;
        }

        @Override
        public final Builder provisioningArtifactMetadata(Map<String, String> provisioningArtifactMetadata) {
            this.provisioningArtifactMetadata = ProvisioningArtifactInfoCopier.copy(provisioningArtifactMetadata);
            return this;
        }

        public final void setProvisioningArtifactMetadata(Map<String, String> provisioningArtifactMetadata) {
            this.provisioningArtifactMetadata = ProvisioningArtifactInfoCopier.copy(provisioningArtifactMetadata);
        }

        public ProvisioningArtifactSummary build() {
            return new ProvisioningArtifactSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisioningArtifactSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdTime(Instant var1);

        public Builder provisioningArtifactMetadata(Map<String, String> var1);
    }
}

