/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail;
import software.amazon.awssdk.services.servicecatalog.model.PortfolioDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPortfoliosResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListPortfoliosResponse> {
    private final List<PortfolioDetail> portfolioDetails;
    private final String nextPageToken;

    private ListPortfoliosResponse(BuilderImpl builder) {
        super(builder);
        this.portfolioDetails = builder.portfolioDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<PortfolioDetail> portfolioDetails() {
        return this.portfolioDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfoliosResponse)) {
            return false;
        }
        ListPortfoliosResponse other = (ListPortfoliosResponse)((Object)obj);
        return Objects.equals(this.portfolioDetails(), other.portfolioDetails()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPortfoliosResponse").add("PortfolioDetails", this.portfolioDetails()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortfolioDetails": {
                return Optional.of(clazz.cast(this.portfolioDetails()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<PortfolioDetail> portfolioDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfoliosResponse model) {
            this.portfolioDetails(model.portfolioDetails);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<PortfolioDetail.Builder> getPortfolioDetails() {
            return this.portfolioDetails != null ? (Collection)this.portfolioDetails.stream().map(PortfolioDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portfolioDetails(Collection<PortfolioDetail> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copy(portfolioDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portfolioDetails(PortfolioDetail ... portfolioDetails) {
            this.portfolioDetails(Arrays.asList(portfolioDetails));
            return this;
        }

        public final void setPortfolioDetails(Collection<PortfolioDetail.BuilderImpl> portfolioDetails) {
            this.portfolioDetails = PortfolioDetailsCopier.copyFromBuilder(portfolioDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListPortfoliosResponse build() {
            return new ListPortfoliosResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ListPortfoliosResponse> {
        public Builder portfolioDetails(Collection<PortfolioDetail> var1);

        public Builder portfolioDetails(PortfolioDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

